/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.GlobalBouncyCastleProvider;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import cn.hutool.crypto.asymmetric.AsymmetricCrypto;
import cn.hutool.crypto.asymmetric.KeyType;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class RSA
extends AsymmetricCrypto {
    private static final long serialVersionUID = 1L;
    private static final AsymmetricAlgorithm ALGORITHM_RSA = AsymmetricAlgorithm.RSA_ECB_PKCS1;

    /*
     * WARNING - void declaration
     */
    public static PrivateKey generatePrivateKey(BigInteger modulus, BigInteger privateExponent) {
        void var1_1;
        BigInteger bigInteger;
        return SecureUtil.generatePrivateKey(ALGORITHM_RSA.getValue(), new RSAPrivateKeySpec(bigInteger, (BigInteger)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static PublicKey generatePublicKey(BigInteger modulus, BigInteger publicExponent) {
        void var1_1;
        BigInteger bigInteger;
        return SecureUtil.generatePublicKey(ALGORITHM_RSA.getValue(), new RSAPublicKeySpec(bigInteger, (BigInteger)var1_1));
    }

    public RSA() {
        super(ALGORITHM_RSA);
    }

    /*
     * WARNING - void declaration
     */
    public RSA(String rsaAlgorithm) {
        super((String)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RSA(String privateKeyStr, String publicKeyStr) {
        super(ALGORITHM_RSA, (String)var1_1, (String)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RSA(String rsaAlgorithm, String privateKeyStr, String publicKeyStr) {
        super((String)var1_1, (String)var2_2, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RSA(byte[] privateKey, byte[] publicKey) {
        super(ALGORITHM_RSA, (byte[])var1_1, (byte[])var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RSA(BigInteger modulus, BigInteger privateExponent, BigInteger publicExponent) {
        this(RSA.generatePrivateKey(modulus, (BigInteger)var2_2), RSA.generatePublicKey((BigInteger)var1_1, (BigInteger)var3_3));
        void var3_3;
        void var1_1;
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public RSA(PrivateKey privateKey, PublicKey publicKey) {
        super(ALGORITHM_RSA, (PrivateKey)var1_1, (PublicKey)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RSA(String rsaAlgorithm, PrivateKey privateKey, PublicKey publicKey) {
        super((String)var1_1, (PrivateKey)var2_2, (PublicKey)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) {
        void var2_2;
        void var1_1;
        if (this.encryptBlockSize < 0 && null == GlobalBouncyCastleProvider.INSTANCE.getProvider()) {
            this.encryptBlockSize = ((RSAKey)((Object)this.getKeyByType(keyType))).getModulus().bitLength() / 8 - 11;
        }
        return super.encrypt((byte[])var1_1, (KeyType)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] decrypt(byte[] bytes, KeyType keyType) {
        void var2_2;
        void var1_1;
        if (this.decryptBlockSize < 0 && null == GlobalBouncyCastleProvider.INSTANCE.getProvider()) {
            this.decryptBlockSize = ((RSAKey)((Object)this.getKeyByType(keyType))).getModulus().bitLength() / 8;
        }
        return super.decrypt((byte[])var1_1, (KeyType)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initCipher() {
        try {
            super.initCipher();
            return;
        }
        catch (CryptoException cryptoException) {
            void var1_1;
            CryptoException e = cryptoException;
            Throwable throwable = cryptoException.getCause();
            if (throwable instanceof NoSuchAlgorithmException) {
                this.algorithm = AsymmetricAlgorithm.RSA.getValue();
                super.initCipher();
            }
            throw var1_1;
        }
    }
}

