/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.lang.Assert;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BaseAsymmetric<T extends BaseAsymmetric<T>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String algorithm;
    protected PublicKey publicKey;
    protected PrivateKey privateKey;
    protected final Lock lock = new ReentrantLock();

    /*
     * WARNING - void declaration
     */
    public BaseAsymmetric(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.init((String)var1_1, (PrivateKey)var2_2, (PublicKey)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected T init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        void var1_1;
        this.algorithm = var1_1;
        if (privateKey == null && publicKey == null) {
            this.initKeys();
        } else {
            if (privateKey != null) {
                void var2_2;
                this.privateKey = var2_2;
            }
            if (publicKey != null) {
                void var3_3;
                this.publicKey = var3_3;
            }
        }
        return (T)this;
    }

    /*
     * WARNING - void declaration
     */
    public T initKeys() {
        void var1_1;
        KeyPair keyPair = KeyUtil.generateKeyPair(this.algorithm);
        this.publicKey = keyPair.getPublic();
        this.privateKey = var1_1.getPrivate();
        return (T)this;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    /*
     * WARNING - void declaration
     */
    public String getPublicKeyBase64() {
        void var1_1;
        PublicKey publicKey = this.getPublicKey();
        if (publicKey == null) {
            return null;
        }
        return Base64.encode(var1_1.getEncoded());
    }

    /*
     * WARNING - void declaration
     */
    public T setPublicKey(PublicKey publicKey) {
        void var1_1;
        this.publicKey = var1_1;
        return (T)this;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    /*
     * WARNING - void declaration
     */
    public String getPrivateKeyBase64() {
        void var1_1;
        PrivateKey privateKey = this.getPrivateKey();
        if (privateKey == null) {
            return null;
        }
        return Base64.encode(var1_1.getEncoded());
    }

    /*
     * WARNING - void declaration
     */
    public T setPrivateKey(PrivateKey privateKey) {
        void var1_1;
        this.privateKey = var1_1;
        return (T)this;
    }

    /*
     * WARNING - void declaration
     */
    public T setKey(Key key) {
        void var1_1;
        Assert.notNull(key, "key must be not null !", new Object[0]);
        if (key instanceof PublicKey) {
            return this.setPublicKey((PublicKey)key);
        }
        if (key instanceof PrivateKey) {
            return this.setPrivateKey((PrivateKey)key);
        }
        throw new CryptoException("Unsupported key type: {}", var1_1.getClass());
    }

    /*
     * WARNING - void declaration
     */
    protected Key getKeyByType(KeyType type) {
        void var1_1;
        switch (type) {
            case PrivateKey: {
                if (this.privateKey == null) {
                    throw new NullPointerException("Private key must not null when use it !");
                }
                return this.privateKey;
            }
            case PublicKey: {
                if (this.publicKey == null) {
                    throw new NullPointerException("Public key must not null when use it !");
                }
                return this.publicKey;
            }
        }
        throw new CryptoException("Unsupported key type: " + var1_1);
    }
}

