/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.core.codec.BCD;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import java.io.InputStream;
import java.nio.charset.Charset;

public interface AsymmetricEncryptor {
    public byte[] encrypt(byte[] var1, KeyType var2);

    /*
     * WARNING - void declaration
     */
    default public String encryptHex(byte[] data, KeyType keyType) {
        void var2_2;
        void var1_1;
        return HexUtil.encodeHexStr(this.encrypt((byte[])var1_1, (KeyType)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    default public String encryptBase64(byte[] data, KeyType keyType) {
        void var2_2;
        void var1_1;
        return Base64.encode(this.encrypt((byte[])var1_1, (KeyType)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    default public byte[] encrypt(String data, String charset, KeyType keyType) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.encrypt(StrUtil.bytes((CharSequence)var1_1, (String)var2_2), (KeyType)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    default public byte[] encrypt(String data, Charset charset, KeyType keyType) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.encrypt(StrUtil.bytes((CharSequence)var1_1, (Charset)var2_2), (KeyType)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    default public byte[] encrypt(String data, KeyType keyType) {
        void var2_2;
        void var1_1;
        return this.encrypt(StrUtil.utf8Bytes((CharSequence)var1_1), (KeyType)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public String encryptHex(String data, KeyType keyType) {
        void var2_2;
        void var1_1;
        return HexUtil.encodeHexStr(this.encrypt((String)var1_1, (KeyType)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    default public String encryptHex(String data, Charset charset, KeyType keyType) {
        void var3_3;
        void var2_2;
        void var1_1;
        return HexUtil.encodeHexStr(this.encrypt((String)var1_1, (Charset)var2_2, (KeyType)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    default public String encryptBase64(String data, KeyType keyType) {
        void var2_2;
        void var1_1;
        return Base64.encode(this.encrypt((String)var1_1, (KeyType)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    default public String encryptBase64(String data, Charset charset, KeyType keyType) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Base64.encode(this.encrypt((String)var1_1, (Charset)var2_2, (KeyType)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    default public byte[] encrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return this.encrypt(IoUtil.readBytes((InputStream)var1_1), (KeyType)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public String encryptHex(InputStream data, KeyType keyType) {
        void var2_2;
        void var1_1;
        return HexUtil.encodeHexStr(this.encrypt((InputStream)var1_1, (KeyType)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    default public String encryptBase64(InputStream data, KeyType keyType) {
        void var2_2;
        void var1_1;
        return Base64.encode(this.encrypt((InputStream)var1_1, (KeyType)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    default public String encryptBcd(String data, KeyType keyType) {
        void var2_2;
        void var1_1;
        return this.encryptBcd((String)var1_1, (KeyType)var2_2, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    default public String encryptBcd(String data, KeyType keyType, Charset charset) {
        void var2_2;
        void var3_3;
        void var1_1;
        return BCD.bcdToStr(this.encrypt((String)var1_1, (Charset)var3_3, (KeyType)var2_2));
    }
}

