/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.core.codec.BCD;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import java.io.InputStream;
import java.nio.charset.Charset;

public interface AsymmetricDecryptor {
    public byte[] decrypt(byte[] var1, KeyType var2);

    /*
     * WARNING - void declaration
     */
    default public byte[] decrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        void var2_2;
        void var1_1;
        return this.decrypt(IoUtil.readBytes((InputStream)var1_1), (KeyType)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public byte[] decrypt(String data, KeyType keyType) {
        void var2_2;
        void var1_1;
        return this.decrypt(SecureUtil.decode((String)var1_1), (KeyType)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    default public String decryptStr(String data, KeyType keyType, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        return StrUtil.str(this.decrypt((String)var1_1, (KeyType)var2_2), (Charset)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    default public String decryptStr(String data, KeyType keyType) {
        void var2_2;
        void var1_1;
        return this.decryptStr((String)var1_1, (KeyType)var2_2, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    default public byte[] decryptFromBcd(String data, KeyType keyType) {
        void var2_2;
        void var1_1;
        return this.decryptFromBcd((String)var1_1, (KeyType)var2_2, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    default public byte[] decryptFromBcd(String data, KeyType keyType, Charset charset) {
        void var2_2;
        void var1_1;
        void var3_3;
        Assert.notNull(data, "Bcd string must be not null!", new Object[0]);
        byte[] dataBytes = BCD.ascToBcd(StrUtil.bytes((CharSequence)data, (Charset)var3_3));
        return this.decrypt((byte[])var1_1, (KeyType)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    default public String decryptStrFromBcd(String data, KeyType keyType, Charset charset) {
        void var3_3;
        void var2_2;
        void var1_1;
        return StrUtil.str(this.decryptFromBcd((String)var1_1, (KeyType)var2_2, charset), (Charset)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    default public String decryptStrFromBcd(String data, KeyType keyType) {
        void var2_2;
        void var1_1;
        return this.decryptStrFromBcd((String)var1_1, (KeyType)var2_2, CharsetUtil.CHARSET_UTF_8);
    }
}

