/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.crypto.CipherWrapper;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.AbstractAsymmetricCrypto;
import cn.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import cn.hutool.crypto.asymmetric.KeyType;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class AsymmetricCrypto
extends AbstractAsymmetricCrypto<AsymmetricCrypto> {
    private static final long serialVersionUID = 1L;
    protected CipherWrapper cipherWrapper;
    protected int encryptBlockSize;
    protected int decryptBlockSize;

    /*
     * WARNING - void declaration
     */
    public AsymmetricCrypto(AsymmetricAlgorithm algorithm) {
        this((AsymmetricAlgorithm)var1_1, (byte[])null, (byte[])null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AsymmetricCrypto(String algorithm) {
        this((String)var1_1, (byte[])null, (byte[])null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, String privateKeyStr, String publicKeyStr) {
        this(var1_1.getValue(), SecureUtil.decode((String)var2_2), SecureUtil.decode((String)var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, byte[] privateKey, byte[] publicKey) {
        this(var1_1.getValue(), (byte[])var2_2, (byte[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this(var1_1.getValue(), (PrivateKey)var2_2, (PublicKey)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AsymmetricCrypto(String algorithm, String privateKeyBase64, String publicKeyBase64) {
        this((String)var1_1, Base64.decode((CharSequence)var2_2), Base64.decode((CharSequence)var3_3));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AsymmetricCrypto(String algorithm, byte[] privateKey, byte[] publicKey) {
        void var3_3;
        void var1_1;
        void var2_2;
        String string = algorithm;
        this(string, KeyUtil.generatePrivateKey(string, (byte[])var2_2), KeyUtil.generatePublicKey((String)var1_1, (byte[])var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public AsymmetricCrypto(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super((String)var1_1, (PrivateKey)var2_2, (PublicKey)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.encryptBlockSize = -1;
        this.decryptBlockSize = -1;
    }

    public int getEncryptBlockSize() {
        return this.encryptBlockSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setEncryptBlockSize(int encryptBlockSize) {
        void var1_1;
        this.encryptBlockSize = var1_1;
    }

    public int getDecryptBlockSize() {
        return this.decryptBlockSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setDecryptBlockSize(int decryptBlockSize) {
        void var1_1;
        this.decryptBlockSize = var1_1;
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.cipherWrapper.getParams();
    }

    /*
     * WARNING - void declaration
     */
    public void setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        void var1_1;
        this.cipherWrapper.setParams((AlgorithmParameterSpec)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public AsymmetricCrypto setRandom(SecureRandom random) {
        void var1_1;
        this.cipherWrapper.setRandom((SecureRandom)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AsymmetricCrypto init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.init((String)var1_1, (PrivateKey)var2_2, (PublicKey)var3_3);
        this.initCipher();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            void var1_1;
            int blockSize22;
            Cipher cipher = this.initMode(1, key);
            if (this.encryptBlockSize < 0 && (blockSize22 = cipher.getBlockSize()) > 0) {
                this.encryptBlockSize = blockSize22;
            }
            byte[] blockSize22 = this.doFinal(data, this.encryptBlockSize < 0 ? ((void)var1_1).length : this.encryptBlockSize);
            return blockSize22;
        }
        catch (Exception e) {
            void var2_6;
            throw new CryptoException((Throwable)var2_6);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] decrypt(byte[] data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            void var1_1;
            int blockSize22;
            Cipher cipher = this.initMode(2, key);
            if (this.decryptBlockSize < 0 && (blockSize22 = cipher.getBlockSize()) > 0) {
                this.decryptBlockSize = blockSize22;
            }
            byte[] blockSize22 = this.doFinal(data, this.decryptBlockSize < 0 ? ((void)var1_1).length : this.decryptBlockSize);
            return blockSize22;
        }
        catch (Exception e) {
            void var2_6;
            throw new CryptoException((Throwable)var2_6);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Cipher getCipher() {
        return this.cipherWrapper.getCipher();
    }

    protected void initCipher() {
        this.cipherWrapper = new CipherWrapper(this.algorithm);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] doFinal(byte[] data, int maxBlockSize) throws IllegalBlockSizeException, BadPaddingException, IOException {
        void var2_2;
        void var1_1;
        int dataLength = data.length;
        if (dataLength <= maxBlockSize) {
            void var3_3;
            return this.getCipher().doFinal(data, 0, (int)var3_3);
        }
        return this.doFinalWithBlock((byte[])var1_1, (int)var2_2);
    }

    private byte[] doFinalWithBlock(byte[] data, int maxBlockSize) throws IllegalBlockSizeException, BadPaddingException, IOException {
        int dataLength = data.length;
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        int offSet = 0;
        int remainLength = dataLength;
        while (remainLength > 0) {
            int blockSize = Math.min(remainLength, maxBlockSize);
            out.write(this.getCipher().doFinal(data, offSet, blockSize));
            int n = dataLength - (offSet += blockSize);
        }
        return out.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    private Cipher initMode(int mode, Key key) throws InvalidAlgorithmParameterException, InvalidKeyException {
        void var2_2;
        void var1_1;
        return this.cipherWrapper.initMode((int)var1_1, (Key)var2_2).getCipher();
    }
}

