/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.crypto.BCUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.crypto.digest.HMac;
import cn.hutool.crypto.digest.HmacAlgorithm;
import cn.hutool.crypto.digest.SM3;
import cn.hutool.crypto.digest.mac.BCHMacEngine;
import cn.hutool.crypto.digest.mac.MacEngine;
import cn.hutool.crypto.symmetric.SM4;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class SmUtil {
    private static final int RS_LEN = 32;
    public static final String SM2_CURVE_NAME = "sm2p256v1";
    public static final ECDomainParameters SM2_DOMAIN_PARAMS = BCUtil.toDomainParams(GMNamedCurves.getByName((String)"sm2p256v1"));
    public static final ASN1ObjectIdentifier ID_SM2_PUBLIC_KEY_PARAM = new ASN1ObjectIdentifier("1.2.156.10197.1.301");

    public static SM2 sm2() {
        return new SM2();
    }

    /*
     * WARNING - void declaration
     */
    public static SM2 sm2(String privateKeyStr, String publicKeyStr) {
        void var1_1;
        String string;
        return new SM2(string, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SM2 sm2(byte[] privateKey, byte[] publicKey) {
        void var1_1;
        byte[] byArray;
        return new SM2(byArray, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SM2 sm2(PrivateKey privateKey, PublicKey publicKey) {
        void var1_1;
        PrivateKey privateKey2;
        return new SM2(privateKey2, (PublicKey)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SM2 sm2(ECPrivateKeyParameters privateKeyParams, ECPublicKeyParameters publicKeyParams) {
        void var1_1;
        ECPrivateKeyParameters eCPrivateKeyParameters;
        return new SM2(eCPrivateKeyParameters, (ECPublicKeyParameters)var1_1);
    }

    public static SM3 sm3() {
        return new SM3();
    }

    public static SM3 sm3WithSalt(byte[] salt) {
        byte[] byArray;
        return new SM3(byArray);
    }

    public static String sm3(String data) {
        String string;
        return SmUtil.sm3().digestHex(string);
    }

    public static String sm3(InputStream data) {
        InputStream inputStream;
        return SmUtil.sm3().digestHex(inputStream);
    }

    public static String sm3(File dataFile) {
        File file;
        return SmUtil.sm3().digestHex(file);
    }

    public static SM4 sm4() {
        return new SM4();
    }

    public static SM4 sm4(byte[] key) {
        byte[] byArray;
        return new SM4(byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] changeC1C2C3ToC1C3C2(byte[] c1c2c3, ECDomainParameters ecDomainParameters) {
        void var2_3;
        void var1_2;
        byte[] byArray;
        int c1Len = ((ecDomainParameters.getCurve().getFieldSize() + 7) / 8 << 1) + 1;
        byte[] result = new byte[c1c2c3.length];
        System.arraycopy(c1c2c3, 0, result, 0, c1Len);
        System.arraycopy(c1c2c3, c1c2c3.length - 32, result, c1Len, 32);
        System.arraycopy(c1c2c3, c1Len, result, c1Len + 32, byArray.length - var1_2 - 32);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] changeC1C3C2ToC1C2C3(byte[] c1c3c2, ECDomainParameters ecDomainParameters) {
        void var2_3;
        byte[] byArray;
        void var1_2;
        int c1Len = ((ecDomainParameters.getCurve().getFieldSize() + 7) / 8 << 1) + 1;
        byte[] result = new byte[c1c3c2.length];
        System.arraycopy(c1c3c2, 0, result, 0, c1Len);
        System.arraycopy(c1c3c2, c1Len + 32, result, c1Len, c1c3c2.length - c1Len - 32);
        System.arraycopy(c1c3c2, (int)var1_2, result, byArray.length - 32, 32);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] rsAsn1ToPlain(byte[] rsDer) {
        Object[] objectArray;
        void var1_2;
        Object[] decode;
        try {
            decode = StandardDSAEncoding.INSTANCE.decode(SM2_DOMAIN_PARAMS.getN(), rsDer);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        byte[] r = SmUtil.bigIntToFixedLengthBytes((BigInteger)decode[0]);
        Object[] s = SmUtil.bigIntToFixedLengthBytes((BigInteger)decode[1]);
        return ArrayUtil.addAll(new byte[][]{var1_2, objectArray});
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] rsPlainToAsn1(byte[] sign) {
        if (sign.length != 64) {
            throw new CryptoException("err rs. ");
        }
        BigInteger r = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)0, (int)32));
        Object s = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)32, (int)64));
        try {
            void var1_2;
            return StandardDSAEncoding.INSTANCE.encode(SM2_DOMAIN_PARAMS.getN(), (BigInteger)var1_2, (BigInteger)s);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    public static MacEngine createHmacSm3Engine(byte[] key) {
        byte[] byArray;
        return new BCHMacEngine((Digest)new SM3Digest(), byArray);
    }

    public static HMac hmacSm3(byte[] key) {
        byte[] byArray;
        return new HMac(HmacAlgorithm.HmacSM3, byArray);
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] bigIntToFixedLengthBytes(BigInteger rOrS) {
        Object object;
        byte[] byArray = rOrS.toByteArray();
        Object rs = byArray;
        if (byArray.length == 32) {
            return rs;
        }
        if (((Object)rs).length == 33 && rs[0] == false) {
            return Arrays.copyOfRange((byte[])rs, (int)1, (int)33);
        }
        if (((Object)rs).length < 32) {
            void var1_1;
            byte[] result = new byte[32];
            Arrays.fill((byte[])result, (byte)0);
            System.arraycopy(rs, 0, result, 32 - ((Object)rs).length, ((Object)rs).length);
            return var1_1;
        }
        throw new CryptoException("Error rs: {}", Hex.toHexString((byte[])object));
    }
}

