/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.SystemPropsUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.GlobalBouncyCastleProvider;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.SignUtil;
import cn.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.crypto.asymmetric.Sign;
import cn.hutool.crypto.asymmetric.SignAlgorithm;
import cn.hutool.crypto.digest.DigestAlgorithm;
import cn.hutool.crypto.digest.Digester;
import cn.hutool.crypto.digest.HMac;
import cn.hutool.crypto.digest.HmacAlgorithm;
import cn.hutool.crypto.digest.MD5;
import cn.hutool.crypto.symmetric.AES;
import cn.hutool.crypto.symmetric.DES;
import cn.hutool.crypto.symmetric.DESede;
import cn.hutool.crypto.symmetric.PBKDF2;
import cn.hutool.crypto.symmetric.RC4;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import cn.hutool.crypto.symmetric.ZUC;
import cn.hutool.crypto.symmetric.fpe.FPE;
import java.io.File;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.AlphabetMapper;

public class SecureUtil {
    public static String HUTOOL_CRYPTO_DECODE_HEX = "hutool.crypto.decodeHex";
    public static final int DEFAULT_KEY_SIZE = 1024;

    public static SecretKey generateKey(String algorithm) {
        return KeyUtil.generateKey(algorithm);
    }

    /*
     * WARNING - void declaration
     */
    public static SecretKey generateKey(String algorithm, int keySize) {
        void var1_1;
        return KeyUtil.generateKey(algorithm, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SecretKey generateKey(String algorithm, byte[] key) {
        void var1_1;
        return KeyUtil.generateKey(algorithm, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SecretKey generateDESKey(String algorithm, byte[] key) {
        void var1_1;
        return KeyUtil.generateDESKey(algorithm, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SecretKey generatePBEKey(String algorithm, char[] key) {
        void var1_1;
        return KeyUtil.generatePBEKey(algorithm, (char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SecretKey generateKey(String algorithm, KeySpec keySpec) {
        void var1_1;
        return KeyUtil.generateKey(algorithm, (KeySpec)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static PrivateKey generatePrivateKey(String algorithm, byte[] key) {
        void var1_1;
        return KeyUtil.generatePrivateKey(algorithm, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static PrivateKey generatePrivateKey(String algorithm, KeySpec keySpec) {
        void var1_1;
        return KeyUtil.generatePrivateKey(algorithm, (KeySpec)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static PrivateKey generatePrivateKey(KeyStore keyStore, String alias, char[] password) {
        void var2_2;
        void var1_1;
        return KeyUtil.generatePrivateKey(keyStore, (String)var1_1, (char[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static PublicKey generatePublicKey(String algorithm, byte[] key) {
        void var1_1;
        return KeyUtil.generatePublicKey(algorithm, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static PublicKey generatePublicKey(String algorithm, KeySpec keySpec) {
        void var1_1;
        return KeyUtil.generatePublicKey(algorithm, (KeySpec)var1_1);
    }

    public static KeyPair generateKeyPair(String algorithm) {
        return KeyUtil.generateKeyPair(algorithm);
    }

    /*
     * WARNING - void declaration
     */
    public static KeyPair generateKeyPair(String algorithm, int keySize) {
        void var1_1;
        return KeyUtil.generateKeyPair(algorithm, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed) {
        void var2_2;
        void var1_1;
        return KeyUtil.generateKeyPair(algorithm, (int)var1_1, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static KeyPair generateKeyPair(String algorithm, AlgorithmParameterSpec params) {
        void var1_1;
        return KeyUtil.generateKeyPair(algorithm, (AlgorithmParameterSpec)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static KeyPair generateKeyPair(String algorithm, byte[] seed, AlgorithmParameterSpec params) {
        void var2_2;
        void var1_1;
        return KeyUtil.generateKeyPair(algorithm, (byte[])var1_1, (AlgorithmParameterSpec)var2_2);
    }

    public static String getAlgorithmAfterWith(String algorithm) {
        return KeyUtil.getAlgorithmAfterWith(algorithm);
    }

    /*
     * WARNING - void declaration
     */
    public static String generateAlgorithm(AsymmetricAlgorithm asymmetricAlgorithm, DigestAlgorithm digestAlgorithm) {
        AsymmetricAlgorithm asymmetricAlgorithm2;
        void var1_1;
        String digestPart = digestAlgorithm == null ? "NONE" : digestAlgorithm.name();
        return StrUtil.format("{}with{}", var1_1, asymmetricAlgorithm2.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public static Signature generateSignature(AsymmetricAlgorithm asymmetricAlgorithm, DigestAlgorithm digestAlgorithm) {
        try {
            void var1_2;
            return Signature.getInstance(SecureUtil.generateAlgorithm(asymmetricAlgorithm, (DigestAlgorithm)var1_2));
        }
        catch (NoSuchAlgorithmException e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static KeyStore readJKSKeyStore(InputStream in, char[] password) {
        void var1_1;
        return KeyUtil.readJKSKeyStore(in, (char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static KeyStore readKeyStore(String type, InputStream in, char[] password) {
        void var2_2;
        void var1_1;
        return KeyUtil.readKeyStore(type, (InputStream)var1_1, (char[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Certificate readX509Certificate(InputStream in, char[] password, String alias) {
        void var2_2;
        void var1_1;
        return KeyUtil.readX509Certificate(in, (char[])var1_1, (String)var2_2);
    }

    public static Certificate readX509Certificate(InputStream in) {
        return KeyUtil.readX509Certificate(in);
    }

    /*
     * WARNING - void declaration
     */
    public static Certificate readCertificate(String type, InputStream in, char[] password, String alias) {
        void var3_3;
        void var2_2;
        void var1_1;
        return KeyUtil.readCertificate(type, (InputStream)var1_1, (char[])var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Certificate readCertificate(String type, InputStream in) {
        void var1_1;
        return KeyUtil.readCertificate(type, (InputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Certificate getCertificate(KeyStore keyStore, String alias) {
        void var1_1;
        return KeyUtil.getCertificate(keyStore, (String)var1_1);
    }

    public static AES aes() {
        return new AES();
    }

    public static AES aes(byte[] key) {
        byte[] byArray;
        return new AES(byArray);
    }

    public static DES des() {
        return new DES();
    }

    public static DES des(byte[] key) {
        byte[] byArray;
        return new DES(byArray);
    }

    public static DESede desede() {
        return new DESede();
    }

    public static DESede desede(byte[] key) {
        byte[] byArray;
        return new DESede(byArray);
    }

    public static MD5 md5() {
        return new MD5();
    }

    public static String md5(String data) {
        String string;
        return new MD5().digestHex(string);
    }

    public static String md5(InputStream data) {
        InputStream inputStream;
        return new MD5().digestHex(inputStream);
    }

    public static String md5(File dataFile) {
        File file;
        return new MD5().digestHex(file);
    }

    public static Digester sha1() {
        return new Digester(DigestAlgorithm.SHA1);
    }

    public static String sha1(String data) {
        String string;
        return new Digester(DigestAlgorithm.SHA1).digestHex(string);
    }

    public static String sha1(InputStream data) {
        InputStream inputStream;
        return new Digester(DigestAlgorithm.SHA1).digestHex(inputStream);
    }

    public static String sha1(File dataFile) {
        File file;
        return new Digester(DigestAlgorithm.SHA1).digestHex(file);
    }

    public static Digester sha256() {
        return new Digester(DigestAlgorithm.SHA256);
    }

    public static String sha256(String data) {
        String string;
        return new Digester(DigestAlgorithm.SHA256).digestHex(string);
    }

    public static String sha256(InputStream data) {
        InputStream inputStream;
        return new Digester(DigestAlgorithm.SHA256).digestHex(inputStream);
    }

    public static String sha256(File dataFile) {
        File file;
        return new Digester(DigestAlgorithm.SHA256).digestHex(file);
    }

    /*
     * WARNING - void declaration
     */
    public static HMac hmac(HmacAlgorithm algorithm, String key) {
        void var1_1;
        return SecureUtil.hmac(algorithm, StrUtil.isNotEmpty(key) ? StrUtil.utf8Bytes((CharSequence)var1_1) : null);
    }

    /*
     * WARNING - void declaration
     */
    public static HMac hmac(HmacAlgorithm algorithm, byte[] key) {
        void var1_1;
        HmacAlgorithm hmacAlgorithm;
        if (ArrayUtil.isEmpty(key)) {
            key = SecureUtil.generateKey(algorithm.getValue()).getEncoded();
        }
        return new HMac(hmacAlgorithm, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static HMac hmac(HmacAlgorithm algorithm, SecretKey key) {
        void var1_1;
        HmacAlgorithm hmacAlgorithm;
        if (ObjectUtil.isNull(key)) {
            key = SecureUtil.generateKey(algorithm.getValue());
        }
        return new HMac(hmacAlgorithm, (Key)var1_1);
    }

    public static HMac hmacMd5(String key) {
        String string;
        return SecureUtil.hmacMd5(StrUtil.isNotEmpty(key) ? StrUtil.utf8Bytes(string) : null);
    }

    public static HMac hmacMd5(byte[] key) {
        byte[] byArray;
        if (ArrayUtil.isEmpty(key)) {
            key = SecureUtil.generateKey(HmacAlgorithm.HmacMD5.getValue()).getEncoded();
        }
        return new HMac(HmacAlgorithm.HmacMD5, byArray);
    }

    public static HMac hmacMd5() {
        return new HMac(HmacAlgorithm.HmacMD5);
    }

    public static HMac hmacSha1(String key) {
        String string;
        return SecureUtil.hmacSha1(StrUtil.isNotEmpty(key) ? StrUtil.utf8Bytes(string) : null);
    }

    public static HMac hmacSha1(byte[] key) {
        byte[] byArray;
        if (ArrayUtil.isEmpty(key)) {
            key = SecureUtil.generateKey(HmacAlgorithm.HmacMD5.getValue()).getEncoded();
        }
        return new HMac(HmacAlgorithm.HmacSHA1, byArray);
    }

    public static HMac hmacSha1() {
        return new HMac(HmacAlgorithm.HmacSHA1);
    }

    public static HMac hmacSha256(String key) {
        String string;
        return SecureUtil.hmacSha256(StrUtil.isNotEmpty(key) ? StrUtil.utf8Bytes(string) : null);
    }

    public static HMac hmacSha256(byte[] key) {
        byte[] byArray;
        if (ArrayUtil.isEmpty(key)) {
            key = SecureUtil.generateKey(HmacAlgorithm.HmacMD5.getValue()).getEncoded();
        }
        return new HMac(HmacAlgorithm.HmacSHA256, byArray);
    }

    public static HMac hmacSha256() {
        return new HMac(HmacAlgorithm.HmacSHA256);
    }

    public static RSA rsa() {
        return new RSA();
    }

    /*
     * WARNING - void declaration
     */
    public static RSA rsa(String privateKeyBase64, String publicKeyBase64) {
        void var1_1;
        String string;
        return new RSA(string, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static RSA rsa(byte[] privateKey, byte[] publicKey) {
        void var1_1;
        byte[] byArray;
        return new RSA(byArray, (byte[])var1_1);
    }

    public static Sign sign(SignAlgorithm algorithm) {
        return SignUtil.sign(algorithm);
    }

    /*
     * WARNING - void declaration
     */
    public static Sign sign(SignAlgorithm algorithm, String privateKeyBase64, String publicKeyBase64) {
        void var2_2;
        void var1_1;
        return SignUtil.sign(algorithm, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Sign sign(SignAlgorithm algorithm, byte[] privateKey, byte[] publicKey) {
        void var2_2;
        void var1_1;
        return SignUtil.sign(algorithm, (byte[])var1_1, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String signParams(SymmetricCrypto crypto, Map<?, ?> params, String ... otherParams) {
        void var2_2;
        void var1_1;
        return SignUtil.signParams(crypto, var1_1, (String[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String signParams(SymmetricCrypto crypto, Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        void var3_3;
        void var2_2;
        void var1_1;
        return SignUtil.signParams(crypto, var1_1, (String)var2_2, (String)var3_3, isIgnoreNull, otherParams);
    }

    /*
     * WARNING - void declaration
     */
    public static String signParamsMd5(Map<?, ?> params, String ... otherParams) {
        void var1_1;
        return SignUtil.signParamsMd5(params, (String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String signParamsSha1(Map<?, ?> params, String ... otherParams) {
        void var1_1;
        return SignUtil.signParamsSha1(params, (String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String signParamsSha256(Map<?, ?> params, String ... otherParams) {
        void var1_1;
        return SignUtil.signParamsSha256(params, (String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String signParams(DigestAlgorithm digestAlgorithm, Map<?, ?> params, String ... otherParams) {
        void var2_2;
        void var1_1;
        return SignUtil.signParams(digestAlgorithm, var1_1, (String[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String signParams(DigestAlgorithm digestAlgorithm, Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull, String ... otherParams) {
        void var3_3;
        void var2_2;
        void var1_1;
        return SignUtil.signParams(digestAlgorithm, var1_1, (String)var2_2, (String)var3_3, isIgnoreNull, otherParams);
    }

    public static void addProvider(Provider provider) {
        Security.insertProviderAt(provider, 0);
    }

    public static byte[] decode(String key) {
        String string;
        boolean bl = SystemPropsUtil.getBoolean(HUTOOL_CRYPTO_DECODE_HEX, true);
        if (bl && Validator.isHex(key)) {
            return HexUtil.decodeHex(key);
        }
        return Base64.decode(string);
    }

    /*
     * WARNING - void declaration
     */
    public static Cipher createCipher(String algorithm) {
        Cipher cipher;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            void var1_2;
            Cipher cipher2 = provider == null ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, (Provider)var1_2);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return cipher;
    }

    /*
     * WARNING - void declaration
     */
    public static MessageDigest createMessageDigest(String algorithm) {
        MessageDigest messageDigest;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            void var1_2;
            MessageDigest messageDigest2 = provider == null ? MessageDigest.getInstance(algorithm) : MessageDigest.getInstance(algorithm, (Provider)var1_2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return messageDigest;
    }

    /*
     * WARNING - void declaration
     */
    public static MessageDigest createJdkMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Mac createMac(String algorithm) {
        Mac mac;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            void var1_2;
            Mac mac2 = provider == null ? Mac.getInstance(algorithm) : Mac.getInstance(algorithm, (Provider)var1_2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return mac;
    }

    /*
     * WARNING - void declaration
     */
    public static Signature createSignature(String algorithm) {
        Signature signature;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            void var1_2;
            Signature signature2 = provider == null ? Signature.getInstance(algorithm) : Signature.getInstance(algorithm, (Provider)var1_2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return signature;
    }

    public static RC4 rc4(String key) {
        String string;
        return new RC4(string);
    }

    public static void disableBouncyCastle() {
        GlobalBouncyCastleProvider.setUseBouncyCastle(false);
    }

    /*
     * WARNING - void declaration
     */
    public static String pbkdf2(char[] password, byte[] salt) {
        void var1_1;
        char[] cArray;
        return new PBKDF2().encryptHex(cArray, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static FPE fpe(FPE.FPEMode mode, byte[] key, AlphabetMapper mapper, byte[] tweak) {
        void var3_3;
        void var2_2;
        void var1_1;
        FPE.FPEMode fPEMode;
        return new FPE(fPEMode, (byte[])var1_1, (AlphabetMapper)var2_2, (byte[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static ZUC zuc128(byte[] key, byte[] iv) {
        void var1_1;
        byte[] byArray;
        return new ZUC(ZUC.ZUCAlgorithm.ZUC_128, byArray, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ZUC zuc256(byte[] key, byte[] iv) {
        void var1_1;
        byte[] byArray;
        return new ZUC(ZUC.ZUCAlgorithm.ZUC_256, byArray, (byte[])var1_1);
    }
}

