/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.ECKeyUtil;
import cn.hutool.crypto.KeyUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;

public class PemUtil {
    public static PrivateKey readPemPrivateKey(InputStream pemStream) {
        return (PrivateKey)PemUtil.readPemKey(pemStream);
    }

    public static PublicKey readPemPublicKey(InputStream pemStream) {
        return (PublicKey)PemUtil.readPemKey(pemStream);
    }

    /*
     * WARNING - void declaration
     */
    public static Key readPemKey(InputStream keyStream) {
        InputStream object = PemUtil.readPemObject(keyStream);
        String type = object.getType();
        if (StrUtil.isNotBlank(type)) {
            void var1_1;
            if (type.endsWith("EC PRIVATE KEY")) {
                try {
                    return KeyUtil.generatePrivateKey("EC", object.getContent());
                }
                catch (Exception exception) {
                    return KeyUtil.generatePrivateKey("EC", ECKeyUtil.createOpenSSHPrivateKeySpec(object.getContent()));
                }
            }
            if (type.endsWith("PRIVATE KEY")) {
                return KeyUtil.generateRSAPrivateKey(object.getContent());
            }
            if (type.endsWith("EC PUBLIC KEY")) {
                try {
                    return KeyUtil.generatePublicKey("EC", object.getContent());
                }
                catch (Exception exception) {
                    return KeyUtil.generatePublicKey("EC", ECKeyUtil.createOpenSSHPublicKeySpec(object.getContent()));
                }
            }
            if (type.endsWith("PUBLIC KEY")) {
                return KeyUtil.generateRSAPublicKey(object.getContent());
            }
            if (var1_1.endsWith("CERTIFICATE")) {
                InputStream inputStream;
                return KeyUtil.readPublicKeyFromCert(IoUtil.toStream(inputStream.getContent()));
            }
        }
        return null;
    }

    public static byte[] readPem(InputStream keyStream) {
        InputStream pemObject = PemUtil.readPemObject(keyStream);
        if (pemObject != null) {
            InputStream inputStream;
            return inputStream.getContent();
        }
        return null;
    }

    public static PemObject readPemObject(InputStream keyStream) {
        return PemUtil.readPemObject(IoUtil.getUtf8Reader(keyStream));
    }

    /*
     * WARNING - void declaration
     */
    public static PemObject readPemObject(Reader reader) {
        PemReader pemReader = null;
        try {
            pemReader = new PemReader(reader);
            reader = pemReader.readPemObject();
        }
        catch (IOException e) {
            try {
                void var0_1;
                throw new IORuntimeException((Throwable)var0_1);
            }
            catch (Throwable throwable) {
                void var1_3;
                IoUtil.close((Closeable)var1_3);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)pemReader);
        return reader;
    }

    @Deprecated
    public static PrivateKey readSm2PemPrivateKey(InputStream keyStream) {
        return PemUtil.readPemPrivateKey(keyStream);
    }

    /*
     * WARNING - void declaration
     */
    public static String toPem(String type, byte[] content) {
        void var2_2;
        void var1_1;
        String string;
        StringWriter stringWriter = new StringWriter();
        PemUtil.writePemObject(string, (byte[])var1_1, stringWriter);
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static void writePemObject(String type, byte[] content, OutputStream keyStream) {
        void var2_2;
        void var1_1;
        String string;
        PemUtil.writePemObject((PemObjectGenerator)new PemObject(string, (byte[])var1_1), (OutputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void writePemObject(String type, byte[] content, Writer writer) {
        void var2_2;
        void var1_1;
        String string;
        PemUtil.writePemObject((PemObjectGenerator)new PemObject(string, (byte[])var1_1), (Writer)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void writePemObject(PemObjectGenerator pemObject, OutputStream keyStream) {
        void var1_1;
        PemUtil.writePemObject(pemObject, IoUtil.getUtf8Writer((OutputStream)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static void writePemObject(PemObjectGenerator pemObject, Writer writer) {
        PemWriter pemWriter = new PemWriter(writer);
        try {
            pemWriter.writeObject(pemObject);
        }
        catch (IOException e) {
            try {
                void var0_1;
                throw new IORuntimeException((Throwable)var0_1);
            }
            catch (Throwable throwable) {
                void var1_3;
                IoUtil.close((Closeable)var1_3);
                throw throwable;
            }
        }
        IoUtil.close((Closeable)pemWriter);
        return;
    }
}

