/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.GlobalBouncyCastleProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.X509TrustedCertificateBlock;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;

public class OpensslKeyUtil {
    private static final JcaPEMKeyConverter pemKeyConverter = new JcaPEMKeyConverter().setProvider(GlobalBouncyCastleProvider.INSTANCE.getProvider());

    /*
     * WARNING - void declaration
     */
    public static PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws CryptoException {
        try {
            return pemKeyConverter.getPrivateKey(privateKeyInfo);
        }
        catch (PEMException e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static PublicKey getPublicKey(SubjectPublicKeyInfo publicKeyInfo) throws CryptoException {
        try {
            return pemKeyConverter.getPublicKey(publicKeyInfo);
        }
        catch (PEMException e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static KeyPair getKeyPair(PEMKeyPair keyPair) throws CryptoException {
        try {
            return pemKeyConverter.getKeyPair(keyPair);
        }
        catch (PEMException e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Key readPemKey(InputStream keyStream, char[] password) {
        Serializable serializable;
        InputStream pemParser2 = new PEMParser((Reader)new InputStreamReader(keyStream));
        Throwable throwable = null;
        try {
            serializable = OpensslKeyUtil.readPemKeyFromKeyObject(pemParser2.readObject(), (char[])serializable);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    serializable = throwable2;
                    throwable = throwable2;
                    throw serializable;
                }
                catch (Throwable throwable3) {
                    if (throwable != null) {
                        try {
                            pemParser2.close();
                        }
                        catch (Throwable pemParser2) {
                            throwable.addSuppressed(pemParser2);
                        }
                    } else {
                        pemParser2.close();
                    }
                    throw throwable3;
                }
            }
            catch (IOException e) {
                void var0_2;
                throw new CryptoException((Throwable)var0_2);
            }
        }
        pemParser2.close();
        return serializable;
    }

    /*
     * WARNING - void declaration
     */
    public static PrivateKeyInfo decrypt(PKCS8EncryptedPrivateKeyInfo pkcs8Info, char[] password) throws CryptoException {
        try {
            void var1_2;
            InputDecryptorProvider decryptProvider = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider(GlobalBouncyCastleProvider.INSTANCE.getProvider()).build(password);
            return pkcs8Info.decryptPrivateKeyInfo((InputDecryptorProvider)var1_2);
        }
        catch (OperatorCreationException | PKCSException e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static PEMKeyPair decrypt(PEMEncryptedKeyPair pemEncryptedKeyPair, char[] password) throws IORuntimeException {
        try {
            void var1_2;
            PEMDecryptorProvider decryptProvider = new JcePEMDecryptorProviderBuilder().setProvider(GlobalBouncyCastleProvider.INSTANCE.getProvider()).build(password);
            return pemEncryptedKeyPair.decryptKeyPair((PEMDecryptorProvider)var1_2);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Key readPemKeyFromKeyObject(Object keyObject, char[] password) throws CryptoException {
        Object object;
        if (keyObject instanceof PrivateKeyInfo) {
            return OpensslKeyUtil.getPrivateKey((PrivateKeyInfo)keyObject);
        }
        if (keyObject instanceof PEMKeyPair) {
            return OpensslKeyUtil.getKeyPair((PEMKeyPair)keyObject).getPrivate();
        }
        if (keyObject instanceof PKCS8EncryptedPrivateKeyInfo) {
            return OpensslKeyUtil.getPrivateKey(OpensslKeyUtil.decrypt((PKCS8EncryptedPrivateKeyInfo)keyObject, password));
        }
        if (keyObject instanceof PEMEncryptedKeyPair) {
            void var1_1;
            return OpensslKeyUtil.getPrivateKey(OpensslKeyUtil.decrypt((PEMEncryptedKeyPair)keyObject, (char[])var1_1).getPrivateKeyInfo());
        }
        if (keyObject instanceof SubjectPublicKeyInfo) {
            return OpensslKeyUtil.getPublicKey((SubjectPublicKeyInfo)keyObject);
        }
        if (keyObject instanceof X509CertificateHolder) {
            return OpensslKeyUtil.getPublicKey(((X509CertificateHolder)keyObject).getSubjectPublicKeyInfo());
        }
        if (keyObject instanceof X509TrustedCertificateBlock) {
            return OpensslKeyUtil.getPublicKey(((X509TrustedCertificateBlock)keyObject).getCertificateHolder().getSubjectPublicKeyInfo());
        }
        if (keyObject instanceof PKCS10CertificationRequest) {
            return OpensslKeyUtil.getPublicKey(((PKCS10CertificationRequest)keyObject).getSubjectPublicKeyInfo());
        }
        throw new CryptoException("Unsupported key object type: {}", object.getClass());
    }
}

