/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.BCUtil;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.GlobalBouncyCastleProvider;
import cn.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class KeyUtil {
    public static final String KEY_TYPE_JKS = "JKS";
    public static final String KEY_TYPE_JCEKS = "jceks";
    public static final String KEY_TYPE_PKCS12 = "pkcs12";
    public static final String CERT_TYPE_X509 = "X.509";
    public static final int DEFAULT_KEY_SIZE = 1024;
    public static final String SM2_DEFAULT_CURVE = "sm2p256v1";

    public static SecretKey generateKey(String algorithm) {
        return KeyUtil.generateKey(algorithm, -1);
    }

    /*
     * WARNING - void declaration
     */
    public static SecretKey generateKey(String algorithm, int keySize) {
        void var1_1;
        return KeyUtil.generateKey(algorithm, (int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static SecretKey generateKey(String algorithm, int keySize, SecureRandom random) {
        void var3_3;
        String string;
        algorithm = KeyUtil.getMainAlgorithm(algorithm);
        KeyGenerator keyGenerator = KeyUtil.getKeyGenerator(algorithm);
        if (keySize <= 0 && SymmetricAlgorithm.AES.getValue().equals(string)) {
            keySize = 128;
        }
        if (keySize > 0) {
            if (random == null) {
                keyGenerator.init(keySize);
            } else {
                void var2_2;
                void var1_1;
                keyGenerator.init((int)var1_1, (SecureRandom)var2_2);
            }
        }
        return var3_3.generateKey();
    }

    /*
     * WARNING - void declaration
     */
    public static SecretKey generateKey(String algorithm, byte[] key) {
        SecretKey secretKey;
        void var1_1;
        Assert.notBlank(algorithm, "Algorithm is blank!", new Object[0]);
        secretKey = algorithm.startsWith("PBE") ? KeyUtil.generatePBEKey(algorithm, key == null ? null : StrUtil.utf8Str(key).toCharArray()) : (algorithm.startsWith("DES") ? KeyUtil.generateDESKey(algorithm, key) : (key == null ? KeyUtil.generateKey(algorithm) : new SecretKeySpec((byte[])var1_1, (String)((Object)secretKey))));
        return secretKey;
    }

    /*
     * WARNING - void declaration
     */
    public static SecretKey generateDESKey(String algorithm, byte[] key) {
        Object object;
        Object secretKey;
        if (StrUtil.isBlank(algorithm) || !algorithm.startsWith("DES")) {
            throw new CryptoException("Algorithm [{}] is not a DES algorithm!", algorithm);
        }
        if (key == null) {
            secretKey = KeyUtil.generateKey(algorithm);
        } else {
            void var1_2;
            try {
                KeySpec keySpec;
                keySpec = ((String)secretKey).startsWith("DESede") ? new DESedeKeySpec(key) : new DESKeySpec((byte[])keySpec);
            }
            catch (InvalidKeyException e) {
                throw new CryptoException(e);
            }
            secretKey = KeyUtil.generateKey((String)e, (KeySpec)var1_2);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static SecretKey generatePBEKey(String algorithm, char[] key) {
        void var1_1;
        String string;
        if (StrUtil.isBlank(algorithm) || !algorithm.startsWith("PBE")) {
            throw new CryptoException("Algorithm [{}] is not a PBE algorithm!", algorithm);
        }
        if (key == null) {
            key = RandomUtil.randomString(32).toCharArray();
        }
        PBEKeySpec keySpec = new PBEKeySpec(key);
        return KeyUtil.generateKey(string, (KeySpec)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SecretKey generateKey(String algorithm, KeySpec keySpec) {
        SecretKeyFactory keyFactory = KeyUtil.getSecretKeyFactory(algorithm);
        try {
            void var1_2;
            return keyFactory.generateSecret((KeySpec)var1_2);
        }
        catch (InvalidKeySpecException e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    public static PrivateKey generateRSAPrivateKey(byte[] key) {
        byte[] byArray;
        return KeyUtil.generatePrivateKey(AsymmetricAlgorithm.RSA.getValue(), byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static PrivateKey generatePrivateKey(String algorithm, byte[] key) {
        void var1_1;
        String string;
        if (key == null) {
            return null;
        }
        return KeyUtil.generatePrivateKey(string, new PKCS8EncodedKeySpec((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static PrivateKey generatePrivateKey(String algorithm, KeySpec keySpec) {
        if (keySpec == null) {
            return null;
        }
        algorithm = KeyUtil.getAlgorithmAfterWith(algorithm);
        try {
            void var1_2;
            return KeyUtil.getKeyFactory(algorithm).generatePrivate((KeySpec)var1_2);
        }
        catch (Exception e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static PrivateKey generatePrivateKey(KeyStore keyStore, String alias, char[] password) {
        try {
            void var2_3;
            void var1_2;
            return (PrivateKey)keyStore.getKey((String)var1_2, (char[])var2_3);
        }
        catch (Exception e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    public static PublicKey generateRSAPublicKey(byte[] key) {
        byte[] byArray;
        return KeyUtil.generatePublicKey(AsymmetricAlgorithm.RSA.getValue(), byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static PublicKey generatePublicKey(String algorithm, byte[] key) {
        void var1_1;
        String string;
        if (key == null) {
            return null;
        }
        return KeyUtil.generatePublicKey(string, new X509EncodedKeySpec((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static PublicKey generatePublicKey(String algorithm, KeySpec keySpec) {
        if (keySpec == null) {
            return null;
        }
        algorithm = KeyUtil.getAlgorithmAfterWith(algorithm);
        try {
            void var1_2;
            return KeyUtil.getKeyFactory(algorithm).generatePublic((KeySpec)var1_2);
        }
        catch (Exception e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static KeyPair generateKeyPair(String algorithm) {
        void var1_1;
        String string;
        int keySize = 1024;
        if ("ECIES".equalsIgnoreCase(algorithm)) {
            keySize = 256;
        }
        return KeyUtil.generateKeyPair(string, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static KeyPair generateKeyPair(String algorithm, int keySize) {
        void var1_1;
        return KeyUtil.generateKeyPair(algorithm, (int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed) {
        void var2_2;
        void var1_1;
        String string;
        if ("SM2".equalsIgnoreCase(algorithm)) {
            void var3_3;
            ECGenParameterSpec sm2p256v1 = new ECGenParameterSpec(SM2_DEFAULT_CURVE);
            return KeyUtil.generateKeyPair(algorithm, keySize, seed, new AlgorithmParameterSpec[]{var3_3});
        }
        return KeyUtil.generateKeyPair(string, (int)var1_1, (byte[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static KeyPair generateKeyPair(String algorithm, AlgorithmParameterSpec params) {
        void var1_1;
        return KeyUtil.generateKeyPair(algorithm, null, (AlgorithmParameterSpec)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static KeyPair generateKeyPair(String algorithm, byte[] seed, AlgorithmParameterSpec param) {
        void var2_2;
        void var1_1;
        return KeyUtil.generateKeyPair(algorithm, 1024, (byte[])var1_1, new AlgorithmParameterSpec[]{var2_2});
    }

    /*
     * WARNING - void declaration
     */
    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed, AlgorithmParameterSpec ... params) {
        void var3_3;
        void var2_2;
        void var1_1;
        return KeyUtil.generateKeyPair(algorithm, (int)var1_1, RandomUtil.createSecureRandom((byte[])var2_2), (AlgorithmParameterSpec[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static KeyPair generateKeyPair(String algorithm, int keySize, SecureRandom random, AlgorithmParameterSpec ... params) {
        algorithm = KeyUtil.getAlgorithmAfterWith(algorithm);
        KeyPairGenerator keyPairGen = KeyUtil.getKeyPairGenerator(algorithm);
        if (keySize > 0) {
            if ("EC".equalsIgnoreCase(algorithm) && keySize > 256) {
                keySize = 256;
            }
            if (random != null) {
                keyPairGen.initialize(keySize, random);
            } else {
                int n;
                keyPairGen.initialize(n);
            }
        }
        if (ArrayUtil.isNotEmpty(params)) {
            void var3_4;
            for (String param : var3_4) {
                if (param == null) continue;
                try {
                    if (random != null) {
                        keyPairGen.initialize((AlgorithmParameterSpec)((Object)param), random);
                        continue;
                    }
                    keyPairGen.initialize((AlgorithmParameterSpec)((Object)param));
                }
                catch (InvalidAlgorithmParameterException e) {
                    void var0_1;
                    throw new CryptoException((Throwable)var0_1);
                }
            }
        }
        return keyPairGen.generateKeyPair();
    }

    /*
     * WARNING - void declaration
     */
    public static KeyPairGenerator getKeyPairGenerator(String algorithm) {
        KeyPairGenerator keyPairGenerator;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            void var1_2;
            KeyPairGenerator keyPairGen = provider == null ? KeyPairGenerator.getInstance(KeyUtil.getMainAlgorithm(algorithm)) : KeyPairGenerator.getInstance(KeyUtil.getMainAlgorithm(algorithm), (Provider)var1_2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return keyPairGenerator;
    }

    /*
     * WARNING - void declaration
     */
    public static KeyFactory getKeyFactory(String algorithm) {
        KeyFactory keyFactory;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            void var1_2;
            KeyFactory keyFactory2 = provider == null ? KeyFactory.getInstance(KeyUtil.getMainAlgorithm(algorithm)) : KeyFactory.getInstance(KeyUtil.getMainAlgorithm(algorithm), (Provider)var1_2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return keyFactory;
    }

    /*
     * WARNING - void declaration
     */
    public static SecretKeyFactory getSecretKeyFactory(String algorithm) {
        SecretKeyFactory secretKeyFactory;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            void var1_2;
            SecretKeyFactory keyFactory = provider == null ? SecretKeyFactory.getInstance(KeyUtil.getMainAlgorithm(algorithm)) : SecretKeyFactory.getInstance(KeyUtil.getMainAlgorithm(algorithm), (Provider)var1_2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return secretKeyFactory;
    }

    /*
     * WARNING - void declaration
     */
    public static KeyGenerator getKeyGenerator(String algorithm) {
        KeyGenerator keyGenerator;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            void var1_2;
            KeyGenerator generator = provider == null ? KeyGenerator.getInstance(KeyUtil.getMainAlgorithm(algorithm)) : KeyGenerator.getInstance(KeyUtil.getMainAlgorithm(algorithm), (Provider)var1_2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return keyGenerator;
    }

    /*
     * WARNING - void declaration
     */
    public static String getMainAlgorithm(String algorithm) {
        String string;
        Assert.notBlank(algorithm, "Algorithm must be not blank!", new Object[0]);
        int slashIndex = algorithm.indexOf(47);
        if (slashIndex > 0) {
            void var1_1;
            return algorithm.substring(0, (int)var1_1);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String getAlgorithmAfterWith(String algorithm) {
        String string;
        Assert.notNull(algorithm, "algorithm must be not null !", new Object[0]);
        if (StrUtil.startWithIgnoreCase(algorithm, "ECIESWith")) {
            return "EC";
        }
        int indexOfWith = StrUtil.lastIndexOfIgnoreCase(algorithm, "with");
        if (indexOfWith > 0) {
            void var1_1;
            algorithm = StrUtil.subSuf(algorithm, (int)(var1_1 + 4));
        }
        if ("ECDSA".equalsIgnoreCase(algorithm) || "SM2".equalsIgnoreCase(algorithm) || "ECIES".equalsIgnoreCase(algorithm)) {
            algorithm = "EC";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static KeyStore readJKSKeyStore(File keyFile, char[] password) {
        void var1_1;
        File file;
        return KeyUtil.readKeyStore(KEY_TYPE_JKS, file, (char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static KeyStore readJKSKeyStore(InputStream in, char[] password) {
        void var1_1;
        InputStream inputStream;
        return KeyUtil.readKeyStore(KEY_TYPE_JKS, inputStream, (char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static KeyStore readPKCS12KeyStore(File keyFile, char[] password) {
        void var1_1;
        File file;
        return KeyUtil.readKeyStore(KEY_TYPE_PKCS12, file, (char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static KeyStore readPKCS12KeyStore(InputStream in, char[] password) {
        void var1_1;
        InputStream inputStream;
        return KeyUtil.readKeyStore(KEY_TYPE_PKCS12, inputStream, (char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static KeyStore readKeyStore(String type, File keyFile, char[] password) {
        KeyStore keyStore;
        BufferedInputStream in = null;
        try {
            void var2_3;
            void var1_2;
            in = FileUtil.getInputStream((File)var1_2);
            keyStore = KeyUtil.readKeyStore((String)((Object)keyStore), in, (char[])var2_3);
        }
        catch (Throwable throwable) {
            void var3_4;
            IoUtil.close((Closeable)var3_4);
            throw throwable;
        }
        IoUtil.close(in);
        return keyStore;
    }

    /*
     * WARNING - void declaration
     */
    public static KeyStore readKeyStore(String type, InputStream in, char[] password) {
        KeyStore keyStore;
        KeyStore keyStore2 = KeyUtil.getKeyStore(type);
        try {
            void var2_3;
            void var1_2;
            keyStore2.load((InputStream)var1_2, (char[])var2_3);
        }
        catch (Exception e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
        return keyStore;
    }

    /*
     * WARNING - void declaration
     */
    public static KeyStore getKeyStore(String type) {
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            void var1_2;
            if (provider == null) {
                return KeyStore.getInstance(type);
            }
            return KeyStore.getInstance(type, (Provider)var1_2);
        }
        catch (KeyStoreException e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static KeyPair getKeyPair(String type, InputStream in, char[] password, String alias) {
        void var3_3;
        void var2_2;
        void var1_1;
        KeyStore keyStore = KeyUtil.readKeyStore(type, (InputStream)var1_1, password);
        return KeyUtil.getKeyPair(keyStore, (char[])var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static KeyPair getKeyPair(KeyStore keyStore, char[] password, String alias) {
        PrivateKey privateKey;
        void var3_4;
        try {
            void var1_2;
            void var2_3;
            PublicKey publicKey = keyStore.getCertificate(alias).getPublicKey();
            PrivateKey privateKey2 = (PrivateKey)keyStore.getKey((String)var2_3, (char[])var1_2);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return new KeyPair((PublicKey)var3_4, privateKey);
    }

    /*
     * WARNING - void declaration
     */
    public static Certificate readX509Certificate(InputStream in, char[] password, String alias) {
        void var2_2;
        void var1_1;
        InputStream inputStream;
        return KeyUtil.readCertificate(CERT_TYPE_X509, inputStream, (char[])var1_1, (String)var2_2);
    }

    public static PublicKey readPublicKeyFromCert(InputStream in) {
        Certificate certificate = KeyUtil.readX509Certificate(in);
        if (certificate != null) {
            Certificate certificate2;
            return certificate2.getPublicKey();
        }
        return null;
    }

    public static Certificate readX509Certificate(InputStream in) {
        InputStream inputStream;
        return KeyUtil.readCertificate(CERT_TYPE_X509, inputStream);
    }

    /*
     * WARNING - void declaration
     */
    public static Certificate readCertificate(String type, InputStream in, char[] password, String alias) {
        void var2_3;
        void var1_2;
        KeyStore keyStore = KeyUtil.readKeyStore(type, (InputStream)var1_2, (char[])var2_3);
        try {
            void var3_4;
            return keyStore.getCertificate((String)var3_4);
        }
        catch (KeyStoreException e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Certificate readCertificate(String type, InputStream in) {
        try {
            void var1_2;
            return KeyUtil.getCertificateFactory(type).generateCertificate((InputStream)var1_2);
        }
        catch (CertificateException e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Certificate getCertificate(KeyStore keyStore, String alias) {
        try {
            void var1_2;
            return keyStore.getCertificate((String)var1_2);
        }
        catch (Exception e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static CertificateFactory getCertificateFactory(String type) {
        CertificateFactory certificateFactory;
        Provider provider = GlobalBouncyCastleProvider.INSTANCE.getProvider();
        try {
            void var1_2;
            CertificateFactory factory = provider == null ? CertificateFactory.getInstance(type) : CertificateFactory.getInstance(type, (Provider)var1_2);
        }
        catch (CertificateException e) {
            throw new CryptoException(e);
        }
        return certificateFactory;
    }

    public static byte[] encodeECPublicKey(PublicKey publicKey) {
        return BCUtil.encodeECPublicKey(publicKey);
    }

    /*
     * WARNING - void declaration
     */
    public static PublicKey decodeECPoint(String encode, String curveName) {
        void var1_1;
        return BCUtil.decodeECPoint(encode, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static PublicKey decodeECPoint(byte[] encodeByte, String curveName) {
        void var1_1;
        return BCUtil.decodeECPoint(encodeByte, (String)var1_1);
    }

    public static PublicKey getRSAPublicKey(PrivateKey privateKey) {
        if (privateKey instanceof RSAPrivateCrtKey) {
            PrivateKey privateKey2;
            PrivateKey privk = (RSAPrivateCrtKey)privateKey;
            return KeyUtil.getRSAPublicKey(privk.getModulus(), privateKey2.getPublicExponent());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static PublicKey getRSAPublicKey(String modulus, String publicExponent) {
        void var1_1;
        String string;
        return KeyUtil.getRSAPublicKey(new BigInteger(string, 16), new BigInteger((String)var1_1, 16));
    }

    /*
     * WARNING - void declaration
     */
    public static PublicKey getRSAPublicKey(BigInteger modulus, BigInteger publicExponent) {
        void var1_2;
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modulus, (BigInteger)var1_2);
        try {
            return KeyUtil.getKeyFactory("RSA").generatePublic(publicKeySpec);
        }
        catch (InvalidKeySpecException e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    public static String toBase64(Key key) {
        return Base64.encode(key.getEncoded());
    }
}

