/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.crypto.ProviderFactory;
import java.security.Provider;

public enum GlobalBouncyCastleProvider {
    INSTANCE;

    private Provider provider;
    private static boolean useBouncyCastle;

    private GlobalBouncyCastleProvider() {
        try {
            this.provider = ProviderFactory.createBouncyCastleProvider();
            return;
        }
        catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
            return;
        }
    }

    public final Provider getProvider() {
        if (useBouncyCastle) {
            return this.provider;
        }
        return null;
    }

    public static void setUseBouncyCastle(boolean isUseBouncyCastle) {
        useBouncyCastle = isUseBouncyCastle;
    }

    static {
        useBouncyCastle = true;
    }
}

