/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.crypto.CryptoException;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.SmUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.util.BigIntegers;

public class ECKeyUtil {
    public static AsymmetricKeyParameter toParams(Key key) {
        if (key instanceof PrivateKey) {
            return ECKeyUtil.toPrivateParams((PrivateKey)key);
        }
        if (key instanceof PublicKey) {
            Key key2;
            return ECKeyUtil.toPublicParams((PublicKey)key2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKeyParameters getPublicParams(ECPrivateKeyParameters privateKeyParameters) {
        void var1_1;
        ECPrivateKeyParameters eCPrivateKeyParameters;
        ECDomainParameters domainParameters = privateKeyParameters.getParameters();
        ECPrivateKeyParameters q = new FixedPointCombMultiplier().multiply(domainParameters.getG(), privateKeyParameters.getD());
        return new ECPublicKeyParameters((ECPoint)eCPrivateKeyParameters, (ECDomainParameters)var1_1);
    }

    public static ECPublicKeyParameters toSm2PublicParams(byte[] q) {
        return ECKeyUtil.toPublicParams(q, SmUtil.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(String q) {
        return ECKeyUtil.toPublicParams(q, SmUtil.SM2_DOMAIN_PARAMS);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKeyParameters toSm2PublicParams(String x, String y) {
        void var1_1;
        return ECKeyUtil.toPublicParams(x, (String)var1_1, SmUtil.SM2_DOMAIN_PARAMS);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKeyParameters toSm2PublicParams(byte[] xBytes, byte[] yBytes) {
        void var1_1;
        return ECKeyUtil.toPublicParams(xBytes, (byte[])var1_1, SmUtil.SM2_DOMAIN_PARAMS);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKeyParameters toPublicParams(String x, String y, ECDomainParameters domainParameters) {
        void var2_2;
        void var1_1;
        return ECKeyUtil.toPublicParams(SecureUtil.decode(x), SecureUtil.decode((String)var1_1), (ECDomainParameters)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKeyParameters toPublicParams(byte[] xBytes, byte[] yBytes, ECDomainParameters domainParameters) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        if (xBytes == null || yBytes == null) {
            return null;
        }
        return ECKeyUtil.toPublicParams(BigIntegers.fromUnsignedByteArray((byte[])byArray), BigIntegers.fromUnsignedByteArray((byte[])var1_1), (ECDomainParameters)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKeyParameters toPublicParams(BigInteger x, BigInteger y, ECDomainParameters domainParameters) {
        void var2_2;
        void var1_1;
        BigInteger bigInteger;
        if (x == null || y == null) {
            return null;
        }
        ECCurve eCCurve = domainParameters.getCurve();
        return ECKeyUtil.toPublicParams(eCCurve.createPoint(bigInteger, (BigInteger)var1_1), (ECDomainParameters)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKeyParameters toPublicParams(String pointEncoded, ECDomainParameters domainParameters) {
        void var1_1;
        String string;
        ECCurve eCCurve = domainParameters.getCurve();
        return ECKeyUtil.toPublicParams(eCCurve.decodePoint(SecureUtil.decode(string)), (ECDomainParameters)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKeyParameters toPublicParams(byte[] pointEncoded, ECDomainParameters domainParameters) {
        void var1_1;
        byte[] byArray;
        ECCurve eCCurve = domainParameters.getCurve();
        return ECKeyUtil.toPublicParams(eCCurve.decodePoint(byArray), (ECDomainParameters)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKeyParameters toPublicParams(ECPoint point, ECDomainParameters domainParameters) {
        void var1_1;
        ECPoint eCPoint;
        return new ECPublicKeyParameters(eCPoint, (ECDomainParameters)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKeyParameters toPublicParams(PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        try {
            return (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter((PublicKey)publicKey);
        }
        catch (InvalidKeyException e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(String d) {
        return ECKeyUtil.toPrivateParams(d, SmUtil.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(byte[] d) {
        return ECKeyUtil.toPrivateParams(d, SmUtil.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(BigInteger d) {
        return ECKeyUtil.toPrivateParams(d, SmUtil.SM2_DOMAIN_PARAMS);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPrivateKeyParameters toPrivateParams(String d, ECDomainParameters domainParameters) {
        void var1_1;
        String string;
        if (d == null) {
            return null;
        }
        return ECKeyUtil.toPrivateParams(BigIntegers.fromUnsignedByteArray((byte[])SecureUtil.decode(string)), (ECDomainParameters)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPrivateKeyParameters toPrivateParams(byte[] d, ECDomainParameters domainParameters) {
        void var1_1;
        return ECKeyUtil.toPrivateParams(BigIntegers.fromUnsignedByteArray((byte[])d), (ECDomainParameters)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPrivateKeyParameters toPrivateParams(BigInteger d, ECDomainParameters domainParameters) {
        void var1_1;
        BigInteger bigInteger;
        if (d == null) {
            return null;
        }
        return new ECPrivateKeyParameters(bigInteger, (ECDomainParameters)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPrivateKeyParameters toPrivateParams(PrivateKey privateKey) {
        if (privateKey == null) {
            return null;
        }
        try {
            return (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)privateKey);
        }
        catch (InvalidKeyException e) {
            void var0_1;
            throw new CryptoException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static PrivateKey toSm2PrivateKey(ECPrivateKey privateKey) {
        try {
            ECPrivateKey info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)SmUtil.ID_SM2_PUBLIC_KEY_PARAM), (ASN1Encodable)privateKey);
            return KeyUtil.generatePrivateKey("SM2", info.getEncoded());
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    public static KeySpec createOpenSSHPrivateKeySpec(byte[] key) {
        byte[] byArray;
        return new OpenSSHPrivateKeySpec(byArray);
    }

    public static KeySpec createOpenSSHPublicKeySpec(byte[] key) {
        byte[] byArray;
        return new OpenSSHPublicKeySpec(byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPrivateKeyParameters decodePrivateKeyParams(byte[] privateKeyBytes) {
        try {
            return ECKeyUtil.toSm2PrivateParams(privateKeyBytes);
        }
        catch (Exception exception) {
            void var1_1;
            PrivateKey privateKey;
            try {
                privateKey = KeyUtil.generatePrivateKey("sm2", privateKeyBytes);
            }
            catch (Exception exception2) {
                byte[] byArray;
                privateKey = KeyUtil.generatePrivateKey("sm2", ECKeyUtil.createOpenSSHPrivateKeySpec(byArray));
            }
            return ECKeyUtil.toPrivateParams((PrivateKey)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKeyParameters decodePublicKeyParams(byte[] publicKeyBytes) {
        try {
            return ECKeyUtil.toSm2PublicParams(publicKeyBytes);
        }
        catch (Exception exception) {
            void var1_1;
            PublicKey publicKey;
            try {
                publicKey = KeyUtil.generatePublicKey("sm2", publicKeyBytes);
            }
            catch (Exception exception2) {
                byte[] byArray;
                publicKey = KeyUtil.generatePublicKey("sm2", ECKeyUtil.createOpenSSHPublicKeySpec(byArray));
            }
            return ECKeyUtil.toPublicParams((PublicKey)var1_1);
        }
    }
}

