/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.crypto.ECKeyUtil;
import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.PemUtil;
import cn.hutool.crypto.SecureUtil;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;

public class BCUtil {
    public static byte[] encodeECPrivateKey(PrivateKey privateKey) {
        return ((BCECPrivateKey)privateKey).getD().toByteArray();
    }

    public static byte[] encodeECPublicKey(PublicKey publicKey) {
        return BCUtil.encodeECPublicKey(publicKey, true);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] encodeECPublicKey(PublicKey publicKey, boolean isCompressed) {
        void var1_1;
        return ((BCECPublicKey)publicKey).getQ().getEncoded((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static PublicKey decodeECPoint(String encode, String curveName) {
        void var1_1;
        return BCUtil.decodeECPoint(SecureUtil.decode(encode), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static PublicKey decodeECPoint(byte[] encodeByte, String curveName) {
        void var1_1;
        Object object;
        void var2_2;
        void var3_3;
        X9ECParameters x9ECParameters = ECUtil.getNamedCurveByName((String)curveName);
        ECCurve curve = x9ECParameters.getCurve();
        Object point = EC5Util.convertPoint((org.bouncycastle.math.ec.ECPoint)curve.decodePoint(encodeByte));
        ECNamedCurveSpec ecSpec = new ECNamedCurveSpec(curveName, (ECCurve)var3_3, x9ECParameters.getG(), var2_2.getN());
        return KeyUtil.generatePublicKey("EC", new ECPublicKeySpec((ECPoint)object, (ECParameterSpec)var1_1));
    }

    public static ECDomainParameters toDomainParams(org.bouncycastle.jce.spec.ECParameterSpec parameterSpec) {
        org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec;
        return new ECDomainParameters(parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), eCParameterSpec.getH());
    }

    public static ECDomainParameters toDomainParams(String curveName) {
        return BCUtil.toDomainParams(ECUtil.getNamedCurveByName((String)curveName));
    }

    public static ECDomainParameters toDomainParams(X9ECParameters x9ECParameters) {
        X9ECParameters x9ECParameters2;
        return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters2.getH());
    }

    public static AsymmetricKeyParameter toParams(Key key) {
        return ECKeyUtil.toParams(key);
    }

    public static ECPrivateKeyParameters toSm2Params(String d) {
        return ECKeyUtil.toSm2PrivateParams(d);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPrivateKeyParameters toParams(String dHex, ECDomainParameters domainParameters) {
        void var1_1;
        return ECKeyUtil.toPrivateParams(dHex, (ECDomainParameters)var1_1);
    }

    public static ECPrivateKeyParameters toSm2Params(byte[] d) {
        return ECKeyUtil.toSm2PrivateParams(d);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPrivateKeyParameters toParams(byte[] d, ECDomainParameters domainParameters) {
        void var1_1;
        return ECKeyUtil.toPrivateParams(d, (ECDomainParameters)var1_1);
    }

    public static ECPrivateKeyParameters toSm2Params(BigInteger d) {
        return ECKeyUtil.toSm2PrivateParams(d);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPrivateKeyParameters toParams(BigInteger d, ECDomainParameters domainParameters) {
        void var1_1;
        return ECKeyUtil.toPrivateParams(d, (ECDomainParameters)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKeyParameters toParams(BigInteger x, BigInteger y, ECDomainParameters domainParameters) {
        void var2_2;
        void var1_1;
        return ECKeyUtil.toPublicParams(x, (BigInteger)var1_1, (ECDomainParameters)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKeyParameters toSm2Params(String xHex, String yHex) {
        void var1_1;
        return ECKeyUtil.toSm2PublicParams(xHex, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKeyParameters toParams(String xHex, String yHex, ECDomainParameters domainParameters) {
        void var2_2;
        void var1_1;
        return ECKeyUtil.toPublicParams(xHex, (String)var1_1, (ECDomainParameters)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKeyParameters toSm2Params(byte[] xBytes, byte[] yBytes) {
        void var1_1;
        return ECKeyUtil.toSm2PublicParams(xBytes, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static ECPublicKeyParameters toParams(byte[] xBytes, byte[] yBytes, ECDomainParameters domainParameters) {
        void var2_2;
        void var1_1;
        return ECKeyUtil.toPublicParams(xBytes, (byte[])var1_1, (ECDomainParameters)var2_2);
    }

    public static ECPublicKeyParameters toParams(PublicKey publicKey) {
        return ECKeyUtil.toPublicParams(publicKey);
    }

    public static ECPrivateKeyParameters toParams(PrivateKey privateKey) {
        return ECKeyUtil.toPrivateParams(privateKey);
    }

    public static PrivateKey readPemPrivateKey(InputStream pemStream) {
        return PemUtil.readPemPrivateKey(pemStream);
    }

    public static PublicKey readPemPublicKey(InputStream pemStream) {
        return PemUtil.readPemPublicKey(pemStream);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toPkcs1(PrivateKey privateKey) {
        PrivateKey pkInfo = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded());
        try {
            return pkInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toPkcs1(PublicKey publicKey) {
        PublicKey spkInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        try {
            return spkInfo.parsePublicKey().getEncoded();
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }
}

