/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.crypto.CryptoException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.util.ASN1Dump;

public class ASN1Util {
    public static byte[] encodeDer(ASN1Encodable ... elements) {
        ASN1Encodable[] aSN1EncodableArray;
        return ASN1Util.encode("DER", aSN1EncodableArray);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] encode(String asn1Encoding, ASN1Encodable ... elements) {
        void var2_2;
        void var1_1;
        String string;
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        ASN1Util.encodeTo(string, out, (ASN1Encodable[])var1_1);
        return var2_2.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static void encodeTo(String asn1Encoding, OutputStream out, ASN1Encodable ... elements) {
        switch (asn1Encoding) {
            case "DER": {
                String sequence = new DERSequence(elements);
                break;
            }
            case "BER": {
                String sequence = new BERSequence(elements);
                break;
            }
            case "DL": {
                void var2_2;
                String sequence = new DLSequence((ASN1Encodable[])var2_2);
                break;
            }
            default: {
                String sequence;
                throw new CryptoException("Unsupported ASN1 encoding: {}", sequence);
            }
        }
        try {
            void var1_1;
            String string;
            string.encodeTo((OutputStream)var1_1);
            return;
        }
        catch (IOException e) {
            void var3_4;
            throw new IORuntimeException((Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ASN1Object decode(InputStream in) {
        InputStream asn1In = new ASN1InputStream(in);
        try {
            return asn1In.readObject();
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    public static String getDumpStr(InputStream in) {
        return ASN1Dump.dumpAsString((Object)ASN1Util.decode(in));
    }
}

