/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.timingwheel;

import cn.hutool.cron.timingwheel.TimerTask;
import cn.hutool.cron.timingwheel.TimerTaskList;
import cn.hutool.log.StaticLog;
import java.util.function.Consumer;

public class TimingWheel {
    private final long tickMs;
    private final int wheelSize;
    private final long interval;
    private final TimerTaskList[] timerTaskLists;
    private long currentTime;
    private volatile TimingWheel overflowWheel;
    private final Consumer<TimerTaskList> consumer;

    /*
     * WARNING - void declaration
     */
    public TimingWheel(long tickMs, int wheelSize, Consumer<TimerTaskList> consumer) {
        this((long)var1_1, (int)var3_2, System.currentTimeMillis(), consumer);
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TimingWheel(long tickMs, int wheelSize, long currentTime, Consumer<TimerTaskList> consumer) {
        void var1_1;
        void var3_2;
        this.tickMs = tickMs;
        this.wheelSize = wheelSize;
        this.interval = tickMs * (long)wheelSize;
        this.timerTaskLists = new TimerTaskList[var3_2];
        this.initTimerTaskList();
        long l = currentTime;
        this.currentTime = l - l % var1_1;
        this.consumer = consumer;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addTask(TimerTask timerTask) {
        long expiration = timerTask.getDelayMs();
        if (expiration < this.currentTime + this.tickMs) {
            return false;
        }
        if (expiration < this.currentTime + this.interval) {
            long virtualId = expiration / this.tickMs;
            int index = (int)(virtualId % (long)this.wheelSize);
            StaticLog.debug("tickMs: {} ------index: {} ------expiration: {}", this.tickMs, index, expiration);
            TimerTaskList timerTaskList = this.timerTaskLists[index];
            timerTaskList.addTask(timerTask);
            if (timerTaskList.setExpiration(virtualId * this.tickMs)) {
                void var2_3;
                this.consumer.accept((TimerTaskList)var2_3);
            }
        } else {
            void var1_1;
            TimingWheel timingWheel = this.getOverflowWheel();
            timingWheel.addTask((TimerTask)var1_1);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void advanceClock(long timestamp) {
        if (timestamp >= this.currentTime + this.tickMs) {
            long l = timestamp;
            this.currentTime = l - l % this.tickMs;
            if (this.overflowWheel != null) {
                void var1_1;
                this.getOverflowWheel().advanceClock((long)var1_1);
            }
        }
    }

    private TimingWheel getOverflowWheel() {
        if (this.overflowWheel == null) {
            TimingWheel timingWheel = this;
            synchronized (timingWheel) {
                if (this.overflowWheel == null) {
                    this.overflowWheel = new TimingWheel(this.interval, this.wheelSize, this.currentTime, this.consumer);
                }
            }
        }
        return this.overflowWheel;
    }

    private void initTimerTaskList() {
        for (int i = 0; i < this.timerTaskLists.length; ++i) {
            this.timerTaskLists[i] = new TimerTaskList();
        }
    }
}

