/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.timingwheel;

import cn.hutool.cron.timingwheel.TimerTask;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class TimerTaskList
implements Delayed {
    private final AtomicLong expire = new AtomicLong(-1L);
    private final TimerTask root;

    public TimerTaskList() {
        this.root.prev = this.root = new TimerTask(null, -1L);
        this.root.next = this.root;
    }

    /*
     * WARNING - void declaration
     */
    public boolean setExpiration(long expire) {
        void var1_1;
        return this.expire.getAndSet(expire) != var1_1;
    }

    public long getExpire() {
        return this.expire.get();
    }

    /*
     * WARNING - void declaration
     */
    public void addTask(TimerTask timerTask) {
        TimerTaskList timerTaskList = this;
        synchronized (timerTaskList) {
            if (timerTask.timerTaskList == null) {
                void var1_1;
                timerTask.timerTaskList = this;
                TimerTask tail = this.root.prev;
                timerTask.next = this.root;
                timerTask.prev = tail;
                var3_4.next = timerTask;
                this.root.prev = var1_1;
            }
            return;
        }
    }

    public void removeTask(TimerTask timerTask) {
        TimerTaskList timerTaskList = this;
        synchronized (timerTaskList) {
            if (this.equals(timerTask.timerTaskList)) {
                timerTask.next.prev = timerTask.prev;
                timerTask.prev.next = timerTask.next;
                timerTask.timerTaskList = null;
                timerTask.next = null;
                var1_1.prev = null;
            }
            return;
        }
    }

    public synchronized void flush(Consumer<TimerTask> flush) {
        TimerTask timerTask = this.root.next;
        while (!timerTask.equals(this.root)) {
            this.removeTask(timerTask);
            flush.accept(timerTask);
            timerTask = this.root.next;
        }
        this.expire.set(-1L);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getDelay(TimeUnit unit) {
        void var1_1;
        return Math.max(0L, var1_1.convert(this.expire.get() - System.currentTimeMillis(), TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(Delayed o) {
        if (o instanceof TimerTaskList) {
            void var1_1;
            return Long.compare(this.expire.get(), ((TimerTaskList)var1_1).expire.get());
        }
        return 0;
    }
}

