/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.timingwheel;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.cron.timingwheel.TimerTask;
import cn.hutool.cron.timingwheel.TimerTaskList;
import cn.hutool.cron.timingwheel.TimingWheel;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class SystemTimer {
    private final TimingWheel timeWheel;
    private final DelayQueue<TimerTaskList> delayQueue = new DelayQueue();
    private long delayQueueTimeout = 100L;
    private ExecutorService bossThreadPool;
    private volatile boolean isRunning;

    public SystemTimer() {
        this.timeWheel = new TimingWheel(1L, 20, this.delayQueue::offer);
    }

    /*
     * WARNING - void declaration
     */
    public SystemTimer setDelayQueueTimeout(long delayQueueTimeout) {
        void var1_1;
        this.delayQueueTimeout = var1_1;
        return this;
    }

    public SystemTimer start() {
        this.bossThreadPool = ThreadUtil.newSingleExecutor();
        this.isRunning = true;
        this.bossThreadPool.submit(() -> {
            while (this.advanceClock()) {
            }
        });
        return this;
    }

    public void stop() {
        this.isRunning = false;
        this.bossThreadPool.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    public void addTask(TimerTask timerTask) {
        if (!this.timeWheel.addTask(timerTask)) {
            void var1_1;
            ThreadUtil.execAsync(var1_1.getTask());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean advanceClock() {
        if (!this.isRunning) {
            return false;
        }
        try {
            TimerTaskList timerTaskList = this.poll();
            if (timerTaskList != null) {
                void var1_1;
                this.timeWheel.advanceClock(timerTaskList.getExpire());
                var1_1.flush(this::addTask);
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private TimerTaskList poll() throws InterruptedException {
        if (this.delayQueueTimeout > 0L) {
            return (TimerTaskList)this.delayQueue.poll(this.delayQueueTimeout, TimeUnit.MILLISECONDS);
        }
        return (TimerTaskList)this.delayQueue.poll();
    }
}

