/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern.parser;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronException;
import cn.hutool.cron.pattern.Part;
import cn.hutool.cron.pattern.matcher.AlwaysTrueMatcher;
import cn.hutool.cron.pattern.matcher.PartMatcher;
import cn.hutool.cron.pattern.matcher.PatternMatcher;
import cn.hutool.cron.pattern.parser.PartParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PatternParser {
    private static final PartParser SECOND_VALUE_PARSER = PartParser.of(Part.SECOND);
    private static final PartParser MINUTE_VALUE_PARSER = PartParser.of(Part.MINUTE);
    private static final PartParser HOUR_VALUE_PARSER = PartParser.of(Part.HOUR);
    private static final PartParser DAY_OF_MONTH_VALUE_PARSER = PartParser.of(Part.DAY_OF_MONTH);
    private static final PartParser MONTH_VALUE_PARSER = PartParser.of(Part.MONTH);
    private static final PartParser DAY_OF_WEEK_VALUE_PARSER = PartParser.of(Part.DAY_OF_WEEK);
    private static final PartParser YEAR_VALUE_PARSER = PartParser.of(Part.YEAR);

    public static List<PatternMatcher> parse(String cronPattern) {
        return PatternParser.parseGroupPattern(cronPattern);
    }

    /*
     * WARNING - void declaration
     */
    private static List<PatternMatcher> parseGroupPattern(String groupPattern) {
        void var1_1;
        Iterator iterator;
        Iterator patternList = StrUtil.splitTrim((CharSequence)groupPattern, '|');
        ArrayList<PatternMatcher> patternMatchers = new ArrayList<PatternMatcher>(patternList.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            String pattern = (String)iterator.next();
            patternMatchers.add(PatternParser.parseSingle((String)var2_2));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static PatternMatcher parseSingle(String pattern) {
        void var3_4;
        void var0_1;
        void var1_2;
        void var2_3;
        String[] parts = pattern.split("\\s+");
        Assert.checkBetween(parts.length, 5, 7, () -> {
            String string;
            return new CronException("Pattern [{}] is invalid, it must be 5-7 parts!", string);
        });
        int offset = 0;
        if (parts.length == 6 || parts.length == 7) {
            offset = 1;
        }
        String secondPart = 1 == offset ? parts[0] : "0";
        PartMatcher yearMatcher = parts.length == 7 ? YEAR_VALUE_PARSER.parse(parts[6]) : AlwaysTrueMatcher.INSTANCE;
        return new PatternMatcher(SECOND_VALUE_PARSER.parse((String)var2_3), MINUTE_VALUE_PARSER.parse(parts[offset]), HOUR_VALUE_PARSER.parse(parts[offset + 1]), DAY_OF_MONTH_VALUE_PARSER.parse(parts[offset + 2]), MONTH_VALUE_PARSER.parse(parts[offset + 3]), DAY_OF_WEEK_VALUE_PARSER.parse((String)var1_2[var0_1 + 4]), (PartMatcher)var3_4);
    }
}

