/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern.parser;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.Month;
import cn.hutool.core.date.Week;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronException;
import cn.hutool.cron.pattern.Part;
import cn.hutool.cron.pattern.matcher.AlwaysTrueMatcher;
import cn.hutool.cron.pattern.matcher.BoolArrayMatcher;
import cn.hutool.cron.pattern.matcher.DayOfMonthMatcher;
import cn.hutool.cron.pattern.matcher.PartMatcher;
import cn.hutool.cron.pattern.matcher.YearValueMatcher;
import java.util.ArrayList;
import java.util.List;

public class PartParser {
    private final Part part;

    public static PartParser of(Part part) {
        Part part2;
        return new PartParser(part2);
    }

    /*
     * WARNING - void declaration
     */
    public PartParser(Part part) {
        void var1_1;
        this.part = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PartMatcher parse(String value) {
        void var2_2;
        if (PartParser.isMatchAllStr(value)) {
            return new AlwaysTrueMatcher();
        }
        List<Integer> values = this.parseArray(value);
        if (values.isEmpty()) {
            void var1_1;
            throw new CronException("Invalid part value: [{}]", var1_1);
        }
        switch (this.part) {
            case DAY_OF_MONTH: {
                return new DayOfMonthMatcher(values);
            }
            case YEAR: {
                return new YearValueMatcher(values);
            }
        }
        return new BoolArrayMatcher((List<Integer>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private List<Integer> parseArray(String value) {
        void var2_2;
        Object object;
        ArrayList values = new ArrayList();
        object = StrUtil.split((CharSequence)object, ',');
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            String part = (String)object.next();
            CollUtil.addAllIfNotContains(values, this.parseStep((String)var3_3));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private List<Integer> parseStep(String value) {
        void var1_1;
        List<Integer> results;
        List<String> parts = StrUtil.split((CharSequence)value, '/');
        int size = parts.size();
        if (size == 1) {
            results = this.parseRange(value, -1);
        } else if (size == 2) {
            void var3_3;
            void var2_2;
            int step = this.parseNumber(parts.get(1), false);
            if (step <= 0) {
                throw new CronException("Non positive divisor for field: [{}]", results);
            }
            results = this.parseRange((String)var2_2.get(0), (int)var3_3);
        } else {
            throw new CronException("Invalid syntax of field: [{}]", results);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private List<Integer> parseRange(String value, int step) {
        void var3_6;
        void i2;
        ArrayList<Integer> results = new ArrayList<Integer>();
        if (value.length() <= 2) {
            int minValue = this.part.getMin();
            if (!PartParser.isMatchAllStr(value)) {
                minValue = Math.max(minValue, this.parseNumber(value, true));
            } else if (step <= 0) {
                step = 1;
            }
            if (step > 0) {
                int maxValue = this.part.getMax();
                if (minValue > maxValue) {
                    throw new CronException("Invalid value {} > {}", minValue, maxValue);
                }
                for (int i2 = minValue; i2 <= maxValue; i2 += step) {
                    results.add(i2);
                }
            } else {
                results.add(minValue);
            }
            return results;
        }
        List<String> parts = StrUtil.split((CharSequence)i2, '-');
        int size = parts.size();
        if (size == 1) {
            int v1 = this.parseNumber((String)i2, true);
            if (step > 0) {
                NumberUtil.appendRange(v1, this.part.getMax(), step, results);
            } else {
                results.add(v1);
            }
        } else if (size == 2) {
            int v1 = this.parseNumber(parts.get(0), true);
            int v2 = this.parseNumber(parts.get(1), true);
            if (step <= 0) {
                step = 1;
            }
            if (v1 <= v2) {
                NumberUtil.appendRange(v1, v2, step, results);
            } else {
                void var2_5;
                void var1_4;
                NumberUtil.appendRange((int)var1_4, this.part.getMax(), step, results);
                NumberUtil.appendRange(this.part.getMin(), v2, (int)var2_5, results);
            }
        } else {
            void var1_1;
            throw new CronException("Invalid syntax of field: [{}]", var1_1);
        }
        return var3_6;
    }

    private static boolean isMatchAllStr(String value) {
        String string;
        return 1 == value.length() && ("*".equals(value) || "?".equals(string));
    }

    /*
     * WARNING - void declaration
     */
    private int parseNumber(String value, boolean checkValue) throws CronException {
        void var3_3;
        void var2_2;
        int i;
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            i = this.parseAlias((String)var1_1);
        }
        if (i < 0) {
            i += this.part.getMax();
        }
        if (Part.DAY_OF_WEEK.equals((Object)this.part) && Week.SUNDAY.getIso8601Value() == i) {
            i = Week.SUNDAY.ordinal();
        }
        if (var2_2 != false) {
            return this.part.checkValue(i);
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private int parseAlias(String name) throws CronException {
        void var1_1;
        if ("L".equalsIgnoreCase(name)) {
            return this.part.getMax();
        }
        switch (this.part) {
            case MONTH: {
                return Month.of(name).getValueBaseOne();
            }
            case DAY_OF_WEEK: {
                return Week.of(name).ordinal();
            }
        }
        throw new CronException("Invalid alias value: [{}]", var1_1);
    }
}

