/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern.matcher;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.Month;
import cn.hutool.cron.pattern.Part;
import cn.hutool.cron.pattern.matcher.AlwaysTrueMatcher;
import cn.hutool.cron.pattern.matcher.BoolArrayMatcher;
import cn.hutool.cron.pattern.matcher.DayOfMonthMatcher;
import cn.hutool.cron.pattern.matcher.PartMatcher;
import java.time.Year;
import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;

public class PatternMatcher {
    private final PartMatcher[] matchers;

    /*
     * WARNING - void declaration
     */
    public PatternMatcher(PartMatcher secondMatcher, PartMatcher minuteMatcher, PartMatcher hourMatcher, PartMatcher dayOfMonthMatcher, PartMatcher monthMatcher, PartMatcher dayOfWeekMatcher, PartMatcher yearMatcher) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.matchers = new PartMatcher[]{var1_1, var2_2, var3_3, dayOfMonthMatcher, monthMatcher, dayOfWeekMatcher, yearMatcher};
    }

    /*
     * WARNING - void declaration
     */
    public PartMatcher get(Part part) {
        void var1_1;
        return this.matchers[var1_1.ordinal()];
    }

    /*
     * WARNING - void declaration
     */
    public boolean match(int[] fields) {
        void var1_1;
        return this.match(fields[0], fields[1], fields[2], fields[3], fields[4], fields[5], (int)var1_1[6]);
    }

    /*
     * WARNING - void declaration
     */
    public boolean matchWeek(int dayOfWeekValue) {
        void var1_1;
        return this.matchers[5].match((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean match(int second, int minute, int hour, int dayOfMonth, int month, int dayOfWeek, int year) {
        void var3_3;
        void var2_2;
        void var1_1;
        return (second < 0 || this.matchers[0].match((int)var1_1)) && this.matchers[1].match((int)var2_2) && this.matchers[2].match((int)var3_3) && PatternMatcher.matchDayOfMonth(this.matchers[3], dayOfMonth, month, Year.isLeap(year)) && this.matchers[4].match(month) && this.matchers[5].match(dayOfWeek) && this.matchers[6].match(year);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean matchDayOfMonth(PartMatcher matcher, int dayOfMonth, int month, boolean isLeapYear) {
        void var1_1;
        PartMatcher partMatcher;
        if (matcher instanceof DayOfMonthMatcher) {
            void var3_3;
            void var2_2;
            return ((DayOfMonthMatcher)matcher).match(dayOfMonth, (int)var2_2, (boolean)var3_3);
        }
        return partMatcher.match((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Calendar nextMatchAfter(int[] values, TimeZone zone) {
        void var2_2;
        Calendar calendar = Calendar.getInstance(zone);
        calendar.set(14, 0);
        int[] newValues = this.nextMatchValuesAfter(values);
        for (int i = 0; i < newValues.length; ++i) {
            if (i == Part.DAY_OF_WEEK.ordinal()) continue;
            this.setValue(calendar, Part.of(i), newValues[i]);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private int[] nextMatchValuesAfter(int[] values) {
        void var2_2;
        void var3_3;
        int newYear;
        int newMonth;
        int[] newValues = (int[])values.clone();
        int i = Part.YEAR.ordinal();
        boolean nextValue = false;
        while (i >= 0) {
            if (i == Part.DAY_OF_WEEK.ordinal()) {
                --i;
                continue;
            }
            if (i == Part.DAY_OF_MONTH.ordinal() && this.matchers[i] instanceof DayOfMonthMatcher && ((DayOfMonthMatcher)this.matchers[i]).isLast()) {
                newMonth = newValues[Part.MONTH.ordinal()];
                newYear = newValues[Part.YEAR.ordinal()];
                newMonth = PatternMatcher.getLastDay(newMonth, newYear);
            } else {
                newMonth = this.matchers[i].nextAfter(values[i]);
            }
            if (newMonth > values[i]) {
                newValues[i] = newMonth;
                --i;
                break;
            }
            if (newMonth < values[i]) {
                newValues[i] = newMonth;
                ++i;
                newMonth = -1;
                break;
            }
            --i;
        }
        if (-1 == newMonth) {
            while (i <= Part.YEAR.ordinal()) {
                int n;
                if (i == Part.DAY_OF_WEEK.ordinal()) {
                    ++i;
                    continue;
                }
                if (i == Part.DAY_OF_MONTH.ordinal() && this.matchers[i] instanceof DayOfMonthMatcher && ((DayOfMonthMatcher)this.matchers[i]).isLast()) {
                    newMonth = newValues[Part.MONTH.ordinal()];
                    newYear = newValues[Part.YEAR.ordinal()];
                    n = PatternMatcher.getLastDay(newMonth, newYear);
                } else {
                    n = this.matchers[i].nextAfter(values[i] + 1);
                }
                if (n > values[i]) {
                    newValues[i] = n;
                    --i;
                    break;
                }
                ++i;
            }
        }
        this.setToMin(newValues, (int)var3_3);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void setToMin(int[] values, int toPart) {
        for (int i = 0; i <= toPart; ++i) {
            void var3_4;
            Part part = Part.of(i);
            if (part == Part.DAY_OF_MONTH && this.get(part) instanceof DayOfMonthMatcher && ((DayOfMonthMatcher)this.get(part)).isLast()) {
                void var3_5;
                int newMonth = values[Part.MONTH.ordinal()];
                int newYear = values[Part.YEAR.ordinal()];
                values[i] = PatternMatcher.getLastDay((int)var3_5, newYear);
                continue;
            }
            values[i] = this.getMin((Part)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getMin(Part part) {
        void var1_2;
        int min;
        PartMatcher matcher = this.get(part);
        if (matcher instanceof AlwaysTrueMatcher) {
            min = part.getMin();
        } else if (matcher instanceof BoolArrayMatcher) {
            min = ((BoolArrayMatcher)matcher).getMinValue();
        } else {
            void var2_3;
            throw new IllegalArgumentException("Invalid matcher: " + var2_3.getClass().getName());
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private Calendar setValue(Calendar calendar, Part part, int value) {
        void var1_1;
        void var3_3;
        void var2_2;
        switch (part) {
            case MONTH: {
                --value;
                break;
            }
            case DAY_OF_WEEK: {
                ++value;
            }
        }
        calendar.set(var2_2.getCalendarField(), (int)var3_3);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int getLastDay(int monthBase1, int year) {
        void var1_1;
        return Objects.requireNonNull(Month.of(monthBase1 - 1)).getLastDay(DateUtil.isLeapYear((int)var1_1));
    }
}

