/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.listener;

import cn.hutool.cron.TaskExecutor;
import cn.hutool.cron.listener.TaskListener;
import cn.hutool.log.StaticLog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TaskListenerManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<TaskListener> listeners = new ArrayList<TaskListener>();

    /*
     * WARNING - void declaration
     */
    public TaskListenerManager addListener(TaskListener listener) {
        List<TaskListener> list = this.listeners;
        synchronized (list) {
            void var1_1;
            this.listeners.add((TaskListener)var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public TaskListenerManager removeListener(TaskListener listener) {
        List<TaskListener> list = this.listeners;
        synchronized (list) {
            void var1_1;
            this.listeners.remove(var1_1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void notifyTaskStart(TaskExecutor executor) {
        List<TaskListener> list = this.listeners;
        synchronized (list) {
            for (TaskListener listener : this.listeners) {
                void var3_5;
                if (listener == null) continue;
                var3_5.onStart(executor);
            }
            return;
        }
    }

    public void notifyTaskSucceeded(TaskExecutor executor) {
        List<TaskListener> list = this.listeners;
        synchronized (list) {
            for (TaskListener taskListener : this.listeners) {
                taskListener.onSucceeded(executor);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void notifyTaskFailed(TaskExecutor executor, Throwable exception) {
        List<TaskListener> list = this.listeners;
        synchronized (list) {
            int n = this.listeners.size();
            if (n > 0) {
                for (TaskListener taskListener : this.listeners) {
                    taskListener.onFailed(executor, exception);
                }
            } else {
                void var2_3;
                void v0 = var2_3;
                StaticLog.error((Throwable)v0, v0.getMessage(), new Object[0]);
            }
            return;
        }
    }
}

