/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron;

import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronException;
import cn.hutool.cron.Scheduler;
import cn.hutool.cron.pattern.CronPattern;
import cn.hutool.cron.task.CronTask;
import cn.hutool.cron.task.Task;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TaskTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_CAPACITY = 10;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final List<String> ids;
    private final List<CronPattern> patterns;
    private final List<Task> tasks;
    private int size;

    public TaskTable() {
        this(10);
    }

    /*
     * WARNING - void declaration
     */
    public TaskTable(int initialCapacity) {
        void var1_1;
        this.ids = new ArrayList<String>(initialCapacity);
        this.patterns = new ArrayList<CronPattern>(initialCapacity);
        this.tasks = new ArrayList<Task>((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public TaskTable add(String id, CronPattern pattern, Task task) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            if (this.ids.contains(id)) {
                throw new CronException("Id [{}] has been existed!", id);
            }
            this.ids.add((String)var1_1);
            this.patterns.add((CronPattern)var2_3);
            this.tasks.add((Task)var3_4);
            ++this.size;
        }
        finally {
            writeLock.unlock();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getIds() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List<String> list = Collections.unmodifiableList(this.ids);
            readLock.unlock();
            return list;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<CronPattern> getPatterns() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List<CronPattern> list = Collections.unmodifiableList(this.patterns);
            readLock.unlock();
            return list;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Task> getTasks() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List<Task> list = Collections.unmodifiableList(this.tasks);
            readLock.unlock();
            return list;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(String id) {
        void var1_2;
        int index;
        Lock writeLock;
        block3: {
            writeLock = this.lock.writeLock();
            writeLock.lock();
            try {
                index = this.ids.indexOf(id);
                if (index >= 0) break block3;
                writeLock.unlock();
                return false;
            }
            catch (Throwable throwable) {
                void var2_4;
                var2_4.unlock();
                throw throwable;
            }
        }
        this.tasks.remove(index);
        this.patterns.remove(index);
        this.ids.remove((int)var1_2);
        --this.size;
        writeLock.unlock();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean updatePattern(String id, CronPattern pattern) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            int index = this.ids.indexOf(id);
            if (index >= 0) {
                void var2_4;
                void var1_2;
                this.patterns.set((int)var1_2, (CronPattern)var2_4);
                writeLock.unlock();
                return true;
            }
            writeLock.unlock();
        }
        catch (Throwable throwable) {
            void var3_5;
            var3_5.unlock();
            throw throwable;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Task getTask(int index) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            void var1_1;
            Task task = this.tasks.get((int)var1_1);
            readLock.unlock();
            return task;
        }
        catch (Throwable throwable) {
            void var2_4;
            var2_4.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Task getTask(String id) {
        int index = this.ids.indexOf(id);
        if (index >= 0) {
            void var1_2;
            return this.getTask((int)var1_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public CronPattern getPattern(int index) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            void var1_1;
            CronPattern cronPattern = this.patterns.get((int)var1_1);
            readLock.unlock();
            return cronPattern;
        }
        catch (Throwable throwable) {
            void var2_4;
            var2_4.unlock();
            throw throwable;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    /*
     * WARNING - void declaration
     */
    public CronPattern getPattern(String id) {
        int index = this.ids.indexOf(id);
        if (index >= 0) {
            void var1_2;
            return this.getPattern((int)var1_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void executeTaskIfMatch(Scheduler scheduler, long millis) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            void var2_3;
            void var1_1;
            this.executeTaskIfMatchInternal((Scheduler)var1_1, (long)var2_3);
            return;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder builder = StrUtil.builder();
        for (int i = 0; i < this.size; ++i) {
            builder.append(StrUtil.format("[{}] [{}] [{}]\n", this.ids.get(i), this.patterns.get(i), this.tasks.get(i)));
        }
        return var1_1.toString();
    }

    protected void executeTaskIfMatchInternal(Scheduler scheduler, long millis) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.patterns.get(i).match(scheduler.config.timezone, millis, scheduler.config.matchSecond)) continue;
            scheduler.taskExecutorManager.spawnExecutor(new CronTask(this.ids.get(i), this.patterns.get(i), this.tasks.get(i)));
        }
    }
}

