/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.thread.ExecutorBuilder;
import cn.hutool.core.thread.ThreadFactoryBuilder;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronConfig;
import cn.hutool.cron.CronException;
import cn.hutool.cron.CronTimer;
import cn.hutool.cron.TaskExecutorManager;
import cn.hutool.cron.TaskLauncherManager;
import cn.hutool.cron.TaskTable;
import cn.hutool.cron.listener.TaskListener;
import cn.hutool.cron.listener.TaskListenerManager;
import cn.hutool.cron.pattern.CronPattern;
import cn.hutool.cron.task.InvokeTask;
import cn.hutool.cron.task.RunnableTask;
import cn.hutool.cron.task.Task;
import cn.hutool.log.StaticLog;
import cn.hutool.setting.Setting;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Scheduler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Lock lock = new ReentrantLock();
    protected CronConfig config = new CronConfig();
    private boolean started = false;
    protected boolean daemon;
    private CronTimer timer;
    protected TaskTable taskTable = new TaskTable();
    protected TaskLauncherManager taskLauncherManager;
    protected TaskExecutorManager taskExecutorManager;
    protected TaskListenerManager listenerManager = new TaskListenerManager();
    protected ExecutorService threadExecutor;

    /*
     * WARNING - void declaration
     */
    public Scheduler setTimeZone(TimeZone timeZone) {
        void var1_1;
        this.config.setTimeZone((TimeZone)var1_1);
        return this;
    }

    public TimeZone getTimeZone() {
        return this.config.getTimeZone();
    }

    /*
     * WARNING - void declaration
     */
    public Scheduler setDaemon(boolean on) throws CronException {
        this.lock.lock();
        try {
            void var1_1;
            this.checkStarted();
            this.daemon = var1_1;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Scheduler setThreadExecutor(ExecutorService threadExecutor) throws CronException {
        this.lock.lock();
        try {
            void var1_1;
            this.checkStarted();
            this.threadExecutor = var1_1;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public boolean isMatchSecond() {
        return this.config.isMatchSecond();
    }

    /*
     * WARNING - void declaration
     */
    public Scheduler setMatchSecond(boolean isMatchSecond) {
        void var1_1;
        this.config.setMatchSecond((boolean)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Scheduler addListener(TaskListener listener) {
        void var1_1;
        this.listenerManager.addListener((TaskListener)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Scheduler removeListener(TaskListener listener) {
        void var1_1;
        this.listenerManager.removeListener((TaskListener)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Scheduler schedule(Setting cronSetting) {
        if (MapUtil.isNotEmpty(cronSetting)) {
            for (Map.Entry<String, LinkedHashMap<String, String>> groupedEntry : cronSetting.getGroupedMap().entrySet()) {
                Iterator iterator;
                String group = groupedEntry.getKey();
                for (Map.Entry entry : ((LinkedHashMap)iterator.getValue()).entrySet()) {
                    String jobClass = (String)entry.getKey();
                    if (StrUtil.isNotBlank(group)) {
                        jobClass = group + '.' + jobClass;
                    }
                    String pattern = (String)entry.getValue();
                    StaticLog.debug("Load job: {} {}", pattern, jobClass);
                    try {
                        this.schedule("id_" + jobClass, pattern, (Task)new InvokeTask(jobClass));
                    }
                    catch (Exception e) {
                        void var1_2;
                        throw new CronException((Throwable)var1_2, "Schedule [{}] [{}] error!", pattern, jobClass);
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public String schedule(String pattern, Runnable task) {
        void var2_2;
        void var1_1;
        return this.schedule((String)var1_1, new RunnableTask((Runnable)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public String schedule(String pattern, Task task) {
        void var3_3;
        void var2_2;
        void var1_1;
        String id = IdUtil.fastUUID();
        this.schedule(id, (String)var1_1, (Task)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Scheduler schedule(String id, String pattern, Runnable task) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.schedule((String)var1_1, new CronPattern((String)var2_2), (Task)new RunnableTask((Runnable)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public Scheduler schedule(String id, String pattern, Task task) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.schedule((String)var1_1, new CronPattern((String)var2_2), (Task)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Scheduler schedule(String id, CronPattern pattern, Task task) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.taskTable.add((String)var1_1, (CronPattern)var2_2, (Task)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Scheduler deschedule(String id) {
        void var1_1;
        this.descheduleWithStatus((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public boolean descheduleWithStatus(String id) {
        void var1_1;
        return this.taskTable.remove((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Scheduler updatePattern(String id, CronPattern pattern) {
        void var2_2;
        void var1_1;
        this.taskTable.updatePattern((String)var1_1, (CronPattern)var2_2);
        return this;
    }

    public TaskTable getTaskTable() {
        return this.taskTable;
    }

    /*
     * WARNING - void declaration
     */
    public CronPattern getPattern(String id) {
        void var1_1;
        return this.taskTable.getPattern((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Task getTask(String id) {
        void var1_1;
        return this.taskTable.getTask((String)var1_1);
    }

    public boolean isEmpty() {
        return this.taskTable.isEmpty();
    }

    public int size() {
        return this.taskTable.size();
    }

    public Scheduler clear() {
        this.taskTable = new TaskTable();
        return this;
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - void declaration
     */
    public Scheduler start(boolean isDaemon) {
        void var1_1;
        this.daemon = var1_1;
        return this.start();
    }

    public Scheduler start() {
        this.lock.lock();
        try {
            this.checkStarted();
            if (this.threadExecutor == null) {
                this.threadExecutor = ExecutorBuilder.create().useSynchronousQueue().setThreadFactory(ThreadFactoryBuilder.create().setNamePrefix("hutool-cron-").setDaemon(this.daemon).build()).build();
            }
            this.taskLauncherManager = new TaskLauncherManager(this);
            this.taskExecutorManager = new TaskExecutorManager(this);
            this.timer = new CronTimer(this);
            this.timer.setDaemon(this.daemon);
            this.timer.start();
            this.started = true;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public Scheduler stop() {
        return this.stop(false);
    }

    /*
     * WARNING - void declaration
     */
    public Scheduler stop(boolean clearTasks) {
        this.lock.lock();
        try {
            void var1_1;
            if (!this.started) {
                throw new IllegalStateException("Scheduler not started !");
            }
            this.timer.stopTimer();
            this.timer = null;
            this.threadExecutor.shutdown();
            this.threadExecutor = null;
            if (var1_1 != false) {
                this.clear();
            }
            this.started = false;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    private void checkStarted() throws CronException {
        if (this.started) {
            throw new CronException("Scheduler already started!");
        }
    }
}

