/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.cron.Scheduler;
import cn.hutool.cron.pattern.CronPattern;
import cn.hutool.cron.task.Task;
import cn.hutool.setting.Setting;
import cn.hutool.setting.SettingRuntimeException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CronUtil {
    public static final String CRONTAB_CONFIG_PATH = "config/cron.setting";
    public static final String CRONTAB_CONFIG_PATH2 = "cron.setting";
    private static final Lock lock = new ReentrantLock();
    private static final Scheduler scheduler = new Scheduler();
    private static Setting crontabSetting;

    public static void setCronSetting(Setting cronSetting) {
        crontabSetting = cronSetting;
    }

    public static void setCronSetting(String cronSettingPath) {
        try {
            String string;
            crontabSetting = new Setting(string, Setting.DEFAULT_CHARSET, false);
            return;
        }
        catch (NoResourceException | SettingRuntimeException runtimeException) {
            return;
        }
    }

    public static void setMatchSecond(boolean isMatchSecond) {
        boolean bl;
        scheduler.setMatchSecond(bl);
    }

    /*
     * WARNING - void declaration
     */
    public static String schedule(String schedulingPattern, Task task) {
        void var1_1;
        String string;
        return scheduler.schedule(string, (Task)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String schedule(String id, String schedulingPattern, Task task) {
        String string;
        void var2_2;
        void var1_1;
        scheduler.schedule(id, (String)var1_1, (Task)var2_2);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String schedule(String schedulingPattern, Runnable task) {
        void var1_1;
        String string;
        return scheduler.schedule(string, (Runnable)var1_1);
    }

    public static void schedule(Setting cronSetting) {
        Setting setting;
        scheduler.schedule(setting);
    }

    public static boolean remove(String schedulerId) {
        String string;
        return scheduler.descheduleWithStatus(string);
    }

    /*
     * WARNING - void declaration
     */
    public static void updatePattern(String id, CronPattern pattern) {
        void var1_1;
        String string;
        scheduler.updatePattern(string, (CronPattern)var1_1);
    }

    public static Scheduler getScheduler() {
        return scheduler;
    }

    public static void start() {
        CronUtil.start(false);
    }

    public static synchronized void start(boolean isDaemon) {
        boolean bl;
        if (scheduler.isStarted()) {
            throw new UtilException("Scheduler has been started, please stop it first!");
        }
        lock.lock();
        try {
            if (crontabSetting == null) {
                CronUtil.setCronSetting(CRONTAB_CONFIG_PATH);
            }
            if (crontabSetting == null) {
                CronUtil.setCronSetting(CRONTAB_CONFIG_PATH2);
            }
        }
        finally {
            lock.unlock();
        }
        CronUtil.schedule(crontabSetting);
        scheduler.start(bl);
    }

    public static void restart() {
        lock.lock();
        try {
            if (crontabSetting != null) {
                crontabSetting.load();
            }
            if (scheduler.isStarted()) {
                CronUtil.stop();
            }
        }
        finally {
            lock.unlock();
        }
        CronUtil.schedule(crontabSetting);
        scheduler.start();
    }

    public static void stop() {
        scheduler.stop(true);
    }
}

