/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.collection.EnumerationIter;
import cn.hutool.core.compress.Deflate;
import cn.hutool.core.compress.Gzip;
import cn.hutool.core.compress.ZipCopyVisitor;
import cn.hutool.core.compress.ZipReader;
import cn.hutool.core.compress.ZipWriter;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.LimitedInputStream;
import cn.hutool.core.io.file.FileSystemUtil;
import cn.hutool.core.io.file.PathUtil;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final int DEFAULT_BYTE_ARRAY_LENGTH = 32;
    private static final Charset DEFAULT_CHARSET = CharsetUtil.defaultCharset();

    /*
     * WARNING - void declaration
     */
    public static ZipFile toZipFile(File file, Charset charset) {
        try {
            void var1_2;
            return new ZipFile(file, ObjectUtil.defaultIfNull(var1_2, CharsetUtil.CHARSET_UTF_8));
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream getStream(ZipFile zipFile, ZipEntry zipEntry) {
        try {
            void var1_2;
            return new LimitedInputStream(zipFile.getInputStream(zipEntry), var1_2.getSize());
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ZipOutputStream getZipOutputStream(OutputStream out, Charset charset) {
        void var1_1;
        OutputStream outputStream;
        if (out instanceof ZipOutputStream) {
            return (ZipOutputStream)out;
        }
        return new ZipOutputStream(outputStream, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void append(Path zipPath, Path appendFilePath, CopyOption ... options) throws IORuntimeException {
        try {
            FileSystem zipFileSystem2;
            block16: {
                block15: {
                    zipFileSystem2 = FileSystemUtil.createZip(zipPath.toString());
                    Throwable throwable = null;
                    try {
                        if (Files.isDirectory(appendFilePath, new LinkOption[0])) {
                            Path source = appendFilePath.getParent();
                            if (source == null) {
                                source = appendFilePath;
                            }
                            Files.walkFileTree(appendFilePath, new ZipCopyVisitor(source, zipFileSystem2, options));
                        } else {
                            void var2_5;
                            void var1_3;
                            Files.copy(appendFilePath, zipFileSystem2.getPath(PathUtil.getName((Path)var1_3), new String[0]), (CopyOption[])var2_5);
                        }
                        if (zipFileSystem2 == null) break block15;
                    }
                    catch (Throwable throwable2) {
                        try {
                            Throwable throwable3 = throwable2;
                            throwable = throwable2;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (zipFileSystem2 != null) {
                                if (throwable != null) {
                                    try {
                                        zipFileSystem2.close();
                                    }
                                    catch (Throwable zipFileSystem2) {
                                        throwable.addSuppressed(zipFileSystem2);
                                    }
                                } else {
                                    zipFileSystem2.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    break block16;
                }
                return;
            }
            zipFileSystem2.close();
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            return;
        }
        catch (IOException e) {
            void var0_2;
            throw new IORuntimeException((Throwable)var0_2);
        }
    }

    public static File zip(String srcPath) throws UtilException {
        return ZipUtil.zip(srcPath, DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    public static File zip(String srcPath, Charset charset) throws UtilException {
        void var1_1;
        return ZipUtil.zip(FileUtil.file(srcPath), (Charset)var1_1);
    }

    public static File zip(File srcFile) throws UtilException {
        return ZipUtil.zip(srcFile, DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    public static File zip(File srcFile, Charset charset) throws UtilException {
        void var2_2;
        File file;
        void var1_1;
        File zipFile = FileUtil.file(srcFile.getParentFile(), FileUtil.mainName(srcFile) + ".zip");
        ZipUtil.zip(zipFile, (Charset)var1_1, false, file);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static File zip(String srcPath, String zipPath) throws UtilException {
        void var1_1;
        return ZipUtil.zip(srcPath, (String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static File zip(String srcPath, String zipPath, boolean withSrcDir) throws UtilException {
        void var2_2;
        void var1_1;
        return ZipUtil.zip(srcPath, (String)var1_1, DEFAULT_CHARSET, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static File zip(String srcPath, String zipPath, Charset charset, boolean withSrcDir) throws UtilException {
        void var1_1;
        File file;
        void var3_3;
        void var2_2;
        File srcFile = FileUtil.file(srcPath);
        File zipFile = FileUtil.file(zipPath);
        ZipUtil.zip(zipFile, (Charset)var2_2, (boolean)var3_3, file);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static File zip(File zipFile, boolean withSrcDir, File ... srcFiles) throws UtilException {
        void var2_2;
        void var1_1;
        return ZipUtil.zip(zipFile, DEFAULT_CHARSET, (boolean)var1_1, (File[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static File zip(File zipFile, Charset charset, boolean withSrcDir, File ... srcFiles) throws UtilException {
        void var3_3;
        void var2_2;
        void var1_1;
        return ZipUtil.zip(zipFile, (Charset)var1_1, (boolean)var2_2, null, (File[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static File zip(File zipFile, Charset charset, boolean withSrcDir, FileFilter filter, File ... srcFiles) throws IORuntimeException {
        File file;
        void var3_3;
        void var2_2;
        void var1_1;
        ZipUtil.validateFiles(zipFile, srcFiles);
        ZipWriter.of(zipFile, (Charset)var1_1).add((boolean)var2_2, (FileFilter)var3_3, srcFiles).close();
        return file;
    }

    /*
     * WARNING - void declaration
     */
    public static void zip(OutputStream out, Charset charset, boolean withSrcDir, FileFilter filter, File ... srcFiles) throws IORuntimeException {
        void var3_3;
        void var2_2;
        void var1_1;
        ZipWriter.of(out, (Charset)var1_1).add((boolean)var2_2, (FileFilter)var3_3, srcFiles).close();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static void zip(ZipOutputStream zipOutputStream, boolean withSrcDir, FileFilter filter, File ... srcFiles) throws IORuntimeException {
        Closeable zipWriter2 = new ZipWriter(zipOutputStream);
        Throwable throwable = null;
        try {
            void var3_6;
            void var2_5;
            void var1_2;
            ((ZipWriter)zipWriter2).add((boolean)var1_2, (FileFilter)var2_5, (File[])var3_6);
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (throwable != null) {
                    try {
                        ((ZipWriter)zipWriter2).close();
                    }
                    catch (Throwable zipWriter2) {
                        throwable.addSuppressed(zipWriter2);
                    }
                } else {
                    Closeable closeable;
                    ((ZipWriter)closeable).close();
                }
                throw throwable4;
            }
        }
        ((ZipWriter)zipWriter2).close();
        return;
    }

    /*
     * WARNING - void declaration
     */
    public static File zip(File zipFile, String path, String data) throws UtilException {
        void var2_2;
        void var1_1;
        return ZipUtil.zip(zipFile, (String)var1_1, (String)var2_2, DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    public static File zip(File zipFile, String path, String data, Charset charset) throws UtilException {
        void var3_3;
        void var2_2;
        void var1_1;
        return ZipUtil.zip(zipFile, (String)var1_1, IoUtil.toStream((String)var2_2, charset), (Charset)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static File zip(File zipFile, String path, InputStream in) throws UtilException {
        void var2_2;
        void var1_1;
        return ZipUtil.zip(zipFile, (String)var1_1, (InputStream)var2_2, DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    public static File zip(File zipFile, String path, InputStream in, Charset charset) throws UtilException {
        void var3_3;
        void var2_2;
        void var1_1;
        return ZipUtil.zip(zipFile, new String[]{var1_1}, new InputStream[]{var2_2}, (Charset)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static File zip(File zipFile, String[] paths, InputStream[] ins) throws UtilException {
        void var2_2;
        void var1_1;
        return ZipUtil.zip(zipFile, (String[])var1_1, (InputStream[])var2_2, DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File zip(File zipFile2, String[] paths, InputStream[] ins, Charset charset) throws UtilException {
        File file;
        ZipWriter zipWriter = ZipWriter.of(zipFile2, (Charset)charset);
        Throwable throwable = null;
        try {
            void var2_5;
            void var1_3;
            zipWriter.add((String[])var1_3, (InputStream[])var2_5);
            if (zipWriter == null) return file;
        }
        catch (Throwable throwable2) {
            try {
                Throwable zipFile2 = throwable2;
                throwable = throwable2;
                throw zipFile2;
            }
            catch (Throwable zipFile2) {
                if (zipWriter == null) throw zipFile2;
                if (throwable != null) {
                    try {
                        zipWriter.close();
                        throw zipFile2;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw zipFile2;
                } else {
                    void var3_6;
                    var3_6.close();
                }
                throw zipFile2;
            }
        }
        zipWriter.close();
        return file;
    }

    /*
     * WARNING - void declaration
     */
    public static void zip(OutputStream out, String[] paths, InputStream[] ins) {
        void var2_2;
        void var1_1;
        ZipUtil.zip(ZipUtil.getZipOutputStream(out, DEFAULT_CHARSET), (String[])var1_1, (InputStream[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void zip(ZipOutputStream zipOutputStream, String[] paths, InputStream[] ins) throws IORuntimeException {
        Throwable throwable;
        Closeable zipWriter2 = new ZipWriter(zipOutputStream);
        Throwable throwable2 = null;
        try {
            void var2_4;
            ((ZipWriter)zipWriter2).add((String[])throwable, (InputStream[])var2_4);
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throwable2 = throwable3;
                throw throwable;
            }
            catch (Throwable throwable4) {
                if (throwable2 != null) {
                    try {
                        ((ZipWriter)zipWriter2).close();
                    }
                    catch (Throwable zipWriter2) {
                        throwable2.addSuppressed(zipWriter2);
                    }
                } else {
                    Closeable closeable;
                    ((ZipWriter)closeable).close();
                }
                throw throwable4;
            }
        }
        ((ZipWriter)zipWriter2).close();
        return;
    }

    /*
     * WARNING - void declaration
     */
    public static File zip(File zipFile, Charset charset, Resource ... resources) throws UtilException {
        File file;
        void var2_2;
        void var1_1;
        ZipWriter.of(zipFile, (Charset)var1_1).add((Resource[])var2_2).close();
        return file;
    }

    public static File unzip(String zipFilePath) throws UtilException {
        return ZipUtil.unzip(zipFilePath, DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    public static File unzip(String zipFilePath, Charset charset) throws UtilException {
        void var1_1;
        return ZipUtil.unzip(FileUtil.file(zipFilePath), (Charset)var1_1);
    }

    public static File unzip(File zipFile) throws UtilException {
        return ZipUtil.unzip(zipFile, DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    public static File unzip(File zipFile, Charset charset) throws UtilException {
        void var1_1;
        void var2_2;
        File file;
        File destDir = FileUtil.file(zipFile.getParentFile(), FileUtil.mainName(zipFile));
        return ZipUtil.unzip(file, (File)var2_2, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static File unzip(String zipFilePath, String outFileDir) throws UtilException {
        void var1_1;
        return ZipUtil.unzip(zipFilePath, (String)var1_1, DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    public static File unzip(String zipFilePath, String outFileDir, Charset charset) throws UtilException {
        void var2_2;
        void var1_1;
        return ZipUtil.unzip(FileUtil.file(zipFilePath), FileUtil.mkdir((String)var1_1), (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static File unzip(File zipFile, File outFile) throws UtilException {
        void var1_1;
        return ZipUtil.unzip(zipFile, (File)var1_1, DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    public static File unzip(File zipFile, File outFile, Charset charset) {
        void var1_1;
        void var2_2;
        return ZipUtil.unzip(ZipUtil.toZipFile(zipFile, (Charset)var2_2), (File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static File unzip(ZipFile zipFile, File outFile) throws IORuntimeException {
        void var1_1;
        return ZipUtil.unzip(zipFile, (File)var1_1, -1L);
    }

    /*
     * WARNING - void declaration
     */
    public static File unzip(ZipFile zipFile, File outFile2, long limit) throws IORuntimeException {
        void var1_2;
        ZipFile zipFile2;
        if (outFile2.exists() && outFile2.isFile()) {
            throw new IllegalArgumentException(StrUtil.format("Target path [{}] exist!", outFile2.getAbsolutePath()));
        }
        if (limit > 0L) {
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            long zipFileSize = 0L;
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                if ((zipFileSize += zipEntry.getSize()) <= limit) continue;
                throw new IllegalArgumentException("The file size exceeds the limit");
            }
        }
        ZipReader reader = new ZipReader(zipFile2);
        Throwable throwable = null;
        try {
            reader.readTo(outFile2);
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable outFile2) {
                        throwable.addSuppressed(outFile2);
                    }
                } else {
                    reader.close();
                }
                throw throwable4;
            }
        }
        reader.close();
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream get(File zipFile, Charset charset, String path) {
        void var2_2;
        void var1_1;
        return ZipUtil.get(ZipUtil.toZipFile(zipFile, (Charset)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream get(ZipFile zipFile, String path) {
        ZipEntry entry = zipFile.getEntry(path);
        if (entry != null) {
            void var1_1;
            ZipFile zipFile2;
            return ZipUtil.getStream(zipFile2, (ZipEntry)var1_1);
        }
        return null;
    }

    public static void read(ZipFile zipFile, Consumer<ZipEntry> consumer) {
        Throwable throwable;
        Closeable reader2 = new ZipReader(zipFile);
        Throwable throwable2 = null;
        try {
            ((ZipReader)reader2).read((Consumer<ZipEntry>)((Object)throwable));
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throwable2 = throwable3;
                throw throwable;
            }
            catch (Throwable throwable4) {
                if (throwable2 != null) {
                    try {
                        ((ZipReader)reader2).close();
                    }
                    catch (Throwable reader2) {
                        throwable2.addSuppressed(reader2);
                    }
                } else {
                    Closeable closeable;
                    ((ZipReader)closeable).close();
                }
                throw throwable4;
            }
        }
        ((ZipReader)reader2).close();
        return;
    }

    /*
     * WARNING - void declaration
     */
    public static File unzip(InputStream in, File outFile, Charset charset) throws UtilException {
        void var1_1;
        void var2_2;
        InputStream inputStream;
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        return ZipUtil.unzip(new ZipInputStream(inputStream, (Charset)var2_2), (File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static File unzip(ZipInputStream zipStream, File outFile2) throws UtilException {
        void var1_2;
        Closeable reader2 = new ZipReader(zipStream);
        Throwable throwable = null;
        try {
            ((ZipReader)reader2).readTo((File)outFile2);
        }
        catch (Throwable throwable2) {
            try {
                outFile2 = throwable2;
                throwable = throwable2;
                throw outFile2;
            }
            catch (Throwable outFile2) {
                if (throwable != null) {
                    try {
                        ((ZipReader)reader2).close();
                    }
                    catch (Throwable reader2) {
                        throwable.addSuppressed(reader2);
                    }
                } else {
                    Closeable closeable;
                    ((ZipReader)closeable).close();
                }
                throw outFile2;
            }
        }
        ((ZipReader)reader2).close();
        return var1_2;
    }

    public static void read(ZipInputStream zipStream, Consumer<ZipEntry> consumer) {
        Throwable throwable;
        Closeable reader2 = new ZipReader(zipStream);
        Throwable throwable2 = null;
        try {
            ((ZipReader)reader2).read((Consumer<ZipEntry>)((Object)throwable));
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throwable2 = throwable3;
                throw throwable;
            }
            catch (Throwable throwable4) {
                if (throwable2 != null) {
                    try {
                        ((ZipReader)reader2).close();
                    }
                    catch (Throwable reader2) {
                        throwable2.addSuppressed(reader2);
                    }
                } else {
                    Closeable closeable;
                    ((ZipReader)closeable).close();
                }
                throw throwable4;
            }
        }
        ((ZipReader)reader2).close();
        return;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] unzipFileBytes(String zipFilePath, String name) {
        void var1_1;
        return ZipUtil.unzipFileBytes(zipFilePath, DEFAULT_CHARSET, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] unzipFileBytes(String zipFilePath, Charset charset, String name) {
        void var2_2;
        void var1_1;
        return ZipUtil.unzipFileBytes(FileUtil.file(zipFilePath), (Charset)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] unzipFileBytes(File zipFile, String name) {
        void var1_1;
        return ZipUtil.unzipFileBytes(zipFile, DEFAULT_CHARSET, (String)var1_1);
    }

    public static byte[] unzipFileBytes(File zipFile, Charset charset, String name) {
        Object object;
        block9: {
            Throwable throwable;
            ZipReader reader2 = ZipReader.of(zipFile, (Charset)((Object)throwable));
            throwable = null;
            try {
                object = IoUtil.readBytes(reader2.get((String)object));
                if (reader2 == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (reader2 != null) {
                        if (throwable != null) {
                            try {
                                reader2.close();
                            }
                            catch (Throwable reader2) {
                                throwable.addSuppressed(reader2);
                            }
                        } else {
                            ZipReader zipReader;
                            zipReader.close();
                        }
                    }
                    throw throwable3;
                }
            }
            reader2.close();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] gzip(String content, String charset) throws UtilException {
        void var1_1;
        return ZipUtil.gzip(StrUtil.bytes((CharSequence)content, (String)var1_1));
    }

    public static byte[] gzip(byte[] buf) throws UtilException {
        byte[] byArray;
        return ZipUtil.gzip(new ByteArrayInputStream(buf), byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] gzip(File file) throws UtilException {
        Object object;
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file);
            object = ZipUtil.gzip(in, (int)((File)object).length());
        }
        catch (Throwable throwable) {
            void var1_2;
            IoUtil.close((Closeable)var1_2);
            throw throwable;
        }
        IoUtil.close(in);
        return object;
    }

    public static byte[] gzip(InputStream in) throws UtilException {
        return ZipUtil.gzip(in, 32);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] gzip(InputStream in, int length) throws UtilException {
        void var1_2;
        InputStream inputStream;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        Gzip.of(inputStream, bos).gzip().close();
        return var1_2.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static String unGzip(byte[] buf, String charset) throws UtilException {
        void var1_1;
        return StrUtil.str(ZipUtil.unGzip(buf), (String)var1_1);
    }

    public static byte[] unGzip(byte[] buf) throws UtilException {
        byte[] byArray;
        return ZipUtil.unGzip(new ByteArrayInputStream(buf), byArray.length);
    }

    public static byte[] unGzip(InputStream in) throws UtilException {
        return ZipUtil.unGzip(in, 32);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] unGzip(InputStream in, int length) throws UtilException {
        void var1_2;
        InputStream inputStream;
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(length);
        Gzip.of(inputStream, bos).unGzip().close();
        return var1_2.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] zlib(String content, String charset, int level) {
        void var2_2;
        void var1_1;
        return ZipUtil.zlib(StrUtil.bytes((CharSequence)content, (String)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] zlib(File file, int level) {
        Object object;
        BufferedInputStream in = null;
        try {
            void var1_2;
            in = FileUtil.getInputStream(file);
            object = ZipUtil.zlib(in, (int)var1_2, (int)((File)object).length());
        }
        catch (Throwable throwable) {
            void var2_3;
            IoUtil.close((Closeable)var2_3);
            throw throwable;
        }
        IoUtil.close(in);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] zlib(byte[] buf, int level) {
        byte[] byArray;
        void var1_1;
        return ZipUtil.zlib(new ByteArrayInputStream(buf), (int)var1_1, byArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] zlib(InputStream in, int level) {
        void var1_1;
        return ZipUtil.zlib(in, (int)var1_1, 32);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] zlib(InputStream in, int level, int length) {
        void var2_3;
        void var1_1;
        InputStream inputStream;
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        Deflate.of(inputStream, out, false).deflater((int)var1_1);
        return var2_3.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static String unZlib(byte[] buf, String charset) {
        void var1_1;
        return StrUtil.str(ZipUtil.unZlib(buf), (String)var1_1);
    }

    public static byte[] unZlib(byte[] buf) {
        byte[] byArray;
        return ZipUtil.unZlib(new ByteArrayInputStream(buf), byArray.length);
    }

    public static byte[] unZlib(InputStream in) {
        return ZipUtil.unZlib(in, 32);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] unZlib(InputStream in, int length) {
        void var1_2;
        InputStream inputStream;
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        Deflate.of(inputStream, out, false).inflater();
        return var1_2.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> listFileNames(ZipFile zipFile22, String dir) {
        void var2_7;
        if (StrUtil.isNotBlank(dir)) {
            dir = StrUtil.addSuffixIfNot(dir, "/");
        }
        ArrayList<void> fileNames = new ArrayList<void>();
        for (ZipEntry zipFile22 : new EnumerationIter<ZipEntry>(((ZipFile)zipFile22).entries())) {
            void var0_4;
            String nameSuffix;
            String name = zipFile22.getName();
            if (!StrUtil.isEmpty(dir) && !name.startsWith(dir) || !StrUtil.isNotEmpty(nameSuffix = StrUtil.removePrefix(name, dir)) || StrUtil.contains((CharSequence)nameSuffix, '/')) continue;
            fileNames.add(var0_4);
        }
        return var2_7;
    }

    /*
     * WARNING - void declaration
     */
    private static void validateFiles(File zipFile, File ... srcFiles) throws UtilException {
        void var1_1;
        if (zipFile.isDirectory()) {
            throw new UtilException("Zip file [{}] must not be a directory !", zipFile.getAbsoluteFile());
        }
        for (void srcFile : var1_1) {
            File parentFile;
            if (srcFile == null) continue;
            if (!srcFile.exists()) {
                throw new UtilException(StrUtil.format("File [{}] not exist!", srcFile.getAbsolutePath()));
            }
            try {
                parentFile = zipFile.getCanonicalFile().getParentFile();
            }
            catch (IOException iOException) {
                parentFile = zipFile.getParentFile();
            }
            if (!srcFile.isDirectory() || !FileUtil.isSub((File)srcFile, parentFile)) continue;
            throw new UtilException("Zip file path [{}] must not be the child directory of [{}] !", zipFile.getPath(), srcFile.getPath());
        }
    }
}

