/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.BiMap;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.map.MapWrapper;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.EscapeUtil;
import cn.hutool.core.util.StrUtil;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlUtil {
    public static final String NBSP = "&nbsp;";
    public static final String AMP = "&amp;";
    public static final String QUOTE = "&quot;";
    public static final String APOS = "&apos;";
    public static final String LT = "&lt;";
    public static final String GT = "&gt;";
    public static final String INVALID_REGEX = "[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]";
    public static final String COMMENT_REGEX = "(?s)<!--.+?-->";
    public static final int INDENT_DEFAULT = 2;
    private static String defaultDocumentBuilderFactory = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";
    private static boolean namespaceAware = true;
    private static SAXParserFactory factory;

    public static synchronized void disableDefaultDocumentBuilderFactory() {
        defaultDocumentBuilderFactory = null;
    }

    public static synchronized void setNamespaceAware(boolean isNamespaceAware) {
        namespaceAware = isNamespaceAware;
    }

    /*
     * WARNING - void declaration
     */
    public static Document readXML(File file) {
        Document document;
        Assert.notNull(file, "Xml file is null !", new Object[0]);
        if (!file.exists()) {
            throw new UtilException("File [{}] not a exist!", file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new UtilException("[{}] not a file!", file.getAbsolutePath());
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {}
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream((File)((Object)document));
            document = XmlUtil.readXML(in);
        }
        catch (Throwable throwable) {
            void var1_2;
            IoUtil.close((Closeable)var1_2);
            throw throwable;
        }
        IoUtil.close(in);
        return document;
    }

    public static Document readXML(String pathOrContent) {
        String string;
        if (StrUtil.startWith((CharSequence)pathOrContent, '<')) {
            return XmlUtil.parseXml(pathOrContent);
        }
        return XmlUtil.readXML(FileUtil.file(string));
    }

    public static Document readXML(InputStream inputStream) throws UtilException {
        InputStream inputStream2;
        return XmlUtil.readXML(new InputSource(inputStream2));
    }

    public static Document readXML(Reader reader) throws UtilException {
        Reader reader2;
        return XmlUtil.readXML(new InputSource(reader2));
    }

    /*
     * WARNING - void declaration
     */
    public static Document readXML(InputSource source) {
        DocumentBuilder builder = XmlUtil.createDocumentBuilder();
        try {
            void var1_2;
            return var1_2.parse(source);
        }
        catch (Exception e) {
            void var0_1;
            throw new UtilException((Throwable)var0_1, "Parse XML from stream error!", new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void readBySax(File file, ContentHandler contentHandler) {
        BufferedInputStream in = null;
        try {
            void var1_2;
            File file2;
            in = FileUtil.getInputStream(file2);
            XmlUtil.readBySax(new InputSource(in), (ContentHandler)var1_2);
        }
        catch (Throwable throwable) {
            void var2_3;
            IoUtil.close((Closeable)var2_3);
            throw throwable;
        }
        IoUtil.close(in);
    }

    /*
     * WARNING - void declaration
     */
    public static void readBySax(Reader reader, ContentHandler contentHandler) {
        try {
            void var1_1;
            XmlUtil.readBySax(new InputSource(reader), (ContentHandler)var1_1);
        }
        catch (Throwable throwable) {
            Reader reader2;
            IoUtil.close(reader2);
            throw throwable;
        }
        IoUtil.close(reader);
    }

    /*
     * WARNING - void declaration
     */
    public static void readBySax(InputStream source, ContentHandler contentHandler) {
        try {
            void var1_1;
            XmlUtil.readBySax(new InputSource(source), (ContentHandler)var1_1);
        }
        catch (Throwable throwable) {
            InputStream inputStream;
            IoUtil.close(inputStream);
            throw throwable;
        }
        IoUtil.close(source);
    }

    /*
     * WARNING - void declaration
     */
    public static void readBySax(InputSource source, ContentHandler contentHandler) {
        if (factory == null) {
            factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(namespaceAware);
            try {
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (Exception exception) {}
        }
        try {
            void var2_4;
            void var1_3;
            SAXParser parse = factory.newSAXParser();
            if (contentHandler instanceof DefaultHandler) {
                parse.parse(source, (DefaultHandler)contentHandler);
                return;
            }
            XMLReader reader = parse.getXMLReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            reader.setContentHandler((ContentHandler)var1_3);
            var2_4.parse(source);
            return;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new UtilException(e);
        }
        catch (IOException e) {
            void var0_2;
            throw new IORuntimeException((Throwable)var0_2);
        }
    }

    public static Document parseXml(String xmlStr) {
        String string;
        if (StrUtil.isBlank(xmlStr)) {
            throw new IllegalArgumentException("XML content string is empty !");
        }
        string = XmlUtil.cleanInvalid(string);
        return XmlUtil.readXML(StrUtil.getReader(string));
    }

    public static String toStr(Node doc) {
        return XmlUtil.toStr(doc, false);
    }

    public static String toStr(Document doc) {
        return XmlUtil.toStr((Node)doc);
    }

    /*
     * WARNING - void declaration
     */
    public static String toStr(Node doc, boolean isPretty) {
        void var1_1;
        return XmlUtil.toStr(doc, "UTF-8", (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String toStr(Document doc, boolean isPretty) {
        void var1_1;
        return XmlUtil.toStr((Node)doc, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String toStr(Node doc, String charset, boolean isPretty) {
        void var2_2;
        void var1_1;
        return XmlUtil.toStr(doc, (String)var1_1, (boolean)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String toStr(Document doc, String charset, boolean isPretty) {
        void var2_2;
        void var1_1;
        return XmlUtil.toStr((Node)doc, (String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String toStr(Node doc, String charset, boolean isPretty, boolean omitXmlDeclaration) {
        StringWriter writer = StrUtil.getWriter();
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            XmlUtil.write(doc, writer, (String)var1_2, var2_3 != false ? 2 : 0, (boolean)var3_4);
        }
        catch (Exception e) {
            void var0_1;
            throw new UtilException((Throwable)var0_1, "Trans xml document to string error!", new Object[0]);
        }
        return writer.toString();
    }

    public static String format(Document doc) {
        return XmlUtil.toStr(doc, true);
    }

    public static String format(String xmlStr) {
        return XmlUtil.format(XmlUtil.parseXml(xmlStr));
    }

    /*
     * WARNING - void declaration
     */
    public static void toFile(Document doc, String absolutePath) {
        void var1_1;
        XmlUtil.toFile(doc, (String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void toFile(Document doc, String path, String charsetName) {
        if (StrUtil.isBlank(charsetName)) {
            charsetName = doc.getXmlEncoding();
        }
        if (StrUtil.isBlank(charsetName)) {
            charsetName = "UTF-8";
        }
        BufferedWriter writer = null;
        try {
            void var2_3;
            Document document;
            void var1_2;
            writer = FileUtil.getWriter((String)var1_2, CharsetUtil.charset(charsetName), false);
            XmlUtil.write((Node)document, writer, (String)var2_3, 2);
        }
        catch (Throwable throwable) {
            void var3_4;
            IoUtil.close((Closeable)var3_4);
            throw throwable;
        }
        IoUtil.close(writer);
    }

    /*
     * WARNING - void declaration
     */
    public static void write(Node node, Writer writer, String charset, int indent) {
        void var3_3;
        void var2_2;
        void var1_1;
        Node node2;
        XmlUtil.transform(new DOMSource(node2), new StreamResult((Writer)var1_1), (String)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void write(Node node, Writer writer, String charset, int indent, boolean omitXmlDeclaration) {
        void var3_3;
        void var2_2;
        void var1_1;
        Node node2;
        XmlUtil.transform(new DOMSource(node2), new StreamResult((Writer)var1_1), (String)var2_2, (int)var3_3, omitXmlDeclaration);
    }

    /*
     * WARNING - void declaration
     */
    public static void write(Node node, OutputStream out, String charset, int indent) {
        void var3_3;
        void var2_2;
        void var1_1;
        Node node2;
        XmlUtil.transform(new DOMSource(node2), new StreamResult((OutputStream)var1_1), (String)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void write(Node node, OutputStream out, String charset, int indent, boolean omitXmlDeclaration) {
        void var3_3;
        void var2_2;
        void var1_1;
        Node node2;
        XmlUtil.transform(new DOMSource(node2), new StreamResult((OutputStream)var1_1), (String)var2_2, (int)var3_3, omitXmlDeclaration);
    }

    /*
     * WARNING - void declaration
     */
    public static void transform(Source source, Result result, String charset, int indent) {
        void var3_3;
        void var2_2;
        void var1_1;
        XmlUtil.transform(source, (Result)var1_1, (String)var2_2, (int)var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void transform(Source source, Result result, String charset, int indent, boolean omitXmlDeclaration) {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            void var1_1;
            Source source2;
            Transformer xformer = factory.newTransformer();
            if (indent > 0) {
                void var3_3;
                xformer.setOutputProperty("indent", "yes");
                xformer.setOutputProperty("doctype-public", "yes");
                xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf((int)var3_3));
            }
            if (StrUtil.isNotBlank(charset)) {
                void var2_2;
                xformer.setOutputProperty("encoding", (String)var2_2);
            }
            if (omitXmlDeclaration) {
                xformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            xformer.transform(source2, (Result)var1_1);
            return;
        }
        catch (Exception e) {
            throw new UtilException(e, "Trans xml document to string error!", new Object[0]);
        }
    }

    public static Document createXml() {
        return XmlUtil.createDocumentBuilder().newDocument();
    }

    /*
     * WARNING - void declaration
     */
    public static DocumentBuilder createDocumentBuilder() {
        void var0;
        try {
            DocumentBuilder builder = XmlUtil.createDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (Exception e) {
            throw new UtilException(e, "Create xml document error!", new Object[0]);
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        void var0;
        DocumentBuilderFactory factory = StrUtil.isNotEmpty(defaultDocumentBuilderFactory) ? DocumentBuilderFactory.newInstance(defaultDocumentBuilderFactory, null) : DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(namespaceAware);
        return XmlUtil.disableXXE((DocumentBuilderFactory)var0);
    }

    public static Document createXml(String rootElementName) {
        return XmlUtil.createXml(rootElementName, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Document createXml(String rootElementName, String namespace) {
        void var2_2;
        String string;
        void var1_1;
        Document doc = XmlUtil.createXml();
        doc.appendChild(namespace == null ? doc.createElement(rootElementName) : doc.createElementNS((String)var1_1, string));
        return var2_2;
    }

    public static Element getRootElement(Document doc) {
        Document document;
        if (doc == null) {
            return null;
        }
        return document.getDocumentElement();
    }

    public static Document getOwnerDocument(Node node) {
        Node node2;
        if (node instanceof Document) {
            return (Document)node;
        }
        return node2.getOwnerDocument();
    }

    public static String cleanInvalid(String xmlContent) {
        String string;
        if (xmlContent == null) {
            return null;
        }
        return string.replaceAll(INVALID_REGEX, "");
    }

    public static String cleanComment(String xmlContent) {
        String string;
        if (xmlContent == null) {
            return null;
        }
        return string.replaceAll(COMMENT_REGEX, "");
    }

    /*
     * WARNING - void declaration
     */
    public static List<Element> getElements(Element element, String tagName) {
        void var1_1;
        Element element2;
        NodeList nodeList = StrUtil.isBlank(tagName) ? element.getChildNodes() : element.getElementsByTagName(tagName);
        return XmlUtil.transElements(element2, (NodeList)var1_1);
    }

    public static Element getElement(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        int length = nodeList.getLength();
        if (length <= 0) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            Element childEle = (Element)nodeList.item(i);
            if (childEle != null && childEle.getParentNode() != element) continue;
            return childEle;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String elementText(Element element, String tagName) {
        Element element2;
        void var1_1;
        Element child = XmlUtil.getElement(element, (String)var1_1);
        if (child == null) {
            return null;
        }
        return element2.getTextContent();
    }

    /*
     * WARNING - void declaration
     */
    public static String elementText(Element element, String tagName, String defaultValue) {
        Element element2;
        void var1_1;
        Element child = XmlUtil.getElement(element, (String)var1_1);
        if (child == null) {
            void var2_2;
            return var2_2;
        }
        return element2.getTextContent();
    }

    public static List<Element> transElements(NodeList nodeList) {
        NodeList nodeList2;
        return XmlUtil.transElements(null, nodeList2);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Element> transElements(Element parentEle, NodeList nodeList) {
        void var3_3;
        int length = nodeList.getLength();
        ArrayList<Element> elements = new ArrayList<Element>(length);
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType()) continue;
            Element element = (Element)nodeList.item(i);
            if (parentEle != null && element.getParentNode() != parentEle) continue;
            elements.add(element);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static void writeObjectAsXml(File dest, Object bean) {
        XMLEncoder xmlenc = null;
        try {
            void var1_2;
            File file;
            xmlenc = new XMLEncoder(FileUtil.getOutputStream(file));
            xmlenc.writeObject(var1_2);
        }
        catch (Throwable throwable) {
            void var2_3;
            IoUtil.close((AutoCloseable)var2_3);
            throw throwable;
        }
        IoUtil.close(xmlenc);
    }

    public static XPath createXPath() {
        return XPathFactory.newInstance().newXPath();
    }

    /*
     * WARNING - void declaration
     */
    public static Element getElementByXPath(String expression, Object source) {
        void var1_1;
        return (Element)XmlUtil.getNodeByXPath(expression, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static NodeList getNodeListByXPath(String expression, Object source) {
        void var1_1;
        return (NodeList)XmlUtil.getByXPath(expression, var1_1, XPathConstants.NODESET);
    }

    /*
     * WARNING - void declaration
     */
    public static Node getNodeByXPath(String expression, Object source) {
        void var1_1;
        return (Node)XmlUtil.getByXPath(expression, var1_1, XPathConstants.NODE);
    }

    /*
     * WARNING - void declaration
     */
    public static Object getByXPath(String expression, Object source, QName returnType) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        UniversalNamespaceCache nsContext = null;
        if (source instanceof Node) {
            nsContext = new UniversalNamespaceCache((Node)source, false);
        }
        return XmlUtil.getByXPath(string, var1_1, (QName)var2_2, (NamespaceContext)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static Object getByXPath(String expression, Object source, QName returnType, NamespaceContext nsContext) {
        XPath xPath = XmlUtil.createXPath();
        if (nsContext != null) {
            void var3_4;
            xPath.setNamespaceContext((NamespaceContext)var3_4);
        }
        try {
            void var2_3;
            void var1_2;
            if (source instanceof InputSource) {
                return xPath.evaluate(expression, (InputSource)source, returnType);
            }
            return xPath.evaluate(expression, var1_2, (QName)var2_3);
        }
        catch (XPathExpressionException e) {
            void var0_1;
            throw new UtilException((Throwable)var0_1);
        }
    }

    public static String escape(String string) {
        return EscapeUtil.escapeHtml4(string);
    }

    public static String unescape(String string) {
        return EscapeUtil.unescapeHtml4(string);
    }

    public static Map<String, Object> xmlToMap(String xmlStr) {
        return XmlUtil.xmlToMap(xmlStr, new HashMap<String, Object>());
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T xmlToBean(Node node, Class<T> bean) {
        void var1_1;
        Map<String, Object> map;
        Map<String, Object> map2 = XmlUtil.xmlToMap(node);
        if (map2 != null && map2.size() == 1) {
            void var2_2;
            String simpleName = bean.getSimpleName();
            String nodeName = (String)CollUtil.getFirst(map2.keySet());
            if (var2_2.equalsIgnoreCase(nodeName)) {
                void var3_3;
                return BeanUtil.toBean(map2.get(var3_3), bean);
            }
        }
        return BeanUtil.toBean(map, var1_1);
    }

    public static Map<String, Object> xmlToMap(Node node) {
        return XmlUtil.xmlToMap(node, new HashMap<String, Object>());
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> xmlToMap(String xmlStr, Map<String, Object> result) {
        void var1_1;
        Element element;
        xmlStr = XmlUtil.parseXml((String)xmlStr);
        Element root = XmlUtil.getRootElement((Document)xmlStr);
        root.normalize();
        return XmlUtil.xmlToMap(element, (Map<String, Object>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> xmlToMap(Node node, Map<String, Object> result) {
        void var1_1;
        if (result == null) {
            result = new HashMap<String, Object>();
        }
        NodeList nodeList = node.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            void var3_4;
            Map<String, Object> map;
            Node childNode = nodeList.item(i);
            if (!XmlUtil.isElement(childNode)) continue;
            Element childEle = (Element)childNode;
            Object value = result.get(childEle.getNodeName());
            Object newValue = childEle.hasChildNodes() ? (MapUtil.isNotEmpty(map = XmlUtil.xmlToMap(childEle)) ? map : childEle.getTextContent()) : childEle.getTextContent();
            if (newValue == null) continue;
            if (value != null) {
                if (value instanceof List) {
                    ((List)value).add(newValue);
                    continue;
                }
                result.put(childEle.getNodeName(), CollUtil.newArrayList(value, newValue));
                continue;
            }
            result.put(var3_4.getNodeName(), newValue);
        }
        return var1_1;
    }

    public static String mapToXmlStr(Map<?, ?> data) {
        return XmlUtil.toStr(XmlUtil.mapToXml(data, "xml"));
    }

    /*
     * WARNING - void declaration
     */
    public static String mapToXmlStr(Map<?, ?> data, boolean omitXmlDeclaration) {
        void var1_1;
        return XmlUtil.toStr(XmlUtil.mapToXml(data, "xml"), "UTF-8", false, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String mapToXmlStr(Map<?, ?> data, String rootName) {
        void var1_1;
        return XmlUtil.toStr(XmlUtil.mapToXml(data, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String mapToXmlStr(Map<?, ?> data, String rootName, String namespace) {
        void var2_2;
        void var1_1;
        return XmlUtil.toStr(XmlUtil.mapToXml(data, (String)var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static String mapToXmlStr(Map<?, ?> data, String rootName, String namespace, boolean omitXmlDeclaration) {
        void var3_3;
        void var2_2;
        void var1_1;
        return XmlUtil.toStr(XmlUtil.mapToXml(data, (String)var1_1, (String)var2_2), "UTF-8", false, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static String mapToXmlStr(Map<?, ?> data, String rootName, String namespace, boolean isPretty, boolean omitXmlDeclaration) {
        void var3_3;
        void var2_2;
        void var1_1;
        return XmlUtil.toStr(XmlUtil.mapToXml(data, (String)var1_1, (String)var2_2), "UTF-8", (boolean)var3_3, omitXmlDeclaration);
    }

    /*
     * WARNING - void declaration
     */
    public static String mapToXmlStr(Map<?, ?> data, String rootName, String namespace, String charset, boolean isPretty, boolean omitXmlDeclaration) {
        void var3_3;
        void var2_2;
        void var1_1;
        return XmlUtil.toStr(XmlUtil.mapToXml(data, (String)var1_1, (String)var2_2), (String)var3_3, isPretty, omitXmlDeclaration);
    }

    /*
     * WARNING - void declaration
     */
    public static Document mapToXml(Map<?, ?> data, String rootName) {
        void var1_1;
        return XmlUtil.mapToXml(data, (String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Document mapToXml(Map<?, ?> data, String rootName, String namespace) {
        void var3_3;
        Map<?, ?> map;
        void var1_1;
        void var2_2;
        Document doc = XmlUtil.createXml();
        Element root = XmlUtil.appendChild(doc, rootName, (String)var2_2);
        XmlUtil.appendMap(doc, (Node)var1_1, map);
        return var3_3;
    }

    public static Document beanToXml(Object bean) {
        return XmlUtil.beanToXml(bean, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Document beanToXml(Object bean, String namespace) {
        void var1_1;
        return XmlUtil.beanToXml(bean, (String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Document beanToXml(Object bean, String namespace, boolean ignoreNull) {
        void var1_1;
        Object object;
        void var2_2;
        if (bean == null) {
            return null;
        }
        return XmlUtil.mapToXml(BeanUtil.beanToMap(bean, false, (boolean)var2_2), object.getClass().getSimpleName(), (String)var1_1);
    }

    public static boolean isElement(Node node) {
        Node node2;
        return node != null && 1 == node2.getNodeType();
    }

    /*
     * WARNING - void declaration
     */
    public static Element appendChild(Node node, String tagName) {
        void var1_1;
        return XmlUtil.appendChild(node, (String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Element appendChild(Node node, String tagName, String namespace) {
        void var1_1;
        Node node2;
        void var2_2;
        void var3_3;
        Document doc = XmlUtil.getOwnerDocument(node);
        Element child = namespace == null ? doc.createElement(tagName) : var3_3.createElementNS((String)var2_2, tagName);
        node2.appendChild(child);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Node appendText(Node node, CharSequence text) {
        void var1_1;
        Node node2;
        return XmlUtil.appendText(XmlUtil.getOwnerDocument(node), node2, (CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void append(Node node, Object data) {
        void var1_1;
        Node node2;
        XmlUtil.append(XmlUtil.getOwnerDocument(node), node2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void append(Document doc, Node node, Object data) {
        void var2_2;
        void var1_1;
        Document document;
        if (data instanceof Map) {
            XmlUtil.appendMap(doc, node, (Map)data);
            return;
        }
        if (data instanceof Iterator) {
            XmlUtil.appendIterator(doc, node, (Iterator)data);
            return;
        }
        if (data instanceof Iterable) {
            XmlUtil.appendIterator(doc, node, ((Iterable)data).iterator());
            return;
        }
        XmlUtil.appendText(document, (Node)var1_1, var2_2.toString());
    }

    /*
     * WARNING - void declaration
     */
    private static void appendMap(Document doc, Node node, Map data) {
        Document document;
        void var1_1;
        data.forEach((arg_0, arg_1) -> XmlUtil.lambda$appendMap$0((Node)var1_1, document, arg_0, arg_1));
    }

    private static void appendIterator(Document doc, Node node, Iterator data) {
        Node parentNode = node.getParentNode();
        boolean isFirst = true;
        while (data.hasNext()) {
            Object eleData = data.next();
            if (isFirst) {
                XmlUtil.append(doc, node, eleData);
                isFirst = false;
                continue;
            }
            Node cloneNode = node.cloneNode(false);
            parentNode.appendChild(cloneNode);
            XmlUtil.append(doc, cloneNode, eleData);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Node appendText(Document doc, Node node, CharSequence text) {
        void var2_2;
        Document document;
        return node.appendChild(document.createTextNode(StrUtil.str((CharSequence)var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    private static DocumentBuilderFactory disableXXE(DocumentBuilderFactory dbf) {
        DocumentBuilderFactory documentBuilderFactory;
        try {
            void var1_1;
            String feature = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(feature, true);
            feature = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(feature, false);
            feature = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(feature, false);
            feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            dbf.setFeature((String)var1_1, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        return documentBuilderFactory;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$appendMap$0(Node node, Document doc, Object key, Object value) {
        if (key != null) {
            void var2_2;
            Node child = XmlUtil.appendChild(node, var2_2.toString());
            if (value != null) {
                void var3_3;
                Node node2;
                void var1_1;
                XmlUtil.append((Document)var1_1, node2, var3_3);
            }
        }
    }

    public static class UniversalNamespaceCache
    implements NamespaceContext {
        private static final String DEFAULT_NS = "DEFAULT";
        private final BiMap<String, String> prefixUri = new BiMap(new HashMap());

        /*
         * WARNING - void declaration
         */
        public UniversalNamespaceCache(Node node, boolean toplevelOnly) {
            void var2_2;
            void var1_1;
            this.examineNode(var1_1.getFirstChild(), (boolean)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private void examineNode(Node node, boolean attributesOnly) {
            NodeList childNodes;
            void var2_3;
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                int length = attributes.getLength();
                for (int i = 0; i < length; ++i) {
                    Node attribute = attributes.item(i);
                    this.storeAttribute(attribute);
                }
            }
            if (var2_3 == false && (childNodes = node.getChildNodes()) != null) {
                int childLength = childNodes.getLength();
                for (int i = 0; i < childLength; ++i) {
                    Node item = childNodes.item(i);
                    if (item.getNodeType() != 1) continue;
                    this.examineNode(item, false);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void storeAttribute(Node attribute) {
            if (attribute == null) {
                return;
            }
            if ("http://www.w3.org/2000/xmlns/".equals(attribute.getNamespaceURI())) {
                void var1_1;
                if ("xmlns".equals(attribute.getNodeName())) {
                    ((MapWrapper)this.prefixUri).put(DEFAULT_NS, attribute.getNodeValue());
                    return;
                }
                ((MapWrapper)this.prefixUri).put(attribute.getLocalName(), var1_1.getNodeValue());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String getNamespaceURI(String prefix) {
            void var1_1;
            if (prefix == null || "".equals(prefix)) {
                return (String)this.prefixUri.get(DEFAULT_NS);
            }
            return (String)this.prefixUri.get(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String getPrefix(String namespaceURI) {
            void var1_1;
            return this.prefixUri.getInverse().get(var1_1);
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

