/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.URLDecoder;
import cn.hutool.core.net.URLEncodeUtil;
import cn.hutool.core.net.url.UrlQuery;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.StrUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.jar.JarFile;

public class URLUtil
extends URLEncodeUtil {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String WAR_URL_PREFIX = "war:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String WAR_URL_SEPARATOR = "*/";

    /*
     * WARNING - void declaration
     */
    public static URL url(URI uri) throws UtilException {
        if (uri == null) {
            return null;
        }
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            void var0_1;
            throw new UtilException((Throwable)var0_1);
        }
    }

    public static URL url(String url) {
        return URLUtil.url(url, null);
    }

    /*
     * WARNING - void declaration
     */
    public static URL url(String url, URLStreamHandler handler) {
        if (url == null) {
            return null;
        }
        if (url.startsWith(CLASSPATH_URL_PREFIX)) {
            url = url.substring(10);
            return ClassLoaderUtil.getClassLoader().getResource(url);
        }
        try {
            return new URL(null, url, handler);
        }
        catch (MalformedURLException malformedURLException) {
            MalformedURLException e = malformedURLException;
            if (malformedURLException.getMessage().contains("Accessing an URL protocol that was not enabled")) {
                throw new UtilException(e);
            }
            try {
                String string;
                return new File(string).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                void var1_1;
                throw new UtilException((Throwable)var1_1);
            }
        }
    }

    public static URI getStringURI(CharSequence content) {
        CharSequence charSequence;
        if (content == null) {
            return null;
        }
        charSequence = StrUtil.addPrefixIfNot(charSequence, "string:///");
        return URI.create((String)charSequence);
    }

    public static URL toUrlForHttp(String urlStr) {
        return URLUtil.toUrlForHttp(urlStr, null);
    }

    /*
     * WARNING - void declaration
     */
    public static URL toUrlForHttp(String urlStr, URLStreamHandler handler) {
        Assert.notBlank(urlStr, "Url is blank !", new Object[0]);
        urlStr = URLUtil.encodeBlank(urlStr);
        try {
            void var1_2;
            return new URL(null, urlStr, (URLStreamHandler)var1_2);
        }
        catch (MalformedURLException e) {
            void var0_1;
            throw new UtilException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String encodeBlank(CharSequence urlStr) {
        void var2_2;
        if (urlStr == null) {
            return null;
        }
        int len = urlStr.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            void var3_4;
            char c = urlStr.charAt(i);
            if (CharUtil.isBlankChar(c)) {
                sb.append("%20");
                continue;
            }
            sb.append((char)var3_4);
        }
        return var2_2.toString();
    }

    public static URL getURL(String pathBaseClassLoader) {
        return ResourceUtil.getResource(pathBaseClassLoader);
    }

    /*
     * WARNING - void declaration
     */
    public static URL getURL(String path, Class<?> clazz) {
        void var1_1;
        return ResourceUtil.getResource(path, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static URL getURL(File file) {
        Assert.notNull(file, "File is null !", new Object[0]);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            void var0_1;
            throw new UtilException((Throwable)var0_1, "Error occured when get URL!", new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static URL[] getURLs(File ... files) {
        void var1_1;
        URL[] urls = new URL[files.length];
        try {
            for (int i = 0; i < files.length; ++i) {
                urls[i] = files[i].toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            void var2_3;
            throw new UtilException((Throwable)var2_3, "Error occured when get URL!", new Object[0]);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static URI getHost(URL url) {
        if (url == null) {
            return null;
        }
        try {
            return new URI(url.getProtocol(), url.getHost(), null, null);
        }
        catch (URISyntaxException e) {
            void var0_1;
            throw new UtilException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String completeUrl(String baseUrl, String relativePath) {
        if (StrUtil.isBlank(baseUrl = URLUtil.normalize(baseUrl, false))) {
            return null;
        }
        try {
            void var1_2;
            Object absoluteUrl = new URL(baseUrl);
            absoluteUrl = new URL((URL)absoluteUrl, (String)var1_2);
            return ((URL)absoluteUrl).toString();
        }
        catch (MalformedURLException e) {
            void var0_1;
            throw new UtilException((Throwable)var0_1);
        }
    }

    public static String decode(String url) throws UtilException {
        return URLUtil.decode(url, "UTF-8");
    }

    /*
     * WARNING - void declaration
     */
    public static String decode(String content, Charset charset) {
        void var1_1;
        return URLDecoder.decode(content, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String decode(String content, Charset charset, boolean isPlusToSpace) {
        void var2_2;
        void var1_1;
        return URLDecoder.decode(content, (Charset)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String decode(String content, String charset) throws UtilException {
        void var1_1;
        return URLUtil.decode(content, StrUtil.isEmpty(charset) ? null : CharsetUtil.charset((String)var1_1));
    }

    public static String getPath(String uriStr) {
        return URLUtil.toURI(uriStr).getPath();
    }

    /*
     * WARNING - void declaration
     */
    public static String getDecodedPath(URL url) {
        URL uRL;
        if (url == null) {
            return null;
        }
        String path = null;
        try {
            path = URLUtil.toURI(url).getPath();
        }
        catch (UtilException utilException) {}
        if (path != null) {
            void var1_1;
            return var1_1;
        }
        return uRL.getPath();
    }

    public static URI toURI(URL url) throws UtilException {
        return URLUtil.toURI(url, false);
    }

    /*
     * WARNING - void declaration
     */
    public static URI toURI(URL url, boolean isEncode) throws UtilException {
        void var1_1;
        URL uRL;
        if (url == null) {
            return null;
        }
        return URLUtil.toURI(uRL.toString(), (boolean)var1_1);
    }

    public static URI toURI(String location) throws UtilException {
        return URLUtil.toURI(location, false);
    }

    /*
     * WARNING - void declaration
     */
    public static URI toURI(String location, boolean isEncode) throws UtilException {
        if (isEncode) {
            location = URLUtil.encode(location);
        }
        try {
            return new URI(StrUtil.trim(location));
        }
        catch (URISyntaxException e) {
            void var0_1;
            throw new UtilException((Throwable)var0_1);
        }
    }

    public static boolean isFileURL(URL url) {
        String string;
        Assert.notNull(url, "URL must be not null", new Object[0]);
        String protocol = url.getProtocol();
        return URL_PROTOCOL_FILE.equals(protocol) || URL_PROTOCOL_VFSFILE.equals(protocol) || URL_PROTOCOL_VFS.equals(string);
    }

    public static boolean isJarURL(URL url) {
        String string;
        Assert.notNull(url, "URL must be not null", new Object[0]);
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_VFSZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(string);
    }

    public static boolean isJarFileURL(URL url) {
        URL uRL;
        Assert.notNull(url, "URL must be not null", new Object[0]);
        return URL_PROTOCOL_FILE.equals(url.getProtocol()) && uRL.getPath().toLowerCase().endsWith(".jar");
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream getStream(URL url) {
        Assert.notNull(url, "URL must be not null", new Object[0]);
        try {
            return url.openStream();
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static BufferedReader getReader(URL url, Charset charset) {
        void var1_1;
        return IoUtil.getReader(URLUtil.getStream(url), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static JarFile getJarFile(URL url) {
        try {
            url = (JarURLConnection)((URL)url).openConnection();
            return ((JarURLConnection)url).getJarFile();
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    public static String normalize(String url) {
        return URLUtil.normalize(url, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String normalize(String url, boolean isEncodePath) {
        void var1_1;
        return URLUtil.normalize(url, (boolean)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String normalize(String url, boolean isEncodePath, boolean replaceSlash) {
        void var3_4;
        void var1_1;
        String body;
        String protocol;
        if (StrUtil.isBlank(url)) {
            return url;
        }
        int sepIndex = url.indexOf("://");
        if (sepIndex > 0) {
            protocol = StrUtil.subPre(url, sepIndex + 3);
            body = StrUtil.subSuf(url, sepIndex + 3);
        } else {
            protocol = "http://";
        }
        int paramsSepIndex = StrUtil.indexOf(body, '?');
        String params = null;
        if (paramsSepIndex > 0) {
            params = StrUtil.subSuf(body, paramsSepIndex);
            body = StrUtil.subPre(body, paramsSepIndex);
        }
        if (StrUtil.isNotEmpty(body)) {
            body = body.replaceAll("^[\\\\/]+", "");
            body = body.replace("\\", "/");
            if (replaceSlash) {
                body = body.replaceAll("//+", "/");
            }
        }
        int pathSepIndex = StrUtil.indexOf(body, '/');
        String domain = body;
        String path = null;
        if (pathSepIndex > 0) {
            void var2_2;
            String string;
            domain = StrUtil.subPre(body, pathSepIndex);
            path = StrUtil.subSuf(string, (int)var2_2);
        }
        if (var1_1 != false) {
            path = URLUtil.encode(path);
        }
        return protocol + (String)var3_4 + StrUtil.nullToEmpty(path) + StrUtil.nullToEmpty(params);
    }

    /*
     * WARNING - void declaration
     */
    public static String buildQuery(Map<String, ?> paramMap, Charset charset) {
        void var1_1;
        return UrlQuery.of(paramMap).build((Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long getContentLength(URL url) throws IORuntimeException {
        long l;
        if (url == null) {
            return -1L;
        }
        URLConnection conn = null;
        try {
            URL uRL;
            conn = uRL.openConnection();
            l = conn.getContentLengthLong();
        }
        catch (IOException e) {
            try {
                void var2_4;
                throw new IORuntimeException((Throwable)var2_4);
            }
            catch (Throwable throwable) {
                if (conn instanceof HttpURLConnection) {
                    void var1_2;
                    ((HttpURLConnection)var1_2).disconnect();
                }
                throw throwable;
            }
        }
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public static String getDataUriBase64(String mimeType, String data) {
        void var1_1;
        return URLUtil.getDataUri(mimeType, null, "base64", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String getDataUri(String mimeType, String encoding, String data) {
        void var2_2;
        void var1_1;
        return URLUtil.getDataUri(mimeType, null, (String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String getDataUri(String mimeType, Charset charset, String encoding, String data) {
        void var3_3;
        StringBuilder builder = StrUtil.builder("data:");
        if (StrUtil.isNotBlank(mimeType)) {
            String string;
            builder.append(string);
        }
        if (charset != null) {
            void var1_1;
            builder.append(";charset=").append(var1_1.name());
        }
        if (StrUtil.isNotBlank(encoding)) {
            void var2_2;
            builder.append(';').append((String)var2_2);
        }
        builder.append(',').append((String)var3_3);
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static long size(URL url) {
        URLConnection file;
        if (URLUtil.isFileURL(url)) {
            void var2_2;
            file = FileUtil.file(url);
            long length = ((File)((Object)file)).length();
            if (length == 0L && !((File)((Object)file)).exists()) {
                throw new IORuntimeException("File not exist or size is zero!");
            }
            return (long)var2_2;
        }
        try {
            URLConnection con = ((URL)((Object)file)).openConnection();
            URLUtil.useCachesIfNecessary(con);
            if (con instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)con;
                httpURLConnection.setRequestMethod("HEAD");
            }
            return con.getContentLengthLong();
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    public static void useCachesIfNecessary(URLConnection con) {
        URLConnection uRLConnection = con;
        uRLConnection.setUseCaches(uRLConnection.getClass().getSimpleName().startsWith("JNLP"));
    }
}

