/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.lang.ParameterizedTypeImpl;
import cn.hutool.core.lang.reflect.ActualTypeMapperPool;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Map;

public class TypeUtil {
    public static Class<?> getClass(Type type) {
        while (type != null) {
            Object object;
            Object upperBounds;
            Object bounds;
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable) {
                bounds = ((TypeVariable)type).getBounds();
                if (((Type[])bounds).length != 1) break;
                bounds = bounds[0];
                continue;
            }
            if (!(bounds instanceof WildcardType) || ((Type[])(upperBounds = ((WildcardType)bounds).getUpperBounds())).length != 1) break;
            object = object[0];
        }
        return null;
    }

    public static Type getType(Field field) {
        Field field2;
        if (field == null) {
            return null;
        }
        return field2.getGenericType();
    }

    /*
     * WARNING - void declaration
     */
    public static Type getFieldType(Class<?> clazz, String fieldName) {
        void var1_1;
        return TypeUtil.getType(ReflectUtil.getField(clazz, (String)var1_1));
    }

    public static Class<?> getClass(Field field) {
        Field field2;
        if (field == null) {
            return null;
        }
        return field2.getType();
    }

    public static Type getFirstParamType(Method method) {
        return TypeUtil.getParamType(method, 0);
    }

    public static Class<?> getFirstParamClass(Method method) {
        return TypeUtil.getParamClass(method, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static Type getParamType(Method method, int index) {
        Type[] types = TypeUtil.getParamTypes(method);
        if (types != null && types.length > index) {
            void var1_1;
            Type[] typeArray;
            return typeArray[var1_1];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> getParamClass(Method method, int index) {
        Class<?>[] classes = TypeUtil.getParamClasses(method);
        if (classes != null && classes.length > index) {
            void var1_1;
            Class<?>[] classArray;
            return classArray[var1_1];
        }
        return null;
    }

    public static Type[] getParamTypes(Method method) {
        Method method2;
        if (method == null) {
            return null;
        }
        return method2.getGenericParameterTypes();
    }

    public static Class<?>[] getParamClasses(Method method) {
        Method method2;
        if (method == null) {
            return null;
        }
        return method2.getParameterTypes();
    }

    public static Type getReturnType(Method method) {
        Method method2;
        if (method == null) {
            return null;
        }
        return method2.getGenericReturnType();
    }

    public static Class<?> getReturnClass(Method method) {
        Method method2;
        if (method == null) {
            return null;
        }
        return method2.getReturnType();
    }

    public static Type getTypeArgument(Type type) {
        return TypeUtil.getTypeArgument(type, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static Type getTypeArgument(Type type, int index) {
        Type[] typeArguments = TypeUtil.getTypeArguments(type);
        if (typeArguments != null && typeArguments.length > index) {
            void var1_1;
            Type[] typeArray;
            return typeArray[var1_1];
        }
        return null;
    }

    public static Type[] getTypeArguments(Type type) {
        Type type2;
        if (type == null) {
            return null;
        }
        Type parameterizedType = TypeUtil.toParameterizedType(type);
        if (parameterizedType == null) {
            return null;
        }
        return type2.getActualTypeArguments();
    }

    public static ParameterizedType toParameterizedType(Type type) {
        return TypeUtil.toParameterizedType(type, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static ParameterizedType toParameterizedType(Type type, int interfaceIndex) {
        ParameterizedType[] generics;
        if (type instanceof ParameterizedType) {
            return (ParameterizedType)type;
        }
        if (type instanceof Class && (generics = TypeUtil.getGenerics((Class)type)).length > interfaceIndex) {
            void var1_1;
            ParameterizedType[] parameterizedTypeArray;
            return parameterizedTypeArray[var1_1];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static ParameterizedType[] getGenerics(Class<?> clazz) {
        void var1_1;
        Class<?> clazz2;
        Type[] genericInterfaces;
        ParameterizedType parameterizedType;
        ArrayList<ParameterizedType> result = new ArrayList<ParameterizedType>();
        Type genericSuper = clazz.getGenericSuperclass();
        if (genericSuper != null && !Object.class.equals((Object)genericSuper) && (parameterizedType = TypeUtil.toParameterizedType(genericSuper)) != null) {
            result.add(parameterizedType);
        }
        if (ArrayUtil.isNotEmpty(genericInterfaces = clazz2.getGenericInterfaces())) {
            void var2_2;
            for (Class<?> clazz3 : var2_2) {
                ParameterizedType parameterizedType2 = TypeUtil.toParameterizedType(clazz3);
                if (parameterizedType2 == null) continue;
                result.add(parameterizedType2);
            }
        }
        return var1_1.toArray(new ParameterizedType[0]);
    }

    public static boolean isUnknown(Type type) {
        Type type2;
        return type == null || type2 instanceof TypeVariable;
    }

    public static boolean hasTypeVariable(Type ... types) {
        Type[] typeArray = types;
        int n = types.length;
        for (int i = 0; i < n; ++i) {
            Type type = typeArray[i];
            if (!(type instanceof TypeVariable)) continue;
            return true;
        }
        return false;
    }

    public static Map<Type, Type> getTypeMap(Class<?> clazz) {
        return ActualTypeMapperPool.get(clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static Type getActualType(Type type, Field field) {
        void var1_1;
        Type type2;
        if (field == null) {
            return null;
        }
        return TypeUtil.getActualType((Type)ObjectUtil.defaultIfNull(type2, field.getDeclaringClass()), var1_1.getGenericType());
    }

    /*
     * WARNING - void declaration
     */
    public static Type getActualType(Type type, Type typeVariable) {
        void var1_1;
        if (typeVariable instanceof ParameterizedType) {
            return TypeUtil.getActualType(type, (ParameterizedType)typeVariable);
        }
        if (typeVariable instanceof TypeVariable) {
            Type type2;
            return ActualTypeMapperPool.getActualType(type2, (TypeVariable)typeVariable);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Type getActualType(Type type, ParameterizedType parameterizedType) {
        void var1_1;
        Type type2;
        Type[] actualTypeArguments;
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        if (TypeUtil.hasTypeVariable(typeArray) && ArrayUtil.isNotEmpty(actualTypeArguments = TypeUtil.getActualTypes(type2, parameterizedType.getActualTypeArguments()))) {
            parameterizedType = new ParameterizedTypeImpl(typeArray, parameterizedType.getOwnerType(), parameterizedType.getRawType());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Type[] getActualTypes(Type type, Type ... typeVariables) {
        void var1_1;
        return ActualTypeMapperPool.getActualTypes(type, (Type[])var1_1);
    }
}

