/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Properties;

public class SystemPropsUtil {
    public static String HUTOOL_DATE_LENIENT = "hutool.date.lenient";

    /*
     * WARNING - void declaration
     */
    public static String get(String name, String defaultValue) {
        void var1_1;
        return StrUtil.nullToDefault(SystemPropsUtil.get(name, false), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String get(String name, boolean quiet) {
        void var2_2;
        block6: {
            String value;
            block5: {
                value = null;
                try {
                    value = System.getProperty(name);
                }
                catch (SecurityException securityException) {
                    if (quiet) break block5;
                    Console.error("Caught a SecurityException reading the system property '{}'; the SystemUtil property value will default to null.", name);
                }
            }
            if (value == null) {
                try {
                    value = System.getenv(name);
                }
                catch (SecurityException securityException) {
                    String string;
                    void var1_1;
                    if (var1_1 != false) break block6;
                    Console.error("Caught a SecurityException reading the system env '{}'; the SystemUtil env value will default to null.", string);
                }
            }
        }
        return var2_2;
    }

    public static String get(String key) {
        return SystemPropsUtil.get(key, null);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean getBoolean(String key, boolean defaultValue) {
        String string;
        String value = SystemPropsUtil.get(key);
        if (value == null) {
            void var1_1;
            return (boolean)var1_1;
        }
        return BooleanUtil.toBoolean(string);
    }

    /*
     * WARNING - void declaration
     */
    public static int getInt(String key, int defaultValue) {
        void var1_1;
        return Convert.toInt(SystemPropsUtil.get(key), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long getLong(String key, long defaultValue) {
        void var1_1;
        return Convert.toLong(SystemPropsUtil.get(key), (long)var1_1);
    }

    public static Properties getProps() {
        return System.getProperties();
    }

    /*
     * WARNING - void declaration
     */
    public static void set(String key, String value) {
        void var1_1;
        String string;
        if (value == null) {
            System.clearProperty(key);
            return;
        }
        System.setProperty(string, (String)var1_1);
    }
}

