/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.text.StrPool;
import cn.hutool.core.text.TextSimilarity;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.IdUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class StrUtil
extends CharSequenceUtil
implements StrPool {
    public static boolean isBlankIfStr(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            Object object;
            return StrUtil.isBlank((CharSequence)object);
        }
        return false;
    }

    public static boolean isEmptyIfStr(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            Object object;
            return 0 == ((CharSequence)object).length();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static void trim(String[] strs) {
        if (strs == null) {
            return;
        }
        for (int i = 0; i < strs.length; ++i) {
            void var1_2;
            String str = strs[i];
            if (str == null) continue;
            strs[i] = StrUtil.trim((CharSequence)var1_2);
        }
    }

    public static String utf8Str(Object obj) {
        return StrUtil.str(obj, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String str(Object obj, String charsetName) {
        void var1_1;
        return StrUtil.str(obj, Charset.forName((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String str(Object obj, Charset charset) {
        Object object;
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StrUtil.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StrUtil.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            void var1_1;
            return StrUtil.str((ByteBuffer)obj, (Charset)var1_1);
        }
        if (ArrayUtil.isArray(obj)) {
            return ArrayUtil.toString(obj);
        }
        return object.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String str(byte[] bytes, String charset) {
        void var1_1;
        return StrUtil.str(bytes, CharsetUtil.charset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String str(byte[] data, Charset charset) {
        void var1_1;
        byte[] byArray;
        if (data == null) {
            return null;
        }
        if (charset == null) {
            return new String(data);
        }
        return new String(byArray, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String str(Byte[] bytes, String charset) {
        void var1_1;
        return StrUtil.str(bytes, CharsetUtil.charset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String str(Byte[] data, Charset charset) {
        void var1_1;
        void var2_2;
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            void var3_4;
            Byte dataByte = data[i];
            bytes[i] = dataByte == null ? -1 : (int)var3_4.byteValue();
        }
        return StrUtil.str((byte[])var2_2, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String str(ByteBuffer data, String charset) {
        void var1_1;
        ByteBuffer byteBuffer;
        if (data == null) {
            return null;
        }
        return StrUtil.str(byteBuffer, CharsetUtil.charset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String str(ByteBuffer data, Charset charset) {
        ByteBuffer byteBuffer;
        void var1_1;
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        return var1_1.decode(byteBuffer).toString();
    }

    public static String toString(Object obj) {
        return String.valueOf(obj);
    }

    public static String toStringOrNull(Object obj) {
        Object object;
        if (obj == null) {
            return null;
        }
        return object.toString();
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static StrBuilder strBuilder() {
        return StrBuilder.create();
    }

    public static StringBuilder builder(int capacity) {
        int n;
        return new StringBuilder(n);
    }

    public static StrBuilder strBuilder(int capacity) {
        return StrBuilder.create(capacity);
    }

    public static StringReader getReader(CharSequence str) {
        CharSequence charSequence;
        if (str == null) {
            return null;
        }
        return new StringReader(charSequence.toString());
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static String reverse(String str) {
        String string;
        return new String(ArrayUtil.reverse(string.toCharArray()));
    }

    /*
     * WARNING - void declaration
     */
    public static String fillBefore(String str, char filledChar, int len) {
        void var2_2;
        void var1_1;
        return StrUtil.fill(str, (char)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String fillAfter(String str, char filledChar, int len) {
        void var2_2;
        void var1_1;
        return StrUtil.fill(str, (char)var1_1, (int)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String fill(String str, char filledChar, int len, boolean isPre) {
        void var1_2;
        String string;
        void var3_4;
        void var2_3;
        int strLen = str.length();
        if (strLen > len) {
            return str;
        }
        String filledStr = StrUtil.repeat(filledChar, (int)(var2_3 - strLen));
        if (var3_4 != false) {
            return filledStr.concat(str);
        }
        return string.concat((String)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public static double similar(String str1, String str2) {
        void var1_1;
        return TextSimilarity.similar(str1, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String similar(String str1, String str2, int scale) {
        void var2_2;
        void var1_1;
        return TextSimilarity.similar(str1, (String)var1_1, (int)var2_2);
    }

    public static String uuid() {
        return IdUtil.randomUUID();
    }

    /*
     * WARNING - void declaration
     */
    public static String format(CharSequence template, Map<?, ?> map) {
        void var1_1;
        return StrUtil.format(template, var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String format(CharSequence template, Map<?, ?> map, boolean ignoreNull) {
        void var2_2;
        void var1_1;
        return StrFormatter.format(template, var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String truncateUtf8(String str, int maxBytes) {
        void var1_1;
        void var2_2;
        String string;
        Charset charset = StandardCharsets.UTF_8;
        return StrUtil.truncateByByteLength(string, (Charset)var2_2, (int)var1_1, 4, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String truncateByByteLength(String str, Charset charset, int maxBytes, int factor, boolean appendDots) {
        void var0_2;
        void var1_3;
        void var2_5;
        void var3_7;
        if (str == null || str.length() * factor <= maxBytes) {
            return str;
        }
        byte[] sba = str.getBytes(charset);
        if (sba.length <= maxBytes) {
            return str;
        }
        int limitBytes = appendDots ? maxBytes - "...".getBytes(charset).length : maxBytes;
        ByteBuffer bb = ByteBuffer.wrap((byte[])var3_7, 0, limitBytes);
        CharBuffer cb = CharBuffer.allocate(limitBytes);
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        decoder.decode((ByteBuffer)var2_5, cb, true);
        var1_3.flush(cb);
        String result = new String(cb.array(), 0, cb.position());
        if (appendDots) {
            return result + "...";
        }
        return var0_2;
    }
}

