/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Pid;
import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class RuntimeUtil {
    public static String execForStr(String ... cmds) throws IORuntimeException {
        String[] stringArray;
        return RuntimeUtil.execForStr(CharsetUtil.systemCharset(), stringArray);
    }

    public static String execForStr(Charset charset, String ... cmds) throws IORuntimeException {
        Charset charset2;
        return RuntimeUtil.getResult(RuntimeUtil.exec(cmds), charset2);
    }

    public static List<String> execForLines(String ... cmds) throws IORuntimeException {
        String[] stringArray;
        return RuntimeUtil.execForLines(CharsetUtil.systemCharset(), stringArray);
    }

    public static List<String> execForLines(Charset charset, String ... cmds) throws IORuntimeException {
        Charset charset2;
        return RuntimeUtil.getResultLines(RuntimeUtil.exec(cmds), charset2);
    }

    public static Process exec(String ... cmds) {
        Object object;
        try {
            Object process = new ProcessBuilder(RuntimeUtil.handleCmds(cmds)).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static Process exec(String[] envp, String ... cmds) {
        void var1_1;
        return RuntimeUtil.exec(envp, null, (String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Process exec(String[] envp, File dir, String ... cmds) {
        try {
            void var1_2;
            void var2_3;
            return Runtime.getRuntime().exec(RuntimeUtil.handleCmds((String[])var2_3), envp, (File)var1_2);
        }
        catch (IOException e) {
            void var0_1;
            throw new IORuntimeException((Throwable)var0_1);
        }
    }

    public static List<String> getResultLines(Process process) {
        return RuntimeUtil.getResultLines(process, CharsetUtil.systemCharset());
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getResultLines(Process process, Charset charset) {
        List list;
        InputStream in = null;
        try {
            in = process.getInputStream();
            list = IoUtil.readLines(in, (Charset)((Object)list), new ArrayList());
        }
        catch (Throwable throwable) {
            Process process2;
            void var2_3;
            IoUtil.close((Closeable)var2_3);
            RuntimeUtil.destroy(process2);
            throw throwable;
        }
        IoUtil.close(in);
        RuntimeUtil.destroy(process);
        return list;
    }

    public static String getResult(Process process) {
        return RuntimeUtil.getResult(process, CharsetUtil.systemCharset());
    }

    /*
     * WARNING - void declaration
     */
    public static String getResult(Process process, Charset charset) {
        String string;
        InputStream in = null;
        try {
            in = process.getInputStream();
            string = IoUtil.read(in, (Charset)((Object)string));
        }
        catch (Throwable throwable) {
            Process process2;
            void var2_3;
            IoUtil.close((Closeable)var2_3);
            RuntimeUtil.destroy(process2);
            throw throwable;
        }
        IoUtil.close(in);
        RuntimeUtil.destroy(process);
        return string;
    }

    public static String getErrorResult(Process process) {
        return RuntimeUtil.getErrorResult(process, CharsetUtil.systemCharset());
    }

    /*
     * WARNING - void declaration
     */
    public static String getErrorResult(Process process, Charset charset) {
        String string;
        InputStream in = null;
        try {
            in = process.getErrorStream();
            string = IoUtil.read(in, (Charset)((Object)string));
        }
        catch (Throwable throwable) {
            Process process2;
            void var2_3;
            IoUtil.close((Closeable)var2_3);
            RuntimeUtil.destroy(process2);
            throw throwable;
        }
        IoUtil.close(in);
        RuntimeUtil.destroy(process);
        return string;
    }

    public static void destroy(Process process) {
        if (process != null) {
            Process process2;
            process2.destroy();
        }
    }

    public static void addShutdownHook(Runnable hook) {
        Runnable runnable;
        Runtime.getRuntime().addShutdownHook(hook instanceof Thread ? (Thread)hook : new Thread(runnable));
    }

    /*
     * WARNING - void declaration
     */
    public static int getProcessorCount() {
        void var0;
        int cpu = Runtime.getRuntime().availableProcessors();
        if (cpu <= 0) {
            cpu = 7;
        }
        return (int)var0;
    }

    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static long getUsableMemory() {
        return RuntimeUtil.getMaxMemory() - RuntimeUtil.getTotalMemory() + RuntimeUtil.getFreeMemory();
    }

    public static int getPid() throws UtilException {
        return Pid.INSTANCE.get();
    }

    private static String[] handleCmds(String ... cmds) {
        Object object;
        if (ArrayUtil.isEmpty(cmds)) {
            throw new NullPointerException("Command is empty !");
        }
        if (1 == cmds.length) {
            Object cmd = cmds[0];
            if (StrUtil.isBlank((CharSequence)cmd)) {
                throw new NullPointerException("Command is blank !");
            }
            object = RuntimeUtil.cmdSplit((String)object);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static String[] cmdSplit(String cmd) {
        void var1_1;
        ArrayList<String> cmds = new ArrayList<String>();
        int length = cmd.length();
        Stack<Character> stack = new Stack<Character>();
        boolean inWrap = false;
        StrBuilder cache = StrUtil.strBuilder();
        block4: for (int i = 0; i < length; ++i) {
            char c = cmd.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': {
                    if (inWrap) {
                        if (c == ((Character)stack.peek()).charValue()) {
                            stack.pop();
                            inWrap = false;
                        }
                        cache.append(c);
                        continue block4;
                    }
                    stack.push(Character.valueOf(c));
                    cache.append(c);
                    inWrap = true;
                    continue block4;
                }
                case ' ': {
                    if (inWrap) {
                        cache.append(c);
                        continue block4;
                    }
                    cmds.add(cache.toString());
                    cache.reset();
                    continue block4;
                }
                default: {
                    cache.append(c);
                }
            }
        }
        if (cache.hasContent()) {
            cmds.add(cache.toString());
        }
        return var1_1.toArray(new String[0]);
    }
}

