/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.annotation.Alias;
import cn.hutool.core.bean.NullWrapperBean;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.UniqueKeySet;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.InvocationTargetRuntimeException;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.reflect.MethodHandleUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.map.WeakConcurrentMap;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ModifierUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReflectUtil {
    private static final WeakConcurrentMap<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = new WeakConcurrentMap();
    private static final WeakConcurrentMap<Class<?>, Field[]> FIELDS_CACHE = new WeakConcurrentMap();
    private static final WeakConcurrentMap<Class<?>, Method[]> METHODS_CACHE = new WeakConcurrentMap();

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        GenericDeclaration[] genericDeclarationArray;
        if (clazz == null) {
            return null;
        }
        genericDeclarationArray = ReflectUtil.getConstructors(genericDeclarationArray);
        Constructor<T>[] constructorArray = genericDeclarationArray;
        int n = genericDeclarationArray.length;
        for (int i = 0; i < n; ++i) {
            Constructor<T> constructor = constructorArray[i];
            genericDeclarationArray = constructor.getParameterTypes();
            if (!ClassUtil.isAllAssignableFrom(genericDeclarationArray, parameterTypes)) continue;
            ReflectUtil.setAccessible(constructor);
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        Class clazz;
        Assert.notNull(beanClass);
        Class clazz2 = clazz;
        return CONSTRUCTORS_CACHE.computeIfAbsent(clazz2, () -> ReflectUtil.getConstructorsDirectly(clazz2));
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        return beanClass.getDeclaredConstructors();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasField(Class<?> beanClass, String name) throws SecurityException {
        void var1_1;
        Class<?> clazz;
        return null != ReflectUtil.getField(clazz, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String getFieldName(Field field) {
        Field field2;
        if (field == null) {
            return null;
        }
        Alias alias = field.getAnnotation(Alias.class);
        if (alias != null) {
            void var1_1;
            return var1_1.value();
        }
        return field2.getName();
    }

    /*
     * WARNING - void declaration
     */
    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fieldArray;
        void var1_1;
        Field[] fields = ReflectUtil.getFields(beanClass);
        return ArrayUtil.firstMatch(arg_0 -> ReflectUtil.lambda$getField$0((String)var1_1, arg_0), fieldArray);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Field> getFieldMap(Class<?> beanClass) {
        void var1_1;
        Field[] fieldArray;
        Field[] fields = ReflectUtil.getFields(beanClass);
        HashMap<String, Field> map = MapUtil.newHashMap(fields.length, true);
        for (Field field : fieldArray) {
            map.put(field.getName(), field);
        }
        return var1_1;
    }

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        Class<?> clazz;
        Assert.notNull(beanClass);
        Class<?> clazz2 = clazz;
        return FIELDS_CACHE.computeIfAbsent(clazz2, () -> ReflectUtil.getFieldsDirectly(clazz2, true));
    }

    /*
     * WARNING - void declaration
     */
    public static Field[] getFields(Class<?> beanClass, Filter<Field> fieldFilter) throws SecurityException {
        void var1_1;
        return ArrayUtil.filter(ReflectUtil.getFields(beanClass), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Field[] getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFields) throws SecurityException {
        void var2_2;
        Class<?> searchType;
        Assert.notNull(beanClass);
        Field[] allFields = null;
        while (searchType != null) {
            void var3_3;
            Field[] declaredFields = searchType.getDeclaredFields();
            allFields = allFields == null ? declaredFields : ArrayUtil.append(allFields, var3_3);
            searchType = withSuperClassFields ? searchType.getSuperclass() : null;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Object getFieldValue(Object obj, String fieldName) throws UtilException {
        void var1_1;
        Object object;
        if (obj == null || StrUtil.isBlank(fieldName)) {
            return null;
        }
        Object object2 = obj;
        return ReflectUtil.getFieldValue(object2, ReflectUtil.getField(object2 instanceof Class ? (Class<?>)obj : object.getClass(), (String)var1_1));
    }

    public static Object getStaticFieldValue(Field field) throws UtilException {
        Field field2;
        return ReflectUtil.getFieldValue(null, field2);
    }

    /*
     * WARNING - void declaration
     */
    public static Object getFieldValue(Object obj, Field field) throws UtilException {
        Object object;
        if (field == null) {
            return null;
        }
        if (obj instanceof Class) {
            obj = null;
        }
        ReflectUtil.setAccessible(field);
        try {
            Object result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            void var1_2;
            throw new UtilException(e, "IllegalAccess for {}.{}", field.getDeclaringClass(), var1_2.getName());
        }
        return object;
    }

    public static Object[] getFieldsValue(Object obj) {
        return ReflectUtil.getFieldsValue(obj, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Object[] getFieldsValue(Object obj, Filter<Field> filter) {
        Field[] fields;
        if (obj != null && (fields = ReflectUtil.getFields(obj instanceof Class ? (Class<?>)obj : obj.getClass(), filter)) != null) {
            Object object;
            void var1_1;
            return ArrayUtil.map(var1_1, Object.class, field -> {
                void var1_1;
                return ReflectUtil.getFieldValue(object, (Field)var1_1);
            });
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void setFieldValue(Object obj, String fieldName, Object value) throws UtilException {
        void var2_2;
        void var3_3;
        Object object;
        void var1_1;
        Assert.notNull(obj);
        Assert.notBlank(fieldName);
        Field field = ReflectUtil.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName);
        Assert.notNull(field, "Field [{}] is not exist in [{}]", var1_1, obj.getClass().getName());
        ReflectUtil.setFieldValue(object, (Field)var3_3, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void setFieldValue(Object obj, Field field, Object value) throws UtilException {
        Object targetValue;
        Assert.notNull(field, "Field in [{}] not exist !", obj);
        Class<?> fieldType = field.getType();
        if (value != null) {
            if (!fieldType.isAssignableFrom(value.getClass()) && (targetValue = Convert.convert(fieldType, value)) != null) {
                value = targetValue;
            }
        } else {
            value = ClassUtil.getDefaultValue(targetValue);
        }
        ReflectUtil.setAccessible(field);
        try {
            void var2_2;
            field.set(obj instanceof Class ? null : obj, var2_2);
            return;
        }
        catch (IllegalAccessException e) {
            void var1_1;
            Object object;
            void var3_4;
            throw new UtilException((Throwable)var3_4, "IllegalAccess for {}.{}", object, var1_1.getName());
        }
    }

    public static boolean isOuterClassField(Field field) {
        Field field2;
        return "this$0".equals(field2.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        void var1_1;
        HashSet<String> methodSet = new HashSet<String>();
        Method[] methodArray = ReflectUtil.getPublicMethods(clazz);
        if (ArrayUtil.isNotEmpty(methodArray)) {
            Method[] methodArray2;
            for (Method method : methodArray2) {
                methodSet.add(method.getName());
            }
        }
        return var1_1;
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        Class<?> clazz2;
        if (clazz == null) {
            return null;
        }
        return clazz2.getMethods();
    }

    /*
     * WARNING - void declaration
     */
    public static List<Method> getPublicMethods(Class<?> clazz, Filter<Method> filter) {
        void var2_2;
        ArrayList<Method> methodList;
        if (clazz == null) {
            return null;
        }
        Method[] methods = ReflectUtil.getPublicMethods(clazz);
        if (filter != null) {
            methodList = new ArrayList();
            for (Method method : methods) {
                if (!filter.accept(method)) continue;
                methodList.add(method);
            }
        } else {
            Method[] methodArray;
            methodList = CollUtil.newArrayList(methodArray);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Method> getPublicMethods(Class<?> clazz, Method ... excludeMethods) {
        void var1_1;
        Class<?> clazz2;
        HashSet<Method> excludeMethodSet = CollUtil.newHashSet(excludeMethods);
        return ReflectUtil.getPublicMethods(clazz2, arg_0 -> ReflectUtil.lambda$getPublicMethods$2((HashSet)var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static List<Method> getPublicMethods(Class<?> clazz, String ... excludeMethodNames) {
        void var1_1;
        Class<?> clazz2;
        HashSet<String> excludeMethodNameSet = CollUtil.newHashSet(excludeMethodNames);
        return ReflectUtil.getPublicMethods(clazz2, arg_0 -> ReflectUtil.lambda$getPublicMethods$3((HashSet)var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        try {
            void var2_2;
            void var1_1;
            return clazz.getMethod((String)var1_1, (Class<?>)var2_2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Method getMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        void var2_2;
        void var1_1;
        Object object;
        if (obj == null || StrUtil.isBlank(methodName)) {
            return null;
        }
        return ReflectUtil.getMethod(object.getClass(), (String)var1_1, ClassUtil.getClasses((Object[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static Method getMethodIgnoreCase(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        void var2_2;
        void var1_1;
        return ReflectUtil.getMethod(clazz, true, (String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        void var2_2;
        void var1_1;
        return ReflectUtil.getMethod(clazz, false, (String)var1_1, var2_2);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (clazz == null || StrUtil.isBlank(methodName)) {
            return null;
        }
        Method res = null;
        Method[] methods = ReflectUtil.getMethods(clazz);
        if (ArrayUtil.isNotEmpty(methods)) {
            Method[] methodArray;
            for (Method method : methodArray) {
                if (!StrUtil.equals(methodName, method.getName(), ignoreCase) || !ClassUtil.isAllAssignableFrom(method.getParameterTypes(), paramTypes) || res != null && !res.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                res = method;
            }
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    public static Method getMethodByName(Class<?> clazz, String methodName) throws SecurityException {
        void var1_1;
        return ReflectUtil.getMethodByName(clazz, false, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Method getMethodByNameIgnoreCase(Class<?> clazz, String methodName) throws SecurityException {
        void var1_1;
        return ReflectUtil.getMethodByName(clazz, true, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Method getMethodByName(Class<?> clazz, boolean ignoreCase, String methodName) throws SecurityException {
        void var3_3;
        if (clazz == null || StrUtil.isBlank(methodName)) {
            return null;
        }
        Method res = null;
        Method[] methods = ReflectUtil.getMethods(clazz);
        if (ArrayUtil.isNotEmpty(methods)) {
            Method[] methodArray;
            for (Method method : methodArray) {
                if (!StrUtil.equals(methodName, method.getName(), ignoreCase) || res != null && !res.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                res = method;
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static Set<String> getMethodNames(Class<?> clazz) throws SecurityException {
        void var1_1;
        Method[] methodArray;
        HashSet<String> methodSet = new HashSet<String>();
        Method[] methodArray2 = ReflectUtil.getMethods(methodArray);
        methodArray = methodArray2;
        methodArray = methodArray2;
        int n = methodArray2.length;
        for (int i = 0; i < n; ++i) {
            Method method = methodArray[i];
            methodSet.add(method.getName());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Method[] getMethods(Class<?> clazz, Filter<Method> filter) throws SecurityException {
        void var1_1;
        Class<?> clazz2;
        if (clazz == null) {
            return null;
        }
        return ArrayUtil.filter(ReflectUtil.getMethods(clazz2), var1_1);
    }

    public static Method[] getMethods(Class<?> beanClass) throws SecurityException {
        Class<?> clazz;
        Assert.notNull(beanClass);
        Class<?> clazz2 = clazz;
        return METHODS_CACHE.computeIfAbsent(clazz2, () -> ReflectUtil.getMethodsDirectly(clazz2, true, true));
    }

    /*
     * WARNING - void declaration
     */
    public static Method[] getMethodsDirectly(Class<?> beanClass, boolean withSupers, boolean withMethodFromObject) throws SecurityException {
        void var3_3;
        Class<?> searchType;
        Assert.notNull(beanClass);
        if (beanClass.isInterface()) {
            if (withSupers) {
                return beanClass.getMethods();
            }
            return beanClass.getDeclaredMethods();
        }
        UniqueKeySet<String, Method> result = new UniqueKeySet<String, Method>(true, ReflectUtil::getUniqueKey);
        while (searchType != null && (withMethodFromObject || Object.class != searchType)) {
            result.addAllIfAbsent(Arrays.asList(searchType.getDeclaredMethods()));
            result.addAllIfAbsent(ReflectUtil.getDefaultMethodsFromInterface(searchType));
            searchType = withSupers && false == searchType.isInterface() ? searchType.getSuperclass() : null;
        }
        return var3_3.toArray(new Method[0]);
    }

    public static boolean isEqualsMethod(Method method) {
        Method method2;
        if (method == null || 1 != method.getParameterCount() || !"equals".equals(method.getName())) {
            return false;
        }
        return method2.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        Method method2;
        return method != null && "hashCode".equals(method.getName()) && ReflectUtil.isEmptyParam(method2);
    }

    public static boolean isToStringMethod(Method method) {
        Method method2;
        return method != null && "toString".equals(method.getName()) && ReflectUtil.isEmptyParam(method2);
    }

    public static boolean isEmptyParam(Method method) {
        return method.getParameterCount() == 0;
    }

    public static boolean isGetterOrSetterIgnoreCase(Method method) {
        return ReflectUtil.isGetterOrSetter(method, true);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isGetterOrSetter(Method method, boolean ignoreCase) {
        void var2_2;
        void var1_1;
        if (method == null) {
            return false;
        }
        int parameterCount = method.getParameterCount();
        if (parameterCount > 1) {
            return false;
        }
        Object name = method.getName();
        if ("getClass".equals(name)) {
            return false;
        }
        if (var1_1 != false) {
            name = ((String)name).toLowerCase();
        }
        switch (var2_2) {
            case 0: {
                return ((String)name).startsWith("get") || ((String)name).startsWith("is");
            }
            case 1: {
                Object object;
                return ((String)object).startsWith("set");
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T newInstance(String clazz) throws UtilException {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            String string;
            void var1_1;
            throw new UtilException((Throwable)var1_1, "Instance class [{}] error!", string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T newInstance(Class<T> clazz, Object ... params) throws UtilException {
        if (ArrayUtil.isEmpty(params)) {
            Constructor<T> constructor = ReflectUtil.getConstructor(clazz, new Class[0]);
            if (constructor == null) {
                throw new UtilException("No constructor for [{}]", clazz);
            }
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new UtilException(e, "Instance class [{}] error!", clazz);
            }
        }
        Class<?>[] paramTypes = ClassUtil.getClasses(params);
        Constructor<T> constructor = ReflectUtil.getConstructor(clazz, paramTypes);
        if (constructor == null) {
            void var2_4;
            throw new UtilException("No Constructor matched for parameter types: [{}]", var2_4);
        }
        try {
            void var3_6;
            return var3_6.newInstance(params);
        }
        catch (Exception e) {
            Class<T> clazz2;
            void var1_2;
            throw new UtilException((Throwable)var1_2, "Instance class [{}] error!", clazz2);
        }
    }

    public static <T> T newInstanceIfPossible(Class<T> type) {
        Assert.notNull(type);
        if (type.isPrimitive()) {
            return (T)ClassUtil.getPrimitiveDefaultValue(type);
        }
        if (type.isAssignableFrom(AbstractMap.class)) {
            type = HashMap.class;
        } else if (type.isAssignableFrom(List.class)) {
            type = ArrayList.class;
        } else if (type.isAssignableFrom(Set.class)) {
            type = HashSet.class;
        }
        try {
            return (T)ReflectUtil.newInstance(type, new Object[0]);
        }
        catch (Exception exception) {
            if (type.isEnum()) {
                return (T)type.getEnumConstants()[0];
            }
            if (type.isArray()) {
                return (T)Array.newInstance(type.getComponentType(), 0);
            }
            type = ReflectUtil.getConstructors(type);
            Constructor<Object>[] constructorArray = type;
            int n = ((Constructor<Object>[])type).length;
            for (int i = 0; i < n; ++i) {
                Constructor<Object> constructor = constructorArray[i];
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (0 == parameterTypes.length) continue;
                ReflectUtil.setAccessible(constructor);
                try {
                    Class<?>[] classArray;
                    return (T)constructor.newInstance(ClassUtil.getDefaultValues(classArray));
                }
                catch (Exception exception2) {}
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invokeStatic(Method method, Object ... args) throws UtilException {
        void var1_1;
        Method method2;
        return ReflectUtil.invoke(null, method2, (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invokeWithCheck(Object obj, Method method, Object ... args) throws UtilException {
        void var2_2;
        void var1_1;
        Object object;
        Class<?>[] types = method.getParameterTypes();
        if (args != null) {
            Assert.isTrue(args.length == types.length, "Params length [{}] is not fit for param length [{}] of method !", args.length, types.length);
            for (int i = 0; i < args.length; ++i) {
                Class<?> type = types[i];
                if (!type.isPrimitive() || null != args[i]) continue;
                args[i] = ClassUtil.getDefaultValue(type);
            }
        }
        return ReflectUtil.invoke(object, (Method)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invoke(Object obj, Method method, Object ... args) throws InvocationTargetRuntimeException, UtilException {
        try {
            void var2_4;
            void var1_3;
            return ReflectUtil.invokeRaw(obj, (Method)var1_3, (Object[])var2_4);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            void var0_2;
            throw new UtilException((Throwable)var0_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invokeRaw(Object obj, Method method, Object ... args) throws InvocationTargetException, IllegalAccessException {
        Object object;
        void var1_1;
        ReflectUtil.setAccessible(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] actualArgs = new Object[parameterTypes.length];
        if (args != null) {
            for (int i = 0; i < actualArgs.length; ++i) {
                if (i >= args.length || null == args[i]) {
                    actualArgs[i] = ClassUtil.getDefaultValue(parameterTypes[i]);
                    continue;
                }
                if (args[i] instanceof NullWrapperBean) {
                    actualArgs[i] = null;
                    continue;
                }
                if (!parameterTypes[i].isAssignableFrom(args[i].getClass())) {
                    Object targetValue = Convert.convertWithCheck(parameterTypes[i], args[i], null, true);
                    if (targetValue != null) {
                        actualArgs[i] = targetValue;
                        continue;
                    }
                    actualArgs[i] = args[i];
                    continue;
                }
                actualArgs[i] = args[i];
            }
        }
        if (method.isDefault()) {
            void var2_2;
            return MethodHandleUtil.invokeSpecial(obj, method, (Object[])var2_2);
        }
        void v0 = var1_1;
        return (T)v0.invoke(ClassUtil.isStatic((Method)v0) ? null : object, actualArgs);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invoke(Object obj, String methodName, Object ... args) throws UtilException {
        void var2_2;
        void var3_3;
        Object object;
        Assert.notNull(obj, "Object to get method must be not null!", new Object[0]);
        Assert.notBlank(methodName, "Method name must be not blank!", new Object[0]);
        Method method = ReflectUtil.getMethodOfObj(obj, methodName, args);
        if (method == null) {
            void var1_1;
            throw new UtilException("No such method: [{}] from [{}]", var1_1, obj.getClass());
        }
        return ReflectUtil.invoke(object, (Method)var3_3, (Object[])var2_2);
    }

    public static <T extends AccessibleObject> T setAccessible(T accessibleObject) {
        T t;
        if (accessibleObject != null && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return t;
    }

    public static void removeFinalModify(Field field) {
        ModifierUtil.removeFinalModify(field);
    }

    /*
     * WARNING - void declaration
     */
    private static String getUniqueKey(Method method) {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append(method.getReturnType().getName()).append('#');
        sb.append(method.getName());
        Class<?>[] parameters = method.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (i == 0) {
                sb.append(':');
            } else {
                sb.append(',');
            }
            sb.append(parameters[i].getName());
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static List<Method> getDefaultMethodsFromInterface(Class<?> clazz) {
        void var1_1;
        Class<?>[] classArray;
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> clazz2 : classArray.getInterfaces()) {
            for (Method m : clazz2.getMethods()) {
                if (ModifierUtil.isAbstract(m)) continue;
                result.add(m);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$getPublicMethods$3(HashSet excludeMethodNameSet, Method method) {
        void var1_1;
        HashSet hashSet;
        return false == hashSet.contains(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$getPublicMethods$2(HashSet excludeMethodSet, Method method) {
        void var1_1;
        HashSet hashSet;
        return false == hashSet.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$getField$0(String name, Field field) {
        void var1_1;
        return name.equals(ReflectUtil.getFieldName((Field)var1_1));
    }
}

