/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.WeightRandom;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public class RandomUtil {
    public static final String BASE_NUMBER = "0123456789";
    public static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    public static final String BASE_CHAR_NUMBER_LOWER = "abcdefghijklmnopqrstuvwxyz0123456789";
    public static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz".toUpperCase() + "abcdefghijklmnopqrstuvwxyz0123456789";

    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static SecureRandom createSecureRandom(byte[] seed) {
        byte[] byArray;
        if (seed == null) {
            return new SecureRandom();
        }
        return new SecureRandom(byArray);
    }

    public static SecureRandom getSecureRandom() {
        return RandomUtil.getSecureRandom(null);
    }

    public static SecureRandom getSecureRandom(byte[] seed) {
        return RandomUtil.createSecureRandom(seed);
    }

    /*
     * WARNING - void declaration
     */
    public static SecureRandom getSHA1PRNGRandom(byte[] seed) {
        void var1_2;
        byte[] byArray;
        SecureRandom random;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            void var0_1;
            throw new UtilException((Throwable)var0_1);
        }
        if (byArray != null) {
            random.setSeed(byArray);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static SecureRandom getSecureRandomStrong() {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            void var0;
            throw new UtilException((Throwable)var0);
        }
    }

    public static Random getRandom(boolean isSecure) {
        if (isSecure) {
            return RandomUtil.getSecureRandom();
        }
        return RandomUtil.getRandom();
    }

    public static boolean randomBoolean() {
        return 0 == RandomUtil.randomInt(2);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] randomBytes(int length) {
        void var0_1;
        byte[] bytes = new byte[length];
        RandomUtil.getRandom().nextBytes(bytes);
        return var0_1;
    }

    public static int randomInt() {
        return RandomUtil.getRandom().nextInt();
    }

    public static int randomInt(int limitExclude) {
        int n;
        return RandomUtil.getRandom().nextInt(n);
    }

    /*
     * WARNING - void declaration
     */
    public static int randomInt(int minInclude, int maxExclude) {
        void var1_1;
        return RandomUtil.randomInt(minInclude, (int)var1_1, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public static int randomInt(int min, int max, boolean includeMin, boolean includeMax) {
        void var1_1;
        int n;
        void var3_3;
        if (!includeMin) {
            ++min;
        }
        if (var3_3 != false) {
            ++max;
        }
        return RandomUtil.getRandom().nextInt(n, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] randomInts(int length) {
        void var1_1;
        int[] range = ArrayUtil.range(length);
        for (int i = 0; i < length; ++i) {
            void var3_3;
            int random = RandomUtil.randomInt(i, length);
            ArrayUtil.swap(range, i, (int)var3_3);
        }
        return var1_1;
    }

    public static long randomLong() {
        return RandomUtil.getRandom().nextLong();
    }

    public static long randomLong(long limitExclude) {
        long l;
        return RandomUtil.getRandom().nextLong(l);
    }

    /*
     * WARNING - void declaration
     */
    public static long randomLong(long minInclude, long maxExclude) {
        void var2_1;
        return RandomUtil.randomLong(minInclude, (long)var2_1, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public static long randomLong(long min, long max, boolean includeMin, boolean includeMax) {
        void var2_1;
        long l;
        if (!includeMin) {
            ++min;
        }
        if (includeMax) {
            ++max;
        }
        return RandomUtil.getRandom().nextLong(l, (long)var2_1);
    }

    public static float randomFloat() {
        return RandomUtil.getRandom().nextFloat();
    }

    public static float randomFloat(float limitExclude) {
        float f;
        return RandomUtil.randomFloat(0.0f, f);
    }

    /*
     * WARNING - void declaration
     */
    public static float randomFloat(float minInclude, float maxExclude) {
        float f;
        void var1_1;
        if (minInclude == maxExclude) {
            return minInclude;
        }
        return minInclude + (var1_1 - f) * RandomUtil.getRandom().nextFloat();
    }

    /*
     * WARNING - void declaration
     */
    public static double randomDouble(double minInclude, double maxExclude) {
        void var2_1;
        double d;
        return RandomUtil.getRandom().nextDouble(d, (double)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    public static double randomDouble(double minInclude, double maxExclude, int scale, RoundingMode roundingMode) {
        void var2_1;
        return NumberUtil.round(RandomUtil.randomDouble(minInclude, (double)var2_1), scale, roundingMode).doubleValue();
    }

    public static double randomDouble() {
        return RandomUtil.getRandom().nextDouble();
    }

    /*
     * WARNING - void declaration
     */
    public static double randomDouble(int scale, RoundingMode roundingMode) {
        void var1_1;
        int n;
        return NumberUtil.round(RandomUtil.randomDouble(), n, (RoundingMode)var1_1).doubleValue();
    }

    public static double randomDouble(double limit) {
        double d;
        return RandomUtil.getRandom().nextDouble(d);
    }

    /*
     * WARNING - void declaration
     */
    public static double randomDouble(double limit, int scale, RoundingMode roundingMode) {
        void var3_2;
        void var2_1;
        return NumberUtil.round(RandomUtil.randomDouble(limit), (int)var2_1, (RoundingMode)var3_2).doubleValue();
    }

    public static BigDecimal randomBigDecimal() {
        return NumberUtil.toBigDecimal(RandomUtil.getRandom().nextDouble());
    }

    public static BigDecimal randomBigDecimal(BigDecimal limit) {
        BigDecimal bigDecimal;
        return NumberUtil.toBigDecimal(RandomUtil.getRandom().nextDouble(bigDecimal.doubleValue()));
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal randomBigDecimal(BigDecimal minInclude, BigDecimal maxExclude) {
        void var1_1;
        BigDecimal bigDecimal;
        return NumberUtil.toBigDecimal(RandomUtil.getRandom().nextDouble(bigDecimal.doubleValue(), var1_1.doubleValue()));
    }

    public static <T> T randomEle(List<T> list) {
        List<T> list2 = list;
        return RandomUtil.randomEle(list2, list2.size());
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T randomEle(List<T> list, int limit) {
        void var1_1;
        List<T> list2;
        if (list.size() < limit) {
            limit = list.size();
        }
        return list2.get(RandomUtil.randomInt((int)var1_1));
    }

    public static <T> T randomEle(T[] array) {
        return RandomUtil.randomEle(array, array.length);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T randomEle(T[] array, int limit) {
        void var1_1;
        T[] TArray;
        if (array.length < limit) {
            limit = array.length;
        }
        return TArray[RandomUtil.randomInt((int)var1_1)];
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> randomEles(List<T> list, int count) {
        void var2_2;
        ArrayList<T> result = new ArrayList<T>(count);
        int limit = list.size();
        while (result.size() < count) {
            result.add(RandomUtil.randomEle(list, limit));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> randomEleList(List<T> source, int count) {
        void var2_3;
        void var1_2;
        if (count >= source.size()) {
            return ListUtil.toList(source);
        }
        int[] randomList = ArrayUtil.sub(RandomUtil.randomInts(source.size()), 0, count);
        ArrayList<T> result = new ArrayList<T>();
        for (void e : var1_2) {
            result.add(source.get((int)e));
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Set<T> randomEleSet(Collection<T> collection, int count) {
        void var2_2;
        Collection<T> source = CollUtil.distinct(collection);
        if (count > ((ArrayList)source).size()) {
            throw new IllegalArgumentException("Count is larger than collection distinct size !");
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>(count);
        int limit = ((ArrayList)source).size();
        while (result.size() < count) {
            result.add(RandomUtil.randomEle(source, limit));
        }
        return var2_2;
    }

    public static String randomString(int length) {
        int n;
        return RandomUtil.randomString(BASE_CHAR_NUMBER, n);
    }

    public static String randomStringUpper(int length) {
        int n;
        return RandomUtil.randomString(BASE_CHAR_NUMBER, n).toUpperCase();
    }

    /*
     * WARNING - void declaration
     */
    public static String randomStringWithoutStr(int length, String elemData) {
        int n;
        void var1_1;
        String string = BASE_CHAR_NUMBER;
        string = StrUtil.removeAll((CharSequence)string, var1_1.toLowerCase().toCharArray());
        return RandomUtil.randomString(string, n);
    }

    public static String randomNumbers(int length) {
        int n;
        return RandomUtil.randomString(BASE_NUMBER, n);
    }

    /*
     * WARNING - void declaration
     */
    public static String randomString(String baseString, int length) {
        void var2_2;
        if (StrUtil.isEmpty(baseString)) {
            return "";
        }
        if (length <= 0) {
            length = 1;
        }
        StringBuilder sb = new StringBuilder(length);
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = RandomUtil.randomInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return var2_2.toString();
    }

    public static char randomChinese() {
        return (char)RandomUtil.randomInt(19968, 40959);
    }

    public static char randomNumber() {
        return RandomUtil.randomChar(BASE_NUMBER);
    }

    public static char randomChar() {
        return RandomUtil.randomChar(BASE_CHAR_NUMBER);
    }

    public static char randomChar(String baseString) {
        String string = baseString;
        return string.charAt(RandomUtil.randomInt(string.length()));
    }

    public static <T> WeightRandom<T> weightRandom(WeightRandom.WeightObj<T>[] weightObjs) {
        WeightRandom.WeightObj<T>[] weightObjArray;
        return new WeightRandom<T>(weightObjArray);
    }

    public static <T> WeightRandom<T> weightRandom(Iterable<WeightRandom.WeightObj<T>> weightObjs) {
        Iterable<WeightRandom.WeightObj<T>> iterable;
        return new WeightRandom<T>(iterable);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime randomDay(int min, int max) {
        void var1_1;
        int n;
        return RandomUtil.randomDate(DateUtil.date(), DateField.DAY_OF_YEAR, n, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static DateTime randomDate(Date baseDate, DateField dateField, int min, int max) {
        void var3_3;
        void var2_2;
        void var1_1;
        Date date;
        if (baseDate == null) {
            baseDate = DateUtil.date();
        }
        return DateUtil.offset(date, (DateField)var1_1, RandomUtil.randomInt((int)var2_2, (int)var3_3));
    }
}

