/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Random;

public class PrimitiveArrayUtil {
    public static final int INDEX_NOT_FOUND = -1;

    public static boolean isEmpty(long[] array) {
        long[] lArray;
        return array == null || lArray.length == 0;
    }

    public static boolean isEmpty(int[] array) {
        int[] nArray;
        return array == null || nArray.length == 0;
    }

    public static boolean isEmpty(short[] array) {
        short[] sArray;
        return array == null || sArray.length == 0;
    }

    public static boolean isEmpty(char[] array) {
        char[] cArray;
        return array == null || cArray.length == 0;
    }

    public static boolean isEmpty(byte[] array) {
        byte[] byArray;
        return array == null || byArray.length == 0;
    }

    public static boolean isEmpty(double[] array) {
        double[] dArray;
        return array == null || dArray.length == 0;
    }

    public static boolean isEmpty(float[] array) {
        float[] fArray;
        return array == null || fArray.length == 0;
    }

    public static boolean isEmpty(boolean[] array) {
        boolean[] blArray;
        return array == null || blArray.length == 0;
    }

    public static boolean isNotEmpty(long[] array) {
        long[] lArray;
        return false == PrimitiveArrayUtil.isEmpty(lArray);
    }

    public static boolean isNotEmpty(int[] array) {
        int[] nArray;
        return false == PrimitiveArrayUtil.isEmpty(nArray);
    }

    public static boolean isNotEmpty(short[] array) {
        short[] sArray;
        return false == PrimitiveArrayUtil.isEmpty(sArray);
    }

    public static boolean isNotEmpty(char[] array) {
        char[] cArray;
        return false == PrimitiveArrayUtil.isEmpty(cArray);
    }

    public static boolean isNotEmpty(byte[] array) {
        byte[] byArray;
        return false == PrimitiveArrayUtil.isEmpty(byArray);
    }

    public static boolean isNotEmpty(double[] array) {
        double[] dArray;
        return false == PrimitiveArrayUtil.isEmpty(dArray);
    }

    public static boolean isNotEmpty(float[] array) {
        float[] fArray;
        return false == PrimitiveArrayUtil.isEmpty(fArray);
    }

    public static boolean isNotEmpty(boolean[] array) {
        boolean[] blArray;
        return false == PrimitiveArrayUtil.isEmpty(blArray);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] resize(byte[] bytes, int newSize) {
        void var2_2;
        if (newSize < 0) {
            return bytes;
        }
        byte[] newArray = new byte[newSize];
        if (newSize > 0 && PrimitiveArrayUtil.isNotEmpty(bytes)) {
            void var1_1;
            byte[] byArray;
            System.arraycopy(bytes, 0, newArray, 0, Math.min(byArray.length, (int)var1_1));
        }
        return var2_2;
    }

    public static byte[] addAll(byte[] ... arrays) {
        int n;
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        byte[][] byArray = arrays;
        int n2 = arrays.length;
        for (n = 0; n < n2; ++n) {
            byte[] array = byArray[n];
            if (!PrimitiveArrayUtil.isNotEmpty(array)) continue;
            length += array.length;
        }
        byte[] result = new byte[length];
        length = 0;
        byte[][] byArray2 = arrays;
        n = arrays.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            byte[] byArray3 = byArray2[i];
            Object array = byArray3;
            if (!PrimitiveArrayUtil.isNotEmpty(byArray3)) continue;
            System.arraycopy(array, 0, result, length, ((byte[][])array).length);
            length += ((byte[][])object).length;
        }
        return byArray;
    }

    public static int[] addAll(int[] ... arrays) {
        int n;
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        int[][] nArray = arrays;
        int n2 = arrays.length;
        for (n = 0; n < n2; ++n) {
            int[] array = nArray[n];
            if (!PrimitiveArrayUtil.isNotEmpty(array)) continue;
            length += array.length;
        }
        int[] result = new int[length];
        length = 0;
        int[][] nArray2 = arrays;
        n = arrays.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            int[] nArray3 = nArray2[i];
            Object array = nArray3;
            if (!PrimitiveArrayUtil.isNotEmpty(nArray3)) continue;
            System.arraycopy(array, 0, result, length, ((int[][])array).length);
            length += ((int[][])object).length;
        }
        return nArray;
    }

    public static long[] addAll(long[] ... arrays) {
        int n;
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        long[][] lArray = arrays;
        int n2 = arrays.length;
        for (n = 0; n < n2; ++n) {
            long[] array = lArray[n];
            if (!PrimitiveArrayUtil.isNotEmpty(array)) continue;
            length += array.length;
        }
        long[] result = new long[length];
        length = 0;
        long[][] lArray2 = arrays;
        n = arrays.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            long[] lArray3 = lArray2[i];
            Object array = lArray3;
            if (!PrimitiveArrayUtil.isNotEmpty(lArray3)) continue;
            System.arraycopy(array, 0, result, length, ((long[][])array).length);
            length += ((long[][])object).length;
        }
        return lArray;
    }

    public static double[] addAll(double[] ... arrays) {
        int n;
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        double[][] dArray = arrays;
        int n2 = arrays.length;
        for (n = 0; n < n2; ++n) {
            double[] array = dArray[n];
            if (!PrimitiveArrayUtil.isNotEmpty(array)) continue;
            length += array.length;
        }
        double[] result = new double[length];
        length = 0;
        double[][] dArray2 = arrays;
        n = arrays.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            double[] dArray3 = dArray2[i];
            Object array = dArray3;
            if (!PrimitiveArrayUtil.isNotEmpty(dArray3)) continue;
            System.arraycopy(array, 0, result, length, ((double[][])array).length);
            length += ((double[][])object).length;
        }
        return dArray;
    }

    public static float[] addAll(float[] ... arrays) {
        int n;
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        float[][] fArray = arrays;
        int n2 = arrays.length;
        for (n = 0; n < n2; ++n) {
            float[] array = fArray[n];
            if (!PrimitiveArrayUtil.isNotEmpty(array)) continue;
            length += array.length;
        }
        float[] result = new float[length];
        length = 0;
        float[][] fArray2 = arrays;
        n = arrays.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            float[] fArray3 = fArray2[i];
            Object array = fArray3;
            if (!PrimitiveArrayUtil.isNotEmpty(fArray3)) continue;
            System.arraycopy(array, 0, result, length, ((float[][])array).length);
            length += ((float[][])object).length;
        }
        return fArray;
    }

    public static char[] addAll(char[] ... arrays) {
        int n;
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        char[][] cArray = arrays;
        int n2 = arrays.length;
        for (n = 0; n < n2; ++n) {
            char[] array = cArray[n];
            if (!PrimitiveArrayUtil.isNotEmpty(array)) continue;
            length += array.length;
        }
        char[] result = new char[length];
        length = 0;
        char[][] cArray2 = arrays;
        n = arrays.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            char[] cArray3 = cArray2[i];
            Object array = cArray3;
            if (!PrimitiveArrayUtil.isNotEmpty(cArray3)) continue;
            System.arraycopy(array, 0, result, length, ((char[][])array).length);
            length += ((char[][])object).length;
        }
        return cArray;
    }

    public static boolean[] addAll(boolean[] ... arrays) {
        int n;
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        boolean[][] blArray = arrays;
        int n2 = arrays.length;
        for (n = 0; n < n2; ++n) {
            boolean[] array = blArray[n];
            if (!PrimitiveArrayUtil.isNotEmpty(array)) continue;
            length += array.length;
        }
        boolean[] result = new boolean[length];
        length = 0;
        boolean[][] blArray2 = arrays;
        n = arrays.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            boolean[] blArray3 = blArray2[i];
            Object array = blArray3;
            if (!PrimitiveArrayUtil.isNotEmpty(blArray3)) continue;
            System.arraycopy(array, 0, result, length, ((boolean[][])array).length);
            length += ((boolean[][])object).length;
        }
        return blArray;
    }

    public static short[] addAll(short[] ... arrays) {
        int n;
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        short[][] sArray = arrays;
        int n2 = arrays.length;
        for (n = 0; n < n2; ++n) {
            short[] array = sArray[n];
            if (!PrimitiveArrayUtil.isNotEmpty(array)) continue;
            length += array.length;
        }
        short[] result = new short[length];
        length = 0;
        short[][] sArray2 = arrays;
        n = arrays.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            short[] sArray3 = sArray2[i];
            Object array = sArray3;
            if (!PrimitiveArrayUtil.isNotEmpty(sArray3)) continue;
            System.arraycopy(array, 0, result, length, ((short[][])array).length);
            length += ((short[][])object).length;
        }
        return sArray;
    }

    public static int[] range(int excludedEnd) {
        int n;
        return PrimitiveArrayUtil.range(0, n, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] range(int includedStart, int excludedEnd) {
        void var1_1;
        return PrimitiveArrayUtil.range(includedStart, (int)var1_1, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] range(int includedStart, int excludedEnd, int step) {
        void var3_4;
        if (includedStart > excludedEnd) {
            int tmp = includedStart;
            includedStart = excludedEnd;
            excludedEnd = tmp;
        }
        if (step <= 0) {
            step = 1;
        }
        int deviation = excludedEnd - includedStart;
        int length = deviation / step;
        if (deviation % step != 0) {
            ++length;
        }
        int[] range = new int[length];
        for (int i = 0; i < length; ++i) {
            range[i] = includedStart;
            includedStart += step;
        }
        return var3_4;
    }

    public static byte[][] split(byte[] array, int len) {
        int amount = array.length / len;
        int remainder = array.length % len;
        if (remainder != 0) {
            ++amount;
        }
        byte[][] arrays = new byte[amount][];
        for (int i = 0; i < amount; ++i) {
            byte[] arr;
            if (i == amount - 1 && remainder != 0) {
                arr = new byte[remainder];
                System.arraycopy(array, i * len, arr, 0, remainder);
            } else {
                arr = new byte[len];
                System.arraycopy(array, i * len, arr, 0, len);
            }
            arrays[i] = arr;
        }
        return arrays;
    }

    public static int indexOf(long[] array, long value) {
        if (PrimitiveArrayUtil.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(long[] array, long value) {
        if (PrimitiveArrayUtil.isNotEmpty(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(long[] array, long value) {
        void var1_1;
        return PrimitiveArrayUtil.indexOf(array, (long)var1_1) >= 0;
    }

    public static int indexOf(int[] array, int value) {
        if (PrimitiveArrayUtil.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int value) {
        if (PrimitiveArrayUtil.isNotEmpty(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(int[] array, int value) {
        void var1_1;
        return PrimitiveArrayUtil.indexOf(array, (int)var1_1) >= 0;
    }

    public static int indexOf(short[] array, short value) {
        if (PrimitiveArrayUtil.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(short[] array, short value) {
        if (PrimitiveArrayUtil.isNotEmpty(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(short[] array, short value) {
        void var1_1;
        return PrimitiveArrayUtil.indexOf(array, (short)var1_1) >= 0;
    }

    public static int indexOf(char[] array, char value) {
        if (PrimitiveArrayUtil.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char value) {
        if (PrimitiveArrayUtil.isNotEmpty(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(char[] array, char value) {
        void var1_1;
        return PrimitiveArrayUtil.indexOf(array, (char)var1_1) >= 0;
    }

    public static int indexOf(byte[] array, byte value) {
        if (PrimitiveArrayUtil.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array, byte value) {
        if (PrimitiveArrayUtil.isNotEmpty(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(byte[] array, byte value) {
        void var1_1;
        return PrimitiveArrayUtil.indexOf(array, (byte)var1_1) >= 0;
    }

    public static int indexOf(double[] array, double value) {
        if (PrimitiveArrayUtil.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (!NumberUtil.equals(value, array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double value) {
        if (PrimitiveArrayUtil.isNotEmpty(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (!NumberUtil.equals(value, array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(double[] array, double value) {
        void var1_1;
        return PrimitiveArrayUtil.indexOf(array, (double)var1_1) >= 0;
    }

    public static int indexOf(float[] array, float value) {
        if (PrimitiveArrayUtil.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (!NumberUtil.equals(value, array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(float[] array, float value) {
        if (PrimitiveArrayUtil.isNotEmpty(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (!NumberUtil.equals(value, array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(float[] array, float value) {
        void var1_1;
        return PrimitiveArrayUtil.indexOf(array, (float)var1_1) >= 0;
    }

    public static int indexOf(boolean[] array, boolean value) {
        if (PrimitiveArrayUtil.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array, boolean value) {
        if (PrimitiveArrayUtil.isNotEmpty(array)) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(boolean[] array, boolean value) {
        void var1_1;
        return PrimitiveArrayUtil.indexOf(array, (boolean)var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public static Integer[] wrap(int ... values) {
        void var2_2;
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return new Integer[0];
        }
        Integer[] array = new Integer[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] unWrap(Integer ... values) {
        void var2_2;
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return new int[0];
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = ObjectUtil.defaultIfNull(values[i], 0);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Long[] wrap(long ... values) {
        void var2_2;
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return new Long[0];
        }
        Long[] array = new Long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static long[] unWrap(Long ... values) {
        void var2_2;
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return new long[0];
        }
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = ObjectUtil.defaultIfNull(values[i], 0L);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Character[] wrap(char ... values) {
        void var2_2;
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return new Character[0];
        }
        Character[] array = new Character[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Character.valueOf(values[i]);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] unWrap(Character ... values) {
        void var2_2;
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return new char[0];
        }
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = ObjectUtil.defaultIfNull(values[i], Character.valueOf('\u0000')).charValue();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Byte[] wrap(byte ... values) {
        void var2_2;
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return new Byte[0];
        }
        Byte[] array = new Byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] unWrap(Byte ... values) {
        void var2_2;
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return new byte[0];
        }
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = ObjectUtil.defaultIfNull(values[i], (byte)0);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Short[] wrap(short ... values) {
        void var2_2;
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return new Short[0];
        }
        Short[] array = new Short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] unWrap(Short ... values) {
        void var2_2;
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return new short[0];
        }
        short[] array = new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = ObjectUtil.defaultIfNull(values[i], (short)0);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Float[] wrap(float ... values) {
        void var2_2;
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return new Float[0];
        }
        Float[] array = new Float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Float.valueOf(values[i]);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] unWrap(Float ... values) {
        void var2_2;
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return new float[0];
        }
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = ObjectUtil.defaultIfNull(values[i], Float.valueOf(0.0f)).floatValue();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Double[] wrap(double ... values) {
        void var2_2;
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return new Double[0];
        }
        Double[] array = new Double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] unWrap(Double ... values) {
        void var2_2;
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return new double[0];
        }
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = ObjectUtil.defaultIfNull(values[i], 0.0);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static Boolean[] wrap(boolean ... values) {
        void var2_2;
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return new Boolean[0];
        }
        Boolean[] array = new Boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] unWrap(Boolean ... values) {
        void var2_2;
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return new boolean[0];
        }
        boolean[] array = new boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = ObjectUtil.defaultIfNull(values[i], Boolean.FALSE);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] sub(byte[] array, int start, int end) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        int length = Array.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new byte[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            void var3_3;
            if (start >= length) {
                return new byte[0];
            }
            end = var3_3;
        }
        return Arrays.copyOfRange(byArray, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] sub(int[] array, int start, int end) {
        void var2_2;
        void var1_1;
        int[] nArray;
        int length = Array.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new int[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            void var3_3;
            if (start >= length) {
                return new int[0];
            }
            end = var3_3;
        }
        return Arrays.copyOfRange(nArray, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static long[] sub(long[] array, int start, int end) {
        void var2_2;
        void var1_1;
        long[] lArray;
        int length = Array.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new long[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            void var3_3;
            if (start >= length) {
                return new long[0];
            }
            end = var3_3;
        }
        return Arrays.copyOfRange(lArray, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static short[] sub(short[] array, int start, int end) {
        void var2_2;
        void var1_1;
        short[] sArray;
        int length = Array.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new short[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            void var3_3;
            if (start >= length) {
                return new short[0];
            }
            end = var3_3;
        }
        return Arrays.copyOfRange(sArray, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] sub(char[] array, int start, int end) {
        void var2_2;
        void var1_1;
        char[] cArray;
        int length = Array.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new char[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            void var3_3;
            if (start >= length) {
                return new char[0];
            }
            end = var3_3;
        }
        return Arrays.copyOfRange(cArray, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static double[] sub(double[] array, int start, int end) {
        void var2_2;
        void var1_1;
        double[] dArray;
        int length = Array.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new double[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            void var3_3;
            if (start >= length) {
                return new double[0];
            }
            end = var3_3;
        }
        return Arrays.copyOfRange(dArray, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static float[] sub(float[] array, int start, int end) {
        void var2_2;
        void var1_1;
        float[] fArray;
        int length = Array.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new float[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            void var3_3;
            if (start >= length) {
                return new float[0];
            }
            end = var3_3;
        }
        return Arrays.copyOfRange(fArray, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] sub(boolean[] array, int start, int end) {
        void var2_2;
        void var1_1;
        boolean[] blArray;
        int length = Array.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new boolean[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            void var3_3;
            if (start >= length) {
                return new boolean[0];
            }
            end = var3_3;
        }
        return Arrays.copyOfRange(blArray, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static long[] remove(long[] array, int index) throws IllegalArgumentException {
        void var1_1;
        return (long[])PrimitiveArrayUtil.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] remove(int[] array, int index) throws IllegalArgumentException {
        void var1_1;
        return (int[])PrimitiveArrayUtil.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static short[] remove(short[] array, int index) throws IllegalArgumentException {
        void var1_1;
        return (short[])PrimitiveArrayUtil.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] remove(char[] array, int index) throws IllegalArgumentException {
        void var1_1;
        return (char[])PrimitiveArrayUtil.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] remove(byte[] array, int index) throws IllegalArgumentException {
        void var1_1;
        return (byte[])PrimitiveArrayUtil.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static double[] remove(double[] array, int index) throws IllegalArgumentException {
        void var1_1;
        return (double[])PrimitiveArrayUtil.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static float[] remove(float[] array, int index) throws IllegalArgumentException {
        void var1_1;
        return (float[])PrimitiveArrayUtil.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] remove(boolean[] array, int index) throws IllegalArgumentException {
        void var1_1;
        return (boolean[])PrimitiveArrayUtil.remove((Object)array, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Object remove(Object array, int index) throws IllegalArgumentException {
        void var3_3;
        if (array == null) {
            return null;
        }
        int length = Array.getLength(array);
        if (index < 0 || index >= length) {
            return array;
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length - 1);
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            void var1_1;
            void var2_2;
            Object object;
            System.arraycopy(object, index + 1, result, index, (int)(var2_2 - var1_1 - true));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static long[] removeEle(long[] array, long element) throws IllegalArgumentException {
        void var1_1;
        return PrimitiveArrayUtil.remove(array, PrimitiveArrayUtil.indexOf(array, (long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static int[] removeEle(int[] array, int element) throws IllegalArgumentException {
        void var1_1;
        return PrimitiveArrayUtil.remove(array, PrimitiveArrayUtil.indexOf(array, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static short[] removeEle(short[] array, short element) throws IllegalArgumentException {
        void var1_1;
        return PrimitiveArrayUtil.remove(array, PrimitiveArrayUtil.indexOf(array, (short)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static char[] removeEle(char[] array, char element) throws IllegalArgumentException {
        void var1_1;
        return PrimitiveArrayUtil.remove(array, PrimitiveArrayUtil.indexOf(array, (char)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] removeEle(byte[] array, byte element) throws IllegalArgumentException {
        void var1_1;
        return PrimitiveArrayUtil.remove(array, PrimitiveArrayUtil.indexOf(array, (byte)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static double[] removeEle(double[] array, double element) throws IllegalArgumentException {
        void var1_1;
        return PrimitiveArrayUtil.remove(array, PrimitiveArrayUtil.indexOf(array, (double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static float[] removeEle(float[] array, float element) throws IllegalArgumentException {
        void var1_1;
        return PrimitiveArrayUtil.remove(array, PrimitiveArrayUtil.indexOf(array, (float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] removeEle(boolean[] array, boolean element) throws IllegalArgumentException {
        void var1_1;
        return PrimitiveArrayUtil.remove(array, PrimitiveArrayUtil.indexOf(array, (boolean)var1_1));
    }

    public static long[] reverse(long[] array, int startIndexInclusive, int endIndexExclusive) {
        long[] lArray;
        if (PrimitiveArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            PrimitiveArrayUtil.swap(array, i, j);
        }
        return lArray;
    }

    public static long[] reverse(long[] array) {
        long[] lArray;
        return PrimitiveArrayUtil.reverse(array, 0, lArray.length);
    }

    public static int[] reverse(int[] array, int startIndexInclusive, int endIndexExclusive) {
        int[] nArray;
        if (PrimitiveArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            PrimitiveArrayUtil.swap(array, i, j);
        }
        return nArray;
    }

    public static int[] reverse(int[] array) {
        int[] nArray;
        return PrimitiveArrayUtil.reverse(array, 0, nArray.length);
    }

    public static short[] reverse(short[] array, int startIndexInclusive, int endIndexExclusive) {
        short[] sArray;
        if (PrimitiveArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            PrimitiveArrayUtil.swap(array, i, j);
        }
        return sArray;
    }

    public static short[] reverse(short[] array) {
        short[] sArray;
        return PrimitiveArrayUtil.reverse(array, 0, sArray.length);
    }

    public static char[] reverse(char[] array, int startIndexInclusive, int endIndexExclusive) {
        char[] cArray;
        if (PrimitiveArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            PrimitiveArrayUtil.swap(array, i, j);
        }
        return cArray;
    }

    public static char[] reverse(char[] array) {
        char[] cArray;
        return PrimitiveArrayUtil.reverse(array, 0, cArray.length);
    }

    public static byte[] reverse(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        byte[] byArray;
        if (PrimitiveArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            PrimitiveArrayUtil.swap(array, i, j);
        }
        return byArray;
    }

    public static byte[] reverse(byte[] array) {
        byte[] byArray;
        return PrimitiveArrayUtil.reverse(array, 0, byArray.length);
    }

    public static double[] reverse(double[] array, int startIndexInclusive, int endIndexExclusive) {
        double[] dArray;
        if (PrimitiveArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            PrimitiveArrayUtil.swap(array, i, j);
        }
        return dArray;
    }

    public static double[] reverse(double[] array) {
        double[] dArray;
        return PrimitiveArrayUtil.reverse(array, 0, dArray.length);
    }

    public static float[] reverse(float[] array, int startIndexInclusive, int endIndexExclusive) {
        float[] fArray;
        if (PrimitiveArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            PrimitiveArrayUtil.swap(array, i, j);
        }
        return fArray;
    }

    public static float[] reverse(float[] array) {
        float[] fArray;
        return PrimitiveArrayUtil.reverse(array, 0, fArray.length);
    }

    public static boolean[] reverse(boolean[] array, int startIndexInclusive, int endIndexExclusive) {
        boolean[] blArray;
        if (PrimitiveArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            PrimitiveArrayUtil.swap(array, i, j);
        }
        return blArray;
    }

    public static boolean[] reverse(boolean[] array) {
        boolean[] blArray;
        return PrimitiveArrayUtil.reverse(array, 0, blArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static long min(long ... numberArray) {
        void var1_1;
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        long min = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int min(int ... numberArray) {
        void var1_1;
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        int min = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static short min(short ... numberArray) {
        void var1_1;
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        short min = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return (short)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static char min(char ... numberArray) {
        void var1_1;
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        char min = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return (char)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static byte min(byte ... numberArray) {
        void var1_1;
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        byte min = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return (byte)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static double min(double ... numberArray) {
        void var1_1;
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        double min = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (!(min > numberArray[i])) continue;
            min = numberArray[i];
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static float min(float ... numberArray) {
        void var1_1;
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        float min = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (!(min > numberArray[i])) continue;
            min = numberArray[i];
        }
        return (float)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static long max(long ... numberArray) {
        void var1_1;
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        long max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int max(int ... numberArray) {
        void var1_1;
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        int max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static short max(short ... numberArray) {
        void var1_1;
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        short max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return (short)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static char max(char ... numberArray) {
        void var1_1;
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        char max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return (char)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static byte max(byte ... numberArray) {
        void var1_1;
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        byte max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return (byte)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static double max(double ... numberArray) {
        void var1_1;
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        double max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (!(max < numberArray[i])) continue;
            max = numberArray[i];
        }
        return (double)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static float max(float ... numberArray) {
        void var1_1;
        if (PrimitiveArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        float max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (!(max < numberArray[i])) continue;
            max = numberArray[i];
        }
        return (float)var1_1;
    }

    public static int[] shuffle(int[] array) {
        return PrimitiveArrayUtil.shuffle(array, (Random)RandomUtil.getRandom());
    }

    public static int[] shuffle(int[] array, Random random) {
        int[] nArray;
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            PrimitiveArrayUtil.swap(array, i - 1, random.nextInt(i));
        }
        return nArray;
    }

    public static long[] shuffle(long[] array) {
        return PrimitiveArrayUtil.shuffle(array, (Random)RandomUtil.getRandom());
    }

    public static long[] shuffle(long[] array, Random random) {
        long[] lArray;
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            PrimitiveArrayUtil.swap(array, i - 1, random.nextInt(i));
        }
        return lArray;
    }

    public static double[] shuffle(double[] array) {
        return PrimitiveArrayUtil.shuffle(array, (Random)RandomUtil.getRandom());
    }

    public static double[] shuffle(double[] array, Random random) {
        double[] dArray;
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            PrimitiveArrayUtil.swap(array, i - 1, random.nextInt(i));
        }
        return dArray;
    }

    public static float[] shuffle(float[] array) {
        return PrimitiveArrayUtil.shuffle(array, (Random)RandomUtil.getRandom());
    }

    public static float[] shuffle(float[] array, Random random) {
        float[] fArray;
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            PrimitiveArrayUtil.swap(array, i - 1, random.nextInt(i));
        }
        return fArray;
    }

    public static boolean[] shuffle(boolean[] array) {
        return PrimitiveArrayUtil.shuffle(array, (Random)RandomUtil.getRandom());
    }

    public static boolean[] shuffle(boolean[] array, Random random) {
        boolean[] blArray;
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            PrimitiveArrayUtil.swap(array, i - 1, random.nextInt(i));
        }
        return blArray;
    }

    public static byte[] shuffle(byte[] array) {
        return PrimitiveArrayUtil.shuffle(array, (Random)RandomUtil.getRandom());
    }

    public static byte[] shuffle(byte[] array, Random random) {
        byte[] byArray;
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            PrimitiveArrayUtil.swap(array, i - 1, random.nextInt(i));
        }
        return byArray;
    }

    public static char[] shuffle(char[] array) {
        return PrimitiveArrayUtil.shuffle(array, (Random)RandomUtil.getRandom());
    }

    public static char[] shuffle(char[] array, Random random) {
        char[] cArray;
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            PrimitiveArrayUtil.swap(array, i - 1, random.nextInt(i));
        }
        return cArray;
    }

    public static short[] shuffle(short[] array) {
        return PrimitiveArrayUtil.shuffle(array, (Random)RandomUtil.getRandom());
    }

    public static short[] shuffle(short[] array, Random random) {
        short[] sArray;
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            PrimitiveArrayUtil.swap(array, i - 1, random.nextInt(i));
        }
        return sArray;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] swap(int[] array, int index1, int index2) {
        int[] nArray;
        void var3_3;
        if (PrimitiveArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        int tmp = array[index1];
        array[var1_1] = array[index2];
        array[var2_2] = var3_3;
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    public static long[] swap(long[] array, int index1, int index2) {
        long[] lArray;
        void var3_3;
        if (PrimitiveArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        long tmp = array[index1];
        array[var1_1] = array[index2];
        array[var2_2] = var3_3;
        return lArray;
    }

    /*
     * WARNING - void declaration
     */
    public static double[] swap(double[] array, int index1, int index2) {
        double[] dArray;
        void var3_3;
        if (PrimitiveArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        double tmp = array[index1];
        array[var1_1] = array[index2];
        array[var2_2] = var3_3;
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public static float[] swap(float[] array, int index1, int index2) {
        float[] fArray;
        void var3_3;
        if (PrimitiveArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        float tmp = array[index1];
        array[var1_1] = array[index2];
        array[var2_2] = var3_3;
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean[] swap(boolean[] array, int index1, int index2) {
        boolean[] blArray;
        void var3_3;
        if (PrimitiveArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        boolean tmp = array[index1];
        array[var1_1] = array[index2];
        array[var2_2] = var3_3;
        return blArray;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] swap(byte[] array, int index1, int index2) {
        byte[] byArray;
        void var3_3;
        if (PrimitiveArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        byte tmp = array[index1];
        array[var1_1] = array[index2];
        array[var2_2] = var3_3;
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] swap(char[] array, int index1, int index2) {
        char[] cArray;
        void var3_3;
        if (PrimitiveArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        char tmp = array[index1];
        array[var1_1] = array[index2];
        array[var2_2] = var3_3;
        return cArray;
    }

    /*
     * WARNING - void declaration
     */
    public static short[] swap(short[] array, int index1, int index2) {
        short[] sArray;
        void var3_3;
        if (PrimitiveArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        short tmp = array[index1];
        array[var1_1] = array[index2];
        array[var2_2] = var3_3;
        return sArray;
    }

    public static boolean isSorted(byte[] array) {
        return PrimitiveArrayUtil.isSortedASC(array);
    }

    public static boolean isSortedASC(byte[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] <= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(byte[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] >= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(short[] array) {
        return PrimitiveArrayUtil.isSortedASC(array);
    }

    public static boolean isSortedASC(short[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] <= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(short[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] >= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(char[] array) {
        return PrimitiveArrayUtil.isSortedASC(array);
    }

    public static boolean isSortedASC(char[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] <= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(char[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] >= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(int[] array) {
        return PrimitiveArrayUtil.isSortedASC(array);
    }

    public static boolean isSortedASC(int[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] <= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(int[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] >= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(long[] array) {
        return PrimitiveArrayUtil.isSortedASC(array);
    }

    public static boolean isSortedASC(long[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] <= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(long[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i] >= array[i + 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(double[] array) {
        return PrimitiveArrayUtil.isSortedASC(array);
    }

    public static boolean isSortedASC(double[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (!(array[i] > array[i + 1])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(double[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (!(array[i] < array[i + 1])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSorted(float[] array) {
        return PrimitiveArrayUtil.isSortedASC(array);
    }

    public static boolean isSortedASC(float[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (!(array[i] > array[i + 1])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSortedDESC(float[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (!(array[i] < array[i + 1])) continue;
            return false;
        }
        return true;
    }
}

