/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.lang.DefaultSegment;
import cn.hutool.core.lang.Segment;

public class PageUtil {
    private static int firstPageNo = 0;

    public static int getFirstPageNo() {
        return firstPageNo;
    }

    public static synchronized void setFirstPageNo(int customFirstPageNo) {
        firstPageNo = customFirstPageNo;
    }

    public static void setOneAsFirstPageNo() {
        PageUtil.setFirstPageNo(1);
    }

    /*
     * WARNING - void declaration
     */
    public static int getStart(int pageNo, int pageSize) {
        void var1_1;
        int n;
        if (pageNo < firstPageNo) {
            pageNo = firstPageNo;
        }
        if (pageSize <= 0) {
            pageSize = 0;
        }
        return (n - firstPageNo) * var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int getEnd(int pageNo, int pageSize) {
        void var1_1;
        int n = PageUtil.getStart(pageNo, pageSize);
        return PageUtil.getEndByStart(n, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] transToStartEnd(int pageNo, int pageSize) {
        void var1_1;
        int n;
        int start = PageUtil.getStart(pageNo, pageSize);
        return new int[]{start, PageUtil.getEndByStart(n, (int)var1_1)};
    }

    /*
     * WARNING - void declaration
     */
    public static Segment<Integer> toSegment(int pageNo, int pageSize) {
        void var0_1;
        void var1_2;
        int[] startEnd = PageUtil.transToStartEnd(pageNo, (int)var1_2);
        return new DefaultSegment<Integer>(startEnd[0], (int)var0_1[1]);
    }

    /*
     * WARNING - void declaration
     */
    public static int totalPage(int totalCount, int pageSize) {
        void var1_1;
        return PageUtil.totalPage((long)totalCount, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int totalPage(long totalCount, int pageSize) {
        void var2_1;
        long l;
        if (pageSize == 0) {
            return 0;
        }
        return Math.toIntExact(totalCount % (long)pageSize == 0L ? totalCount / (long)pageSize : l / (long)var2_1 + 1L);
    }

    public static int[] rainbow(int pageNo, int totalPage, int displayCount) {
        int i;
        boolean isEven = (displayCount & 1) == 0;
        int left = displayCount >> 1;
        int right = displayCount >> 1;
        int length = displayCount;
        if (isEven) {
            ++right;
        }
        if (totalPage < displayCount) {
            length = totalPage;
        }
        int[] result = new int[length];
        if (totalPage >= displayCount) {
            if (pageNo <= left) {
                i = 0;
                while (i < result.length) {
                    int n = i++;
                    result[n] = n + 1;
                }
            } else if (pageNo > totalPage - i) {
                i = 0;
                while (i < result.length) {
                    int n = i++;
                    result[n] = n + totalPage - displayCount + 1;
                }
            } else {
                for (i = 0; i < result.length; ++i) {
                    int n = i;
                    result[n] = n + pageNo - left + (isEven ? 1 : 0);
                }
            }
        } else {
            i = 0;
            while (i < result.length) {
                int n = i++;
                result[n] = n + 1;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] rainbow(int currentPage, int pageCount) {
        void var1_1;
        return PageUtil.rainbow(currentPage, (int)var1_1, 10);
    }

    /*
     * WARNING - void declaration
     */
    private static int getEndByStart(int start, int pageSize) {
        void var1_1;
        int n;
        if (pageSize <= 0) {
            pageSize = 0;
        }
        return n + var1_1;
    }
}

