/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.comparator.CompareUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.SerializeUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class ObjectUtil {
    /*
     * WARNING - void declaration
     */
    public static boolean equals(Object obj1, Object obj2) {
        void var1_1;
        return ObjectUtil.equal(obj1, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equal(Object obj1, Object obj2) {
        void var1_1;
        Object object;
        if (obj1 instanceof Number && obj2 instanceof Number) {
            return NumberUtil.equals((Number)obj1, (Number)obj2);
        }
        return Objects.equals(object, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean notEqual(Object obj1, Object obj2) {
        void var1_1;
        Object object;
        return false == ObjectUtil.equal(object, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int length(Object obj) {
        Object object;
        Object count2;
        if (obj == null) {
            return 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            int count2 = 0;
            while (iter.hasNext()) {
                ++count2;
                iter.next();
            }
            return count2;
        }
        if (count2 instanceof Enumeration) {
            void var0_2;
            Enumeration enumeration = (Enumeration)count2;
            int count3 = 0;
            while (enumeration.hasMoreElements()) {
                ++count3;
                enumeration.nextElement();
            }
            return (int)var0_2;
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object);
        }
        return -1;
    }

    public static boolean contains(Object obj, Object element) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            if (element == null) {
                return false;
            }
            return ((String)obj).contains(element.toString());
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).contains(element);
        }
        if (obj instanceof Map) {
            return ((Map)obj).containsValue(element);
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            while (iter.hasNext()) {
                Object e = iter.next();
                if (!ObjectUtil.equal(e, element)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!ObjectUtil.equal(e, element)) continue;
                return true;
            }
            return false;
        }
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                Object object = Array.get(obj, i);
                if (!ObjectUtil.equal(object, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNull(Object obj) {
        Object object;
        return obj == null || object.equals(null);
    }

    public static boolean isNotNull(Object obj) {
        Object object;
        return obj != null && false == object.equals(null);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StrUtil.isEmpty((CharSequence)obj);
        }
        if (obj instanceof Map) {
            return MapUtil.isEmpty((Map)obj);
        }
        if (obj instanceof Iterable) {
            return IterUtil.isEmpty((Iterable)obj);
        }
        if (obj instanceof Iterator) {
            return IterUtil.isEmpty((Iterator)obj);
        }
        if (ArrayUtil.isArray(obj)) {
            Object object;
            return ArrayUtil.isEmpty(object);
        }
        return false;
    }

    public static boolean isNotEmpty(Object obj) {
        Object object;
        return false == ObjectUtil.isEmpty(object);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T defaultIfNull(T object, T defaultValue) {
        T t;
        if (ObjectUtil.isNull(object)) {
            void var1_1;
            return var1_1;
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T defaultIfNull(T source, Supplier<? extends T> defaultValueSupplier) {
        T t;
        if (ObjectUtil.isNull(source)) {
            void var1_1;
            return var1_1.get();
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T defaultIfNull(T source, Function<T, ? extends T> defaultValueSupplier) {
        T t;
        if (ObjectUtil.isNull(source)) {
            void var1_1;
            return (T)var1_1.apply(null);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> T defaultIfNull(Object source, Supplier<? extends T> handle, T defaultValue) {
        void var2_2;
        if (ObjectUtil.isNotNull(source)) {
            void var1_1;
            return var1_1.get();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T, R> T defaultIfNull(R source, Function<R, ? extends T> handle, T defaultValue) {
        void var2_2;
        if (ObjectUtil.isNotNull(source)) {
            R r;
            void var1_1;
            return (T)var1_1.apply(r);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> T defaultIfEmpty(String str, Supplier<? extends T> handle, T defaultValue) {
        void var2_2;
        if (StrUtil.isNotEmpty(str)) {
            void var1_1;
            return var1_1.get();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T defaultIfEmpty(String str, Function<CharSequence, ? extends T> handle, T defaultValue) {
        void var2_2;
        if (StrUtil.isNotEmpty(str)) {
            String string;
            void var1_1;
            return (T)var1_1.apply(string);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T defaultIfEmpty(T str, T defaultValue) {
        T t;
        if (StrUtil.isEmpty(str)) {
            void var1_1;
            return var1_1;
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T defaultIfEmpty(T str, Supplier<? extends T> defaultValueSupplier) {
        T t;
        if (StrUtil.isEmpty(str)) {
            void var1_1;
            return (T)((CharSequence)var1_1.get());
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T defaultIfEmpty(T str, Function<T, ? extends T> defaultValueSupplier) {
        T t;
        if (StrUtil.isEmpty(str)) {
            void var1_1;
            return (T)((CharSequence)var1_1.apply(null));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T defaultIfBlank(T str, T defaultValue) {
        T t;
        if (StrUtil.isBlank(str)) {
            void var1_1;
            return var1_1;
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T defaultIfBlank(T str, Supplier<? extends T> defaultValueSupplier) {
        T t;
        if (StrUtil.isBlank(str)) {
            void var1_1;
            return (T)((CharSequence)var1_1.get());
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends CharSequence> T defaultIfBlank(T str, Function<T, ? extends T> defaultValueSupplier) {
        T t;
        if (StrUtil.isBlank(str)) {
            void var1_1;
            return (T)((CharSequence)var1_1.apply(null));
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T clone(T obj) {
        void var1_1;
        T result = ArrayUtil.clone(obj);
        if (result == null) {
            T t;
            result = obj instanceof Cloneable ? ReflectUtil.invoke(obj, "clone", new Object[0]) : ObjectUtil.cloneByStream(t);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T cloneIfPossible(T obj) {
        void var1_1;
        Object clone = null;
        try {
            clone = ObjectUtil.clone(obj);
        }
        catch (Exception exception) {}
        if (clone == null) {
            T t;
            return t;
        }
        return var1_1;
    }

    public static <T> T cloneByStream(T obj) {
        return SerializeUtil.clone(obj);
    }

    public static <T> byte[] serialize(T obj) {
        return SerializeUtil.serialize(obj);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T deserialize(byte[] bytes, Class<?> ... acceptClasses) {
        void var1_1;
        return SerializeUtil.deserialize(bytes, var1_1);
    }

    public static boolean isBasicType(Object object) {
        Object object2;
        if (object == null) {
            return false;
        }
        return ClassUtil.isBasicType(object2.getClass());
    }

    public static boolean isValidIfNumber(Object obj) {
        if (obj instanceof Number) {
            Object object;
            return NumberUtil.isValidNumber((Number)object);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Comparable<? super T>> int compare(T c1, T c2) {
        void var1_1;
        return CompareUtil.compare(c1, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Comparable<? super T>> int compare(T c1, T c2, boolean nullGreater) {
        void var2_2;
        void var1_1;
        return CompareUtil.compare(c1, var1_1, (boolean)var2_2);
    }

    public static Class<?> getTypeArgument(Object obj) {
        return ObjectUtil.getTypeArgument(obj, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> getTypeArgument(Object obj, int index) {
        void var1_1;
        return ClassUtil.getTypeArgument(obj.getClass(), (int)var1_1);
    }

    public static String toString(Object obj) {
        Object object;
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Map) {
            return obj.toString();
        }
        return Convert.toStr(object);
    }

    public static int emptyCount(Object ... objs) {
        return ArrayUtil.emptyCount(objs);
    }

    public static boolean hasNull(Object ... objs) {
        return ArrayUtil.hasNull(objs);
    }

    public static boolean hasEmpty(Object ... objs) {
        return ArrayUtil.hasEmpty(objs);
    }

    public static boolean isAllEmpty(Object ... objs) {
        return ArrayUtil.isAllEmpty(objs);
    }

    public static boolean isAllNotEmpty(Object ... objs) {
        return ArrayUtil.isAllNotEmpty(objs);
    }
}

