/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.math.Calculator;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;

public class NumberUtil {
    private static final int DEFAULT_DIV_SCALE = 10;
    private static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};

    /*
     * WARNING - void declaration
     */
    public static double add(float v1, float v2) {
        void var1_1;
        float f;
        return NumberUtil.add(Float.toString(f), Float.toString((float)var1_1)).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static double add(float v1, double v2) {
        void var1_1;
        float f;
        return NumberUtil.add(Float.toString(f), Double.toString((double)var1_1)).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static double add(double v1, float v2) {
        void var2_1;
        double d;
        return NumberUtil.add(Double.toString(d), Float.toString((float)var2_1)).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static double add(double v1, double v2) {
        void var2_1;
        double d;
        return NumberUtil.add(Double.toString(d), Double.toString((double)var2_1)).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static double add(Double v1, Double v2) {
        void var1_1;
        return NumberUtil.add((Number)v1, (Number)var1_1).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal add(Number v1, Number v2) {
        void var1_1;
        Number number;
        return NumberUtil.add(new Number[]{number, var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal add(Number ... values) {
        void var2_2;
        if (ArrayUtil.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        Number number = values[0];
        BigDecimal result = NumberUtil.toBigDecimal(number);
        for (int i = 1; i < values.length; ++i) {
            Number value = values[i];
            if (value == null) continue;
            result = result.add(NumberUtil.toBigDecimal(number));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal add(String ... values) {
        void var2_2;
        if (ArrayUtil.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        String string = values[0];
        BigDecimal result = NumberUtil.toBigDecimal(string);
        for (int i = 1; i < values.length; ++i) {
            String value = values[i];
            if (!StrUtil.isNotBlank(value)) continue;
            result = result.add(NumberUtil.toBigDecimal(string));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal add(BigDecimal ... values) {
        void var2_2;
        if (ArrayUtil.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = values[0];
        BigDecimal result = NumberUtil.toBigDecimal(bigDecimal);
        for (int i = 1; i < values.length; ++i) {
            BigDecimal value = values[i];
            if (value == null) continue;
            result = result.add(bigDecimal);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static double sub(float v1, float v2) {
        void var1_1;
        float f;
        return NumberUtil.sub(Float.toString(f), Float.toString((float)var1_1)).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static double sub(float v1, double v2) {
        void var1_1;
        float f;
        return NumberUtil.sub(Float.toString(f), Double.toString((double)var1_1)).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static double sub(double v1, float v2) {
        void var2_1;
        double d;
        return NumberUtil.sub(Double.toString(d), Float.toString((float)var2_1)).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static double sub(double v1, double v2) {
        void var2_1;
        double d;
        return NumberUtil.sub(Double.toString(d), Double.toString((double)var2_1)).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static double sub(Double v1, Double v2) {
        void var1_1;
        return NumberUtil.sub((Number)v1, (Number)var1_1).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal sub(Number v1, Number v2) {
        void var1_1;
        Number number;
        return NumberUtil.sub(new Number[]{number, var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal sub(Number ... values) {
        void var2_2;
        if (ArrayUtil.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        Number number = values[0];
        BigDecimal result = NumberUtil.toBigDecimal(number);
        for (int i = 1; i < values.length; ++i) {
            Number value = values[i];
            if (value == null) continue;
            result = result.subtract(NumberUtil.toBigDecimal(number));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal sub(String ... values) {
        void var2_2;
        if (ArrayUtil.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        String string = values[0];
        BigDecimal result = NumberUtil.toBigDecimal(string);
        for (int i = 1; i < values.length; ++i) {
            String value = values[i];
            if (!StrUtil.isNotBlank(value)) continue;
            result = result.subtract(NumberUtil.toBigDecimal(string));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal sub(BigDecimal ... values) {
        void var2_2;
        if (ArrayUtil.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = values[0];
        BigDecimal result = NumberUtil.toBigDecimal(bigDecimal);
        for (int i = 1; i < values.length; ++i) {
            BigDecimal value = values[i];
            if (value == null) continue;
            result = result.subtract(bigDecimal);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static double mul(float v1, float v2) {
        void var1_1;
        return NumberUtil.mul(Float.toString(v1), Float.toString((float)var1_1)).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static double mul(float v1, double v2) {
        void var1_1;
        return NumberUtil.mul(Float.toString(v1), Double.toString((double)var1_1)).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static double mul(double v1, float v2) {
        void var2_1;
        return NumberUtil.mul(Double.toString(v1), Float.toString((float)var2_1)).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static double mul(double v1, double v2) {
        void var2_1;
        return NumberUtil.mul(Double.toString(v1), Double.toString((double)var2_1)).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static double mul(Double v1, Double v2) {
        void var1_1;
        return NumberUtil.mul((Number)v1, (Number)var1_1).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal mul(Number v1, Number v2) {
        void var1_1;
        Number number;
        return NumberUtil.mul(new Number[]{number, var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal mul(Number ... values) {
        void var2_2;
        if (ArrayUtil.isEmpty(values) || ArrayUtil.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        Number number = values[0];
        BigDecimal result = NumberUtil.toBigDecimal(number.toString());
        for (int i = 1; i < values.length; ++i) {
            Number value = values[i];
            result = result.multiply(NumberUtil.toBigDecimal(number.toString()));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal mul(String v1, String v2) {
        void var1_1;
        return NumberUtil.mul((Number)NumberUtil.toBigDecimal(v1), (Number)NumberUtil.toBigDecimal((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal mul(String ... values) {
        void var1_1;
        if (ArrayUtil.isEmpty(values) || ArrayUtil.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = NumberUtil.toBigDecimal(values[0]);
        for (int i = 1; i < values.length; ++i) {
            result = result.multiply(NumberUtil.toBigDecimal(values[i]));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal mul(BigDecimal ... values) {
        void var1_1;
        if (ArrayUtil.isEmpty(values) || ArrayUtil.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = values[0];
        for (int i = 1; i < values.length; ++i) {
            result = result.multiply(values[i]);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static double div(float v1, float v2) {
        void var1_1;
        return NumberUtil.div(v1, (float)var1_1, 10);
    }

    /*
     * WARNING - void declaration
     */
    public static double div(float v1, double v2) {
        void var1_1;
        return NumberUtil.div(v1, (double)var1_1, 10);
    }

    /*
     * WARNING - void declaration
     */
    public static double div(double v1, float v2) {
        void var2_1;
        return NumberUtil.div(v1, (float)var2_1, 10);
    }

    /*
     * WARNING - void declaration
     */
    public static double div(double v1, double v2) {
        void var2_1;
        return NumberUtil.div(v1, (double)var2_1, 10);
    }

    /*
     * WARNING - void declaration
     */
    public static double div(Double v1, Double v2) {
        void var1_1;
        return NumberUtil.div(v1, (Double)var1_1, 10);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal div(Number v1, Number v2) {
        void var1_1;
        return NumberUtil.div(v1, (Number)var1_1, 10);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal div(String v1, String v2) {
        void var1_1;
        return NumberUtil.div(v1, (String)var1_1, 10);
    }

    /*
     * WARNING - void declaration
     */
    public static double div(float v1, float v2, int scale) {
        void var2_2;
        void var1_1;
        return NumberUtil.div(v1, (float)var1_1, (int)var2_2, RoundingMode.HALF_UP);
    }

    /*
     * WARNING - void declaration
     */
    public static double div(float v1, double v2, int scale) {
        void var3_2;
        void var1_1;
        return NumberUtil.div(v1, (double)var1_1, (int)var3_2, RoundingMode.HALF_UP);
    }

    /*
     * WARNING - void declaration
     */
    public static double div(double v1, float v2, int scale) {
        void var3_2;
        void var2_1;
        return NumberUtil.div(v1, (float)var2_1, (int)var3_2, RoundingMode.HALF_UP);
    }

    /*
     * WARNING - void declaration
     */
    public static double div(double v1, double v2, int scale) {
        void var2_2;
        return NumberUtil.div(v1, (double)var2_2, scale, RoundingMode.HALF_UP);
    }

    /*
     * WARNING - void declaration
     */
    public static double div(Double v1, Double v2, int scale) {
        void var2_2;
        void var1_1;
        return NumberUtil.div(v1, (Double)var1_1, (int)var2_2, RoundingMode.HALF_UP);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal div(Number v1, Number v2, int scale) {
        void var2_2;
        void var1_1;
        return NumberUtil.div(v1, (Number)var1_1, (int)var2_2, RoundingMode.HALF_UP);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal div(String v1, String v2, int scale) {
        void var2_2;
        void var1_1;
        return NumberUtil.div(v1, (String)var1_1, (int)var2_2, RoundingMode.HALF_UP);
    }

    /*
     * WARNING - void declaration
     */
    public static double div(float v1, float v2, int scale, RoundingMode roundingMode) {
        void var3_3;
        void var2_2;
        void var1_1;
        return NumberUtil.div(Float.toString(v1), Float.toString((float)var1_1), (int)var2_2, (RoundingMode)var3_3).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static double div(float v1, double v2, int scale, RoundingMode roundingMode) {
        void var3_2;
        void var1_1;
        return NumberUtil.div(Float.toString(v1), Double.toString((double)var1_1), (int)var3_2, roundingMode).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static double div(double v1, float v2, int scale, RoundingMode roundingMode) {
        void var3_2;
        void var2_1;
        return NumberUtil.div(Double.toString(v1), Float.toString((float)var2_1), (int)var3_2, roundingMode).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static double div(double v1, double v2, int scale, RoundingMode roundingMode) {
        void var2_1;
        return NumberUtil.div(Double.toString(v1), Double.toString((double)var2_1), scale, roundingMode).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static double div(Double v1, Double v2, int scale, RoundingMode roundingMode) {
        void var3_3;
        void var2_2;
        void var1_1;
        return NumberUtil.div((Number)v1, (Number)var1_1, (int)var2_2, (RoundingMode)var3_3).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal div(Number v1, Number v2, int scale, RoundingMode roundingMode) {
        void var3_3;
        void var2_2;
        void var1_1;
        Number number;
        if (v1 instanceof BigDecimal && v2 instanceof BigDecimal) {
            return NumberUtil.div((BigDecimal)v1, (BigDecimal)v2, scale, roundingMode);
        }
        return NumberUtil.div(StrUtil.toStringOrNull(number), StrUtil.toStringOrNull(var1_1), (int)var2_2, (RoundingMode)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal div(String v1, String v2, int scale, RoundingMode roundingMode) {
        void var3_3;
        void var2_2;
        void var1_1;
        return NumberUtil.div(NumberUtil.toBigDecimal(v1), NumberUtil.toBigDecimal((String)var1_1), (int)var2_2, (RoundingMode)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal div(BigDecimal v1, BigDecimal v2, int scale, RoundingMode roundingMode) {
        void var3_3;
        void var2_2;
        void var1_1;
        BigDecimal bigDecimal;
        Assert.notNull(v2, "Divisor must be not null !", new Object[0]);
        if (v1 == null) {
            return BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = -scale;
        }
        return bigDecimal.divide((BigDecimal)var1_1, (int)var2_2, (RoundingMode)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static int ceilDiv(int v1, int v2) {
        void var1_1;
        return (int)Math.ceil((double)v1 / (double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal round(double v, int scale) {
        void var2_1;
        return NumberUtil.round(v, (int)var2_1, RoundingMode.HALF_UP);
    }

    /*
     * WARNING - void declaration
     */
    public static String roundStr(double v, int scale) {
        void var2_1;
        return NumberUtil.round(v, (int)var2_1).toPlainString();
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal round(String numberStr, int scale) {
        void var1_1;
        return NumberUtil.round(numberStr, (int)var1_1, RoundingMode.HALF_UP);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal round(BigDecimal number, int scale) {
        void var1_1;
        return NumberUtil.round(number, (int)var1_1, RoundingMode.HALF_UP);
    }

    /*
     * WARNING - void declaration
     */
    public static String roundStr(String numberStr, int scale) {
        void var1_1;
        return NumberUtil.round(numberStr, (int)var1_1).toPlainString();
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal round(double v, int scale, RoundingMode roundingMode) {
        void var3_2;
        void var2_1;
        return NumberUtil.round(Double.toString(v), (int)var2_1, (RoundingMode)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String roundStr(double v, int scale, RoundingMode roundingMode) {
        void var3_2;
        void var2_1;
        return NumberUtil.round(v, (int)var2_1, (RoundingMode)var3_2).toPlainString();
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal round(String numberStr, int scale, RoundingMode roundingMode) {
        void var2_2;
        void var1_1;
        String string;
        Assert.notBlank(numberStr);
        if (scale < 0) {
            scale = 0;
        }
        return NumberUtil.round(NumberUtil.toBigDecimal(string), (int)var1_1, (RoundingMode)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal round(BigDecimal number, int scale, RoundingMode roundingMode) {
        void var2_2;
        void var1_1;
        BigDecimal bigDecimal;
        if (number == null) {
            number = BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = 0;
        }
        if (roundingMode == null) {
            roundingMode = RoundingMode.HALF_UP;
        }
        return bigDecimal.setScale((int)var1_1, (RoundingMode)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String roundStr(String numberStr, int scale, RoundingMode roundingMode) {
        void var2_2;
        void var1_1;
        return NumberUtil.round(numberStr, (int)var1_1, (RoundingMode)var2_2).toPlainString();
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal roundHalfEven(Number number, int scale) {
        void var1_1;
        return NumberUtil.roundHalfEven(NumberUtil.toBigDecimal(number), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal roundHalfEven(BigDecimal value, int scale) {
        void var1_1;
        return NumberUtil.round(value, (int)var1_1, RoundingMode.HALF_EVEN);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal roundDown(Number number, int scale) {
        void var1_1;
        return NumberUtil.roundDown(NumberUtil.toBigDecimal(number), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal roundDown(BigDecimal value, int scale) {
        void var1_1;
        return NumberUtil.round(value, (int)var1_1, RoundingMode.DOWN);
    }

    /*
     * WARNING - void declaration
     */
    public static String decimalFormat(String pattern, double value) {
        void var1_1;
        String string;
        Assert.isTrue(NumberUtil.isValid(value), "value is NaN or Infinite!", new Object[0]);
        return new DecimalFormat(string).format((double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String decimalFormat(String pattern, long value) {
        void var1_1;
        String string;
        return new DecimalFormat(string).format((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String decimalFormat(String pattern, Object value) {
        void var1_1;
        return NumberUtil.decimalFormat(pattern, var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String decimalFormat(String pattern, Object value, RoundingMode roundingMode) {
        void var1_1;
        DecimalFormat decimalFormat;
        if (value instanceof Number) {
            Assert.isTrue(NumberUtil.isValidNumber((Number)value), "value is NaN or Infinite!", new Object[0]);
        }
        DecimalFormat decimalFormat2 = new DecimalFormat(pattern);
        if (roundingMode != null) {
            void var2_2;
            decimalFormat2.setRoundingMode((RoundingMode)var2_2);
        }
        return decimalFormat.format(var1_1);
    }

    public static String decimalFormatMoney(double value) {
        double d;
        return NumberUtil.decimalFormat(",##0.00", d);
    }

    /*
     * WARNING - void declaration
     */
    public static String formatPercent(double number, int scale) {
        double d;
        void var3_2;
        void var2_1;
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMaximumFractionDigits((int)var2_1);
        return var3_2.format(d);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isNumber(CharSequence str) {
        int i;
        int start;
        if (StrUtil.isBlank(str)) {
            return false;
        }
        char[] cArray = str.toString().toCharArray();
        Object chars = cArray;
        int sz = cArray.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == 45 || chars[0] == 43 ? 1 : 0;
        if (sz > start + 1 && chars[start] == 48 && (chars[start + 1] == 120 || chars[start + 1] == 88)) {
            i = start + 2;
            if (i == sz) {
                return false;
            }
            while (i < ((Object)chars).length) {
                if (!(chars[i] >= 48 && chars[i] <= 57 || chars[i] >= 97 && chars[i] <= 102 || chars[i] >= 65 && chars[i] <= 70)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        --sz;
        while (i < sz || i < sz + 1 && allowSigns && !foundDigit) {
            if (chars[i] >= 48 && chars[i] <= 57) {
                foundDigit = true;
                allowSigns = false;
            } else if (chars[i] == 46) {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
            } else if (chars[i] == 101 || chars[i] == 69) {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
            } else if (chars[i] == 43 || chars[i] == 45) {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
            } else {
                return false;
            }
            ++i;
        }
        if (i < ((Object)chars).length) {
            Object object;
            if (chars[i] >= 48 && chars[i] <= 57) {
                return true;
            }
            if (chars[i] == 101 || chars[i] == 69) {
                return false;
            }
            if (chars[i] == 46) {
                void var3_3;
                if (var3_3 != false || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 100 && chars[i] != 68 && chars[i] != 102 && chars[i] != 70)) {
                return foundDigit;
            }
            if (chars[i] == 108 || object[i] == 76) {
                void var2_2;
                return foundDigit && var2_2 == false;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static boolean isInteger(String s) {
        if (StrUtil.isBlank(s)) {
            return false;
        }
        try {
            String string;
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isLong(String s) {
        if (StrUtil.isBlank(s)) {
            return false;
        }
        try {
            String string;
            Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isDouble(String s) {
        String string;
        if (StrUtil.isBlank(s)) {
            return false;
        }
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return string.contains(".");
    }

    public static boolean isPrimes(int n) {
        Assert.isTrue(n > 1, "The number must be > 1", new Object[0]);
        int i = 2;
        while ((double)i <= Math.sqrt(n)) {
            if (n % i == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static int[] generateRandomNumber(int begin, int end, int size) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        int[] seed = ArrayUtil.range(begin, end);
        return NumberUtil.generateRandomNumber(n, (int)var1_1, (int)var2_2, (int[])var3_3);
    }

    public static int[] generateRandomNumber(int begin, int end, int size, int[] seed) {
        if (begin > end) {
            int temp = begin;
            begin = end;
            end = temp;
        }
        Assert.isTrue(end - begin >= size, "Size is larger than range between begin and end!", new Object[0]);
        Assert.isTrue(seed.length >= size, "Size is larger than seed size!", new Object[0]);
        int[] ranArr = new int[size];
        for (int i = 0; i < size; ++i) {
            int j = RandomUtil.randomInt(seed.length - i);
            ranArr[i] = seed[j];
            seed[var1_1] = seed[seed.length - 1 - i];
        }
        return ranArr;
    }

    /*
     * WARNING - void declaration
     */
    public static Integer[] generateBySet(int begin, int end, int size) {
        void var3_4;
        if (begin > end) {
            int temp = begin;
            begin = end;
            end = temp;
        }
        if (end - begin < size) {
            throw new UtilException("Size is larger than range between begin and end!");
        }
        HashSet<Integer> set = new HashSet<Integer>(size, 1.0f);
        while (set.size() < size) {
            set.add(begin + RandomUtil.randomInt(end - begin));
        }
        return var3_4.toArray(new Integer[0]);
    }

    public static int[] range(int stop) {
        int n;
        return NumberUtil.range(0, n);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] range(int start, int stop) {
        void var1_1;
        return NumberUtil.range(start, (int)var1_1, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static int[] range(int start, int stop, int step) {
        void var3_4;
        int i;
        if (start < stop) {
            step = Math.abs(step);
        } else if (start > stop) {
            step = -Math.abs(step);
        } else {
            return new int[]{start};
        }
        int n = Math.abs((stop - start) / step) + 1;
        int[] values = new int[n];
        int index = 0;
        while (step > 0 ? i <= stop : i >= stop) {
            values[index] = i;
            ++index;
            i += step;
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<Integer> appendRange(int start, int stop, Collection<Integer> values) {
        void var2_2;
        void var1_1;
        return NumberUtil.appendRange(start, (int)var1_1, 1, (Collection<Integer>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<Integer> appendRange(int start, int stop, int step, Collection<Integer> values) {
        void var3_3;
        int i;
        if (start < stop) {
            step = Math.abs(step);
        } else if (start > stop) {
            step = -Math.abs(step);
        } else {
            values.add(start);
            return values;
        }
        while (step > 0 ? i <= stop : i >= stop) {
            values.add(i);
            i += step;
        }
        return var3_3;
    }

    public static BigInteger factorial(BigInteger n) {
        BigInteger bigInteger;
        if (n.equals(BigInteger.ZERO)) {
            return BigInteger.ONE;
        }
        return NumberUtil.factorial(bigInteger, BigInteger.ZERO);
    }

    /*
     * WARNING - void declaration
     */
    public static BigInteger factorial(BigInteger start, BigInteger end) {
        void var2_2;
        Assert.notNull(start, "Factorial start must be not null!", new Object[0]);
        Assert.notNull(end, "Factorial end must be not null!", new Object[0]);
        if (start.compareTo(BigInteger.ZERO) < 0 || end.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException(StrUtil.format("Factorial start and end both must be > 0, but got start={}, end={}", start, end));
        }
        if (start.equals(BigInteger.ZERO)) {
            start = BigInteger.ONE;
        }
        if (end.compareTo(BigInteger.ONE) < 0) {
            end = BigInteger.ONE;
        }
        BigInteger result = start;
        end = end.add(BigInteger.ONE);
        while (start.compareTo(end) > 0) {
            start = start.subtract(BigInteger.ONE);
            result = result.multiply(start);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static long factorial(long start, long end) {
        void var2_1;
        long l;
        if (start < 0L || end < 0L) {
            throw new IllegalArgumentException(StrUtil.format("Factorial start and end both must be >= 0, but got start={}, end={}", start, end));
        }
        if (0L == start || start == end) {
            return 1L;
        }
        if (start < end) {
            return 0L;
        }
        long l2 = l;
        return NumberUtil.factorialMultiplyAndCheck(l2, NumberUtil.factorial(l2 - 1L, (long)var2_1));
    }

    /*
     * WARNING - void declaration
     */
    private static long factorialMultiplyAndCheck(long a, long b) {
        void var2_1;
        long l;
        if (a <= Long.MAX_VALUE / b) {
            return a * b;
        }
        throw new IllegalArgumentException(StrUtil.format("Overflow in multiplication: {} * {}", l, (long)var2_1));
    }

    public static long factorial(long n) {
        long l;
        if (n < 0L || n > 20L) {
            throw new IllegalArgumentException(StrUtil.format("Factorial must have n >= 0 and n <= 20 for n!, but got n = {}", n));
        }
        return FACTORIALS[(int)l];
    }

    /*
     * WARNING - void declaration
     */
    public static long sqrt(long x) {
        void var2_1;
        long y = 0L;
        for (long b = 0x4000000000000000L; b > 0L; b >>= 2) {
            if (x >= y + b) {
                x -= y + b;
                y >>= 1;
                y += b;
                continue;
            }
            y >>= 1;
        }
        return (long)var2_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int processMultiple(int selectNum, int minNum) {
        void var1_1;
        int n;
        n = NumberUtil.mathSubNode(selectNum, minNum) / NumberUtil.mathNode(n - var1_1);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static int divisor(int m, int n) {
        void var1_1;
        while (m % n != 0) {
            void var2_2;
            int temp = m % n;
            m = n;
            n = var2_2;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int multiple(int m, int n) {
        void var1_1;
        int n2;
        return m * n / NumberUtil.divisor(n2, (int)var1_1);
    }

    public static String getBinaryStr(Number number) {
        Number number2;
        if (number instanceof Long) {
            return Long.toBinaryString((Long)number);
        }
        if (number instanceof Integer) {
            return Integer.toBinaryString((Integer)number);
        }
        return Long.toBinaryString(number2.longValue());
    }

    public static int binaryToInt(String binaryStr) {
        return Integer.parseInt(binaryStr, 2);
    }

    public static long binaryToLong(String binaryStr) {
        return Long.parseLong(binaryStr, 2);
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(char x, char y) {
        void var1_1;
        return Character.compare(x, (char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(double x, double y) {
        void var2_1;
        return Double.compare(x, (double)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(int x, int y) {
        void var1_1;
        return Integer.compare(x, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(long x, long y) {
        void var2_1;
        return Long.compare(x, (long)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(short x, short y) {
        void var1_1;
        return Short.compare(x, (short)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(byte x, byte y) {
        void var1_1;
        return Byte.compare(x, (byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isGreater(BigDecimal bigNum1, BigDecimal bigNum2) {
        void var1_1;
        BigDecimal bigDecimal;
        Assert.notNull(bigNum1);
        Assert.notNull(bigNum2);
        return bigDecimal.compareTo((BigDecimal)var1_1) > 0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isGreaterOrEqual(BigDecimal bigNum1, BigDecimal bigNum2) {
        void var1_1;
        BigDecimal bigDecimal;
        Assert.notNull(bigNum1);
        Assert.notNull(bigNum2);
        return bigDecimal.compareTo((BigDecimal)var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isLess(BigDecimal bigNum1, BigDecimal bigNum2) {
        void var1_1;
        BigDecimal bigDecimal;
        Assert.notNull(bigNum1);
        Assert.notNull(bigNum2);
        return bigDecimal.compareTo((BigDecimal)var1_1) < 0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isLessOrEqual(BigDecimal bigNum1, BigDecimal bigNum2) {
        void var1_1;
        BigDecimal bigDecimal;
        Assert.notNull(bigNum1);
        Assert.notNull(bigNum2);
        return bigDecimal.compareTo((BigDecimal)var1_1) <= 0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isIn(BigDecimal value, BigDecimal minInclude, BigDecimal maxInclude) {
        void var2_2;
        BigDecimal bigDecimal;
        void var1_1;
        Assert.notNull(value);
        Assert.notNull(minInclude);
        Assert.notNull(maxInclude);
        return NumberUtil.isGreaterOrEqual(value, (BigDecimal)var1_1) && NumberUtil.isLessOrEqual(bigDecimal, (BigDecimal)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(double num1, double num2) {
        void var2_1;
        return Double.doubleToLongBits(num1) == Double.doubleToLongBits((double)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(float num1, float num2) {
        void var1_1;
        return Float.floatToIntBits(num1) == Float.floatToIntBits((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(long num1, long num2) {
        void var2_1;
        return num1 == var2_1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(Number number1, Number number2) {
        void var1_1;
        Number number;
        if (number1 instanceof BigDecimal && number2 instanceof BigDecimal) {
            return NumberUtil.equals((BigDecimal)number1, (BigDecimal)number2);
        }
        return Objects.equals(number, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(BigDecimal bigNum1, BigDecimal bigNum2) {
        void var1_1;
        BigDecimal bigDecimal;
        if (bigNum1 == bigNum2) {
            return true;
        }
        if (bigNum1 == null || bigNum2 == null) {
            return false;
        }
        return 0 == bigDecimal.compareTo((BigDecimal)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(char c1, char c2, boolean ignoreCase) {
        void var2_2;
        void var1_1;
        return CharUtil.equals(c1, (char)var1_1, (boolean)var2_2);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray) {
        return (T)ArrayUtil.min(numberArray);
    }

    public static long min(long ... numberArray) {
        return ArrayUtil.min(numberArray);
    }

    public static int min(int ... numberArray) {
        return ArrayUtil.min(numberArray);
    }

    public static short min(short ... numberArray) {
        return ArrayUtil.min(numberArray);
    }

    public static double min(double ... numberArray) {
        return ArrayUtil.min(numberArray);
    }

    public static float min(float ... numberArray) {
        return ArrayUtil.min(numberArray);
    }

    public static BigDecimal min(BigDecimal ... numberArray) {
        return (BigDecimal)ArrayUtil.min((Comparable[])numberArray);
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray) {
        return (T)ArrayUtil.max(numberArray);
    }

    public static long max(long ... numberArray) {
        return ArrayUtil.max(numberArray);
    }

    public static int max(int ... numberArray) {
        return ArrayUtil.max(numberArray);
    }

    public static short max(short ... numberArray) {
        return ArrayUtil.max(numberArray);
    }

    public static double max(double ... numberArray) {
        return ArrayUtil.max(numberArray);
    }

    public static float max(float ... numberArray) {
        return ArrayUtil.max(numberArray);
    }

    public static BigDecimal max(BigDecimal ... numberArray) {
        return (BigDecimal)ArrayUtil.max((Comparable[])numberArray);
    }

    /*
     * WARNING - void declaration
     */
    public static String toStr(Number number, String defaultValue) {
        Number number2;
        if (number == null) {
            void var1_1;
            return var1_1;
        }
        return NumberUtil.toStr(number2);
    }

    public static String toStr(Number number) {
        return NumberUtil.toStr(number, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String toStr(Number number, boolean isStripTrailingZeros) {
        Object object;
        void var1_1;
        Assert.notNull(number, "Number is null !", new Object[0]);
        if (number instanceof BigDecimal) {
            return NumberUtil.toStr((BigDecimal)number, isStripTrailingZeros);
        }
        Assert.isTrue(NumberUtil.isValidNumber(number), "Number is non-finite!", new Object[0]);
        Object string = number.toString();
        if (var1_1 != false && ((String)string).indexOf(46) > 0 && ((String)string).indexOf(101) < 0 && ((String)string).indexOf(69) < 0) {
            while (((String)string).endsWith("0")) {
                string = ((String)string).substring(0, ((String)string).length() - 1);
            }
            if (((String)string).endsWith(".")) {
                string = ((String)string).substring(0, ((String)string).length() - 1);
            }
        }
        return object;
    }

    public static String toStr(BigDecimal bigDecimal) {
        return NumberUtil.toStr(bigDecimal, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String toStr(BigDecimal bigDecimal, boolean isStripTrailingZeros) {
        BigDecimal bigDecimal2;
        void var1_1;
        Assert.notNull(bigDecimal, "BigDecimal is null !", new Object[0]);
        if (var1_1 != false) {
            bigDecimal = bigDecimal.stripTrailingZeros();
        }
        return bigDecimal2.toPlainString();
    }

    public static BigDecimal toBigDecimal(Number number) {
        Number number2;
        if (number == null) {
            return BigDecimal.ZERO;
        }
        Assert.isTrue(NumberUtil.isValidNumber(number), "Number is invalid!", new Object[0]);
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return new BigDecimal(number2.toString());
    }

    public static BigDecimal toBigDecimal(String numberStr) {
        if (StrUtil.isBlank(numberStr)) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(numberStr);
        }
        catch (Exception exception) {
            Number number;
            number = NumberUtil.parseNumber((String)((Object)number));
            return NumberUtil.toBigDecimal(number);
        }
    }

    public static BigInteger toBigInteger(Number number) {
        while (number != null) {
            if (number instanceof BigInteger) {
                return (BigInteger)number;
            }
            if (number instanceof Long) {
                return BigInteger.valueOf((Long)number);
            }
            Assert.isTrue(NumberUtil.isValidNumber(number), "Number is invalid!", new Object[0]);
            number = number.longValue();
        }
        return BigInteger.ZERO;
    }

    public static BigInteger toBigInteger(String number) {
        String string;
        if (StrUtil.isBlank(number)) {
            return BigInteger.ZERO;
        }
        return new BigInteger(string);
    }

    /*
     * WARNING - void declaration
     */
    public static int count(int total, int part) {
        void var1_1;
        int n;
        if (total % part == 0) {
            return total / part;
        }
        return n / var1_1 + 1;
    }

    @Deprecated
    public static BigDecimal null2Zero(BigDecimal decimal) {
        BigDecimal bigDecimal;
        if (decimal == null) {
            return BigDecimal.ZERO;
        }
        return bigDecimal;
    }

    public static int zero2One(int value) {
        int n;
        if (value == 0) {
            return 1;
        }
        return n;
    }

    public static int nullToZero(Integer number) {
        Integer n;
        if (number == null) {
            return 0;
        }
        return n;
    }

    public static long nullToZero(Long number) {
        Long l;
        if (number == null) {
            return 0L;
        }
        return l;
    }

    public static double nullToZero(Double number) {
        Double d;
        if (number == null) {
            return 0.0;
        }
        return d;
    }

    public static float nullToZero(Float number) {
        Float f;
        if (number == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    public static short nullToZero(Short number) {
        Short s;
        if (number == null) {
            return 0;
        }
        return s;
    }

    public static byte nullToZero(Byte number) {
        Byte by;
        if (number == null) {
            return 0;
        }
        return by;
    }

    public static BigDecimal nullToZero(BigDecimal number) {
        BigDecimal bigDecimal;
        if (number == null) {
            return BigDecimal.ZERO;
        }
        return bigDecimal;
    }

    public static BigInteger nullToZero(BigInteger number) {
        BigInteger bigInteger;
        if (number == null) {
            return BigInteger.ZERO;
        }
        return bigInteger;
    }

    /*
     * WARNING - void declaration
     */
    public static BigInteger newBigInteger(String str) {
        BigInteger bigInteger;
        void var3_3;
        void var2_2;
        if ((str = StrUtil.trimToNull(str)) == null) {
            return null;
        }
        int pos = 0;
        int radix = 10;
        boolean negate = false;
        if (str.startsWith("-")) {
            negate = true;
            pos = 1;
        }
        if (str.startsWith("0x", pos) || str.startsWith("0X", pos)) {
            radix = 16;
            pos += 2;
        } else if (str.startsWith("#", pos)) {
            radix = 16;
            ++pos;
        } else if (str.startsWith("0", pos) && str.length() > pos + 1) {
            radix = 8;
            ++pos;
        }
        if (pos > 0) {
            void var1_1;
            str = str.substring((int)var1_1);
        }
        BigInteger value = new BigInteger(str, (int)var2_2);
        if (var3_3 != false) {
            return value.negate();
        }
        return bigInteger;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isBeside(long number1, long number2) {
        void var2_1;
        return Math.abs(number1 - var2_1) == 1L;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isBeside(int number1, int number2) {
        void var1_1;
        return Math.abs(number1 - var1_1) == 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int partValue(int total, int partCount) {
        void var1_1;
        return NumberUtil.partValue(total, (int)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public static int partValue(int total, int partCount, boolean isPlusOneWhenHasRem) {
        void var3_3;
        void var1_1;
        int n;
        void var2_2;
        int partValue = total / partCount;
        if (var2_2 != false && n % var1_1 > 0) {
            ++partValue;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal pow(Number number, int n) {
        void var1_1;
        return NumberUtil.pow(NumberUtil.toBigDecimal(number), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static BigDecimal pow(BigDecimal number, int n) {
        void var1_1;
        return number.pow((int)var1_1);
    }

    public static boolean isPowerOfTwo(long n) {
        if (n > 0L) {
            long l;
            long l2 = l;
            if ((l2 & l2 - 1L) == 0L) {
                return true;
            }
        }
        return false;
    }

    public static int parseInt(String number) throws NumberFormatException {
        if (StrUtil.isBlank(number)) {
            return 0;
        }
        if (StrUtil.startWithIgnoreCase(number, "0x")) {
            return Integer.parseInt(number.substring(2), 16);
        }
        if (StrUtil.containsIgnoreCase(number, "E")) {
            throw new NumberFormatException(StrUtil.format("Unsupported int format: [{}]", number));
        }
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException numberFormatException) {
            String string;
            return NumberUtil.parseNumber(string).intValue();
        }
    }

    public static long parseLong(String number) {
        if (StrUtil.isBlank(number)) {
            return 0L;
        }
        if (number.startsWith("0x")) {
            return Long.parseLong(number.substring(2), 16);
        }
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException numberFormatException) {
            String string;
            return NumberUtil.parseNumber(string).longValue();
        }
    }

    public static float parseFloat(String number) {
        if (StrUtil.isBlank(number)) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(number);
        }
        catch (NumberFormatException numberFormatException) {
            String string;
            return NumberUtil.parseNumber(string).floatValue();
        }
    }

    public static double parseDouble(String number) {
        if (StrUtil.isBlank(number)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(number);
        }
        catch (NumberFormatException numberFormatException) {
            String string;
            return NumberUtil.parseNumber(string).doubleValue();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Number parseNumber(String numberStr) throws NumberFormatException {
        if (StrUtil.startWithIgnoreCase(numberStr, "0x")) {
            return Long.parseLong(numberStr.substring(2), 16);
        }
        if (StrUtil.startWith((CharSequence)numberStr, '+')) {
            numberStr = StrUtil.subSuf(numberStr, 1);
        }
        try {
            NumberFormat format = NumberFormat.getInstance();
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setParseBigDecimal(true);
            }
            return format.parse(numberStr);
        }
        catch (ParseException e) {
            NumberFormatException numberFormatException;
            void var1_2;
            NumberFormatException nfe = new NumberFormatException(e.getMessage());
            nfe.initCause((Throwable)var1_2);
            throw numberFormatException;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Integer parseInt(String numberStr, Integer defaultValue) {
        if (CharSequenceUtil.isBlank(numberStr)) {
            return defaultValue;
        }
        try {
            String string;
            return NumberUtil.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Long parseLong(String numberStr, Long defaultValue) {
        if (CharSequenceUtil.isBlank(numberStr)) {
            return defaultValue;
        }
        try {
            String string;
            return NumberUtil.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Float parseFloat(String numberStr, Float defaultValue) {
        if (CharSequenceUtil.isBlank(numberStr)) {
            return defaultValue;
        }
        try {
            String string;
            return Float.valueOf(NumberUtil.parseFloat(string));
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Double parseDouble(String numberStr, Double defaultValue) {
        if (CharSequenceUtil.isBlank(numberStr)) {
            return defaultValue;
        }
        try {
            String string;
            return NumberUtil.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Number parseNumber(String numberStr, Number defaultValue) {
        if (CharSequenceUtil.isBlank(numberStr)) {
            return defaultValue;
        }
        try {
            String string;
            return NumberUtil.parseNumber(string);
        }
        catch (NumberFormatException numberFormatException) {
            void var1_1;
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toBytes(int value) {
        void var1_1;
        int n;
        byte[] byArray = new byte[4];
        byte[] result = byArray;
        byArray[0] = (byte)(value >> 24);
        result[1] = (byte)(value >> 16);
        result[2] = (byte)(value >> 8);
        result[3] = (byte)n;
        return var1_1;
    }

    public static int toInt(byte[] bytes) {
        byte[] byArray;
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toUnsignedByteArray(BigInteger value) {
        Object object;
        byte[] byArray = value.toByteArray();
        Object bytes = byArray;
        if (byArray[0] == 0) {
            void var1_1;
            byte[] tmp = new byte[((Object)bytes).length - 1];
            System.arraycopy(bytes, 1, tmp, 0, tmp.length);
            return var1_1;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toUnsignedByteArray(int length, BigInteger value) {
        void var0_1;
        void var3_4;
        void var2_3;
        void var1_2;
        byte[] bytes = value.toByteArray();
        if (bytes.length == length) {
            return bytes;
        }
        int start = bytes[0] == 0 ? 1 : 0;
        int count = bytes.length - start;
        if (count > length) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] tmp = new byte[length];
        System.arraycopy(var1_2, (int)var2_3, tmp, tmp.length - count, (int)var3_4);
        return var0_1;
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf) {
        byte[] byArray;
        return new BigInteger(1, byArray);
    }

    /*
     * WARNING - void declaration
     */
    public static BigInteger fromUnsignedByteArray(byte[] buf, int off, int length) {
        void var3_3;
        byte[] mag = buf;
        if (off != 0 || length != buf.length) {
            void var2_2;
            void var1_1;
            byte[] byArray;
            mag = new byte[length];
            System.arraycopy(byArray, (int)var1_1, mag, 0, (int)var2_2);
        }
        return new BigInteger(1, (byte[])var3_3);
    }

    public static boolean isValidNumber(Number number) {
        if (number == null) {
            return false;
        }
        if (number instanceof Double) {
            return false == ((Double)number).isInfinite() && false == ((Double)number).isNaN();
        }
        if (number instanceof Float) {
            Number number2;
            return false == ((Float)number).isInfinite() && false == ((Float)number2).isNaN();
        }
        return true;
    }

    public static boolean isValid(double number) {
        double d;
        return false == (Double.isNaN(number) || Double.isInfinite(d));
    }

    public static boolean isValid(float number) {
        float f;
        return false == (Float.isNaN(number) || Float.isInfinite(f));
    }

    public static double calculate(String expression) {
        return Calculator.conversion(expression);
    }

    public static double toDouble(Number value) {
        Number number;
        if (value instanceof Float) {
            return Double.parseDouble(value.toString());
        }
        return number.doubleValue();
    }

    public static boolean isOdd(int num) {
        return (num & 1) == 1;
    }

    public static boolean isEven(int num) {
        int n;
        return false == NumberUtil.isOdd(n);
    }

    /*
     * WARNING - void declaration
     */
    private static int mathSubNode(int selectNum, int minNum) {
        void var1_1;
        int n;
        if (selectNum == minNum) {
            return 1;
        }
        int n2 = n;
        return n2 * NumberUtil.mathSubNode(n2 - 1, (int)var1_1);
    }

    private static int mathNode(int selectNum) {
        int n;
        if (selectNum == 0) {
            return 1;
        }
        int n2 = n;
        return n2 * NumberUtil.mathNode(n2 - 1);
    }
}

