/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ModifierUtil {
    /*
     * WARNING - void declaration
     */
    public static boolean hasModifier(Class<?> clazz, ModifierType ... modifierTypes) {
        void var1_1;
        Class<?> clazz2;
        if (clazz == null || ArrayUtil.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (clazz2.getModifiers() & ModifierUtil.modifiersToInt((ModifierType[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasModifier(Constructor<?> constructor, ModifierType ... modifierTypes) {
        void var1_1;
        Constructor<?> constructor2;
        if (constructor == null || ArrayUtil.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (constructor2.getModifiers() & ModifierUtil.modifiersToInt((ModifierType[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasModifier(Method method, ModifierType ... modifierTypes) {
        void var1_1;
        Method method2;
        if (method == null || ArrayUtil.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (method2.getModifiers() & ModifierUtil.modifiersToInt((ModifierType[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasModifier(Field field, ModifierType ... modifierTypes) {
        void var1_1;
        Field field2;
        if (field == null || ArrayUtil.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (field2.getModifiers() & ModifierUtil.modifiersToInt((ModifierType[])var1_1));
    }

    public static boolean isPublic(Field field) {
        return ModifierUtil.hasModifier(field, ModifierType.PUBLIC);
    }

    public static boolean isPublic(Method method) {
        return ModifierUtil.hasModifier(method, ModifierType.PUBLIC);
    }

    public static boolean isPublic(Class<?> clazz) {
        return ModifierUtil.hasModifier(clazz, ModifierType.PUBLIC);
    }

    public static boolean isPublic(Constructor<?> constructor) {
        return ModifierUtil.hasModifier(constructor, ModifierType.PUBLIC);
    }

    public static boolean isStatic(Field field) {
        return ModifierUtil.hasModifier(field, ModifierType.STATIC);
    }

    public static boolean isStatic(Method method) {
        return ModifierUtil.hasModifier(method, ModifierType.STATIC);
    }

    public static boolean isStatic(Class<?> clazz) {
        return ModifierUtil.hasModifier(clazz, ModifierType.STATIC);
    }

    public static boolean isSynthetic(Field field) {
        return field.isSynthetic();
    }

    public static boolean isSynthetic(Method method) {
        return method.isSynthetic();
    }

    public static boolean isSynthetic(Class<?> clazz) {
        return clazz.isSynthetic();
    }

    public static boolean isAbstract(Method method) {
        return ModifierUtil.hasModifier(method, ModifierType.ABSTRACT);
    }

    /*
     * WARNING - void declaration
     */
    public static void removeFinalModify(Field field) {
        if (field != null && ModifierUtil.hasModifier(field, ModifierType.FINAL)) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                Field field2 = field;
                modifiersField.setInt(field2, field2.getModifiers() & 0xFFFFFFEF);
                return;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                Field field3;
                void var1_2;
                throw new UtilException((Throwable)var1_2, "IllegalAccess for {}.{}", field.getDeclaringClass(), field3.getName());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int modifiersToInt(ModifierType ... modifierTypes) {
        void var1_1;
        int modifier = modifierTypes[0].getValue();
        for (int i = 1; i < modifierTypes.length; ++i) {
            modifier |= modifierTypes[i].getValue();
        }
        return (int)var1_1;
    }

    public static enum ModifierType {
        PUBLIC(1),
        PRIVATE(2),
        PROTECTED(4),
        STATIC(8),
        FINAL(16),
        SYNCHRONIZED(32),
        VOLATILE(64),
        TRANSIENT(128),
        NATIVE(256),
        ABSTRACT(1024),
        STRICT(2048);

        private final int value;

        /*
         * WARNING - void declaration
         */
        private ModifierType(int modifier) {
            void var3_3;
            this.value = var3_3;
        }

        public final int getValue() {
            return this.value;
        }
    }
}

