/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class IdcardUtil {
    private static final int CHINA_ID_MIN_LENGTH = 15;
    private static final int CHINA_ID_MAX_LENGTH = 18;
    private static final int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final Map<String, String> CITY_CODES = new HashMap<String, String>();
    private static final Map<Character, Integer> TW_FIRST_CODE = new HashMap<Character, Integer>();

    /*
     * WARNING - void declaration
     */
    public static String convert15To18(String idCard) {
        CharSequence charSequence;
        void var1_2;
        int sYear;
        if (idCard.length() != 15) {
            return null;
        }
        if (ReUtil.isMatch(PatternPool.NUMBERS, (CharSequence)idCard)) {
            Object object = idCard.substring(6, 12);
            sYear = DateUtil.year((Date)(object = DateUtil.parse((CharSequence)object, "yyMMdd")));
            if (sYear > 2000) {
                sYear -= 100;
            }
        } else {
            return null;
        }
        CharSequence idCard18 = StrUtil.builder().append(idCard, 0, 6).append(sYear).append(idCard.substring(8));
        char sVal = IdcardUtil.getCheckCode18(((StringBuilder)idCard18).toString());
        ((StringBuilder)idCard18).append((char)var1_2);
        return ((StringBuilder)charSequence).toString();
    }

    public static String convert18To15(String idCard) {
        String string;
        if (StrUtil.isNotBlank(idCard) && IdcardUtil.isValidCard18(idCard)) {
            return idCard.substring(0, 6) + idCard.substring(8, idCard.length() - 1);
        }
        return string;
    }

    public static boolean isValidCard(String idCard) {
        if (StrUtil.isBlank(idCard)) {
            return false;
        }
        int n = idCard.length();
        switch (n) {
            case 18: {
                return IdcardUtil.isValidCard18(idCard);
            }
            case 15: {
                return IdcardUtil.isValidCard15(idCard);
            }
            case 10: {
                String[] stringArray;
                String[] cardVal = IdcardUtil.isValidCard10(idCard);
                return cardVal != null && "true".equals(stringArray[2]);
            }
        }
        return false;
    }

    public static boolean isValidCard18(String idcard) {
        return IdcardUtil.isValidCard18(idcard, true);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isValidCard18(String idcard, boolean ignoreCase) {
        String proCode;
        if (idcard == null) {
            return false;
        }
        if (18 != idcard.length()) {
            return false;
        }
        String string = proCode = idcard.startsWith("9") ? idcard.substring(1, 3) : idcard.substring(0, 2);
        if (null == CITY_CODES.get(proCode)) {
            return false;
        }
        if (!Validator.isBirthday(idcard.substring(6, 14))) {
            return false;
        }
        String code17 = idcard.substring(0, 17);
        if (ReUtil.isMatch(PatternPool.NUMBERS, (CharSequence)code17)) {
            void var1_1;
            String string2;
            void var2_2;
            char c = IdcardUtil.getCheckCode18((String)var2_2);
            return CharUtil.equals(c, string2.charAt(17), (boolean)var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isValidCard15(String idcard) {
        if (idcard == null) {
            return false;
        }
        if (15 != idcard.length()) {
            return false;
        }
        if (ReUtil.isMatch(PatternPool.NUMBERS, (CharSequence)idcard)) {
            String string;
            void var1_1;
            String proCode = idcard.substring(0, 2);
            if (null == CITY_CODES.get(var1_1)) {
                return false;
            }
            return false != Validator.isBirthday("19" + string.substring(6, 12));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] isValidCard10(String idcard) {
        void var1_1;
        if (StrUtil.isBlank(idcard)) {
            return null;
        }
        String[] info = new String[3];
        String card = idcard.replaceAll("[()]", "");
        if (card.length() != 8 && card.length() != 9 && idcard.length() != 10) {
            return null;
        }
        if (idcard.matches("^[a-zA-Z][0-9]{9}$")) {
            void var2_3;
            info[0] = "\u53f0\u6e7e";
            char char2 = idcard.charAt(1);
            if ('1' == char2) {
                info[1] = "M";
            } else if (50 == var2_3) {
                info[1] = "F";
            } else {
                info[1] = "N";
                info[2] = "false";
                return info;
            }
            info[2] = IdcardUtil.isValidTWCard(idcard) ? "true" : "false";
        } else if (idcard.matches("^[157][0-9]{6}\\(?[0-9A-Z]\\)?$")) {
            info[0] = "\u6fb3\u95e8";
            info[1] = "N";
            info[2] = "true";
        } else if (idcard.matches("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$")) {
            String string;
            info[0] = "\u9999\u6e2f";
            info[1] = "N";
            info[2] = IdcardUtil.isValidHKCard(string) ? "true" : "false";
        } else {
            return null;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isValidTWCard(String idcard) {
        void var1_2;
        String string;
        if (idcard == null || idcard.length() != 10) {
            return false;
        }
        Integer iStart = TW_FIRST_CODE.get(Character.valueOf(idcard.charAt(0)));
        if (iStart == null) {
            return false;
        }
        int sum = iStart / 10 + iStart % 10 * 9;
        String string2 = idcard.substring(1, 9);
        char[] chars = string2.toCharArray();
        int iflag = 8;
        for (char c : chars) {
            sum += Integer.parseInt(String.valueOf(c)) * iflag;
            --iflag;
        }
        String end = string.substring(9, 10);
        return (sum % 10 == 0 ? 0 : 10 - var1_2 % 10) == Integer.parseInt(string2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isValidHKCard(String idcard) {
        void var1_1;
        String string;
        void var2_2;
        int sum;
        String card = idcard.replaceAll("[()]", "");
        if (card.length() == 9) {
            sum = (Character.toUpperCase(card.charAt(0)) - 55) * 9 + (Character.toUpperCase(card.charAt(1)) - 55 << 3);
            card = card.substring(1, 9);
        } else {
            sum = 522 + (Character.toUpperCase(card.charAt(0)) - 55 << 3);
        }
        String mid = card.substring(1, 7);
        String end = card.substring(7, 8);
        char[] chars = mid.toCharArray();
        int iflag = 7;
        for (void c : var2_2) {
            sum += Integer.parseInt(String.valueOf((char)c)) * iflag;
            --iflag;
        }
        sum = "A".equalsIgnoreCase(end) ? (sum += 10) : (sum += Integer.parseInt(string));
        return var1_1 % 11 == false;
    }

    public static String getBirthByIdCard(String idcard) {
        return IdcardUtil.getBirth(idcard);
    }

    /*
     * WARNING - void declaration
     */
    public static String getBirth(String idCard) {
        String string;
        void var1_1;
        Assert.notBlank(idCard, "id card must be not blank!", new Object[0]);
        int len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (var1_1 == 15) {
            idCard = IdcardUtil.convert15To18(idCard);
        }
        return Objects.requireNonNull(string).substring(6, 14);
    }

    public static DateTime getBirthDate(String idCard) {
        String string;
        String birthByIdCard = IdcardUtil.getBirthByIdCard(idCard);
        if (birthByIdCard == null) {
            return null;
        }
        return DateUtil.parse((CharSequence)string, DatePattern.PURE_DATE_FORMAT);
    }

    public static int getAgeByIdCard(String idcard) {
        return IdcardUtil.getAgeByIdCard(idcard, DateUtil.date());
    }

    /*
     * WARNING - void declaration
     */
    public static int getAgeByIdCard(String idcard, Date dateToCompare) {
        void var1_1;
        String string = IdcardUtil.getBirthByIdCard(idcard);
        return DateUtil.age(DateUtil.parse((CharSequence)string, "yyyyMMdd"), (Date)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Short getYearByIdCard(String idcard) {
        String string;
        void var1_1;
        int len = idcard.length();
        if (len < 15) {
            return null;
        }
        if (var1_1 == 15) {
            idcard = IdcardUtil.convert15To18(idcard);
        }
        return Short.valueOf(Objects.requireNonNull(string).substring(6, 10));
    }

    /*
     * WARNING - void declaration
     */
    public static Short getMonthByIdCard(String idcard) {
        String string;
        void var1_1;
        int len = idcard.length();
        if (len < 15) {
            return null;
        }
        if (var1_1 == 15) {
            idcard = IdcardUtil.convert15To18(idcard);
        }
        return Short.valueOf(Objects.requireNonNull(string).substring(10, 12));
    }

    /*
     * WARNING - void declaration
     */
    public static Short getDayByIdCard(String idcard) {
        String string;
        void var1_1;
        int len = idcard.length();
        if (len < 15) {
            return null;
        }
        if (var1_1 == 15) {
            idcard = IdcardUtil.convert15To18(idcard);
        }
        return Short.valueOf(Objects.requireNonNull(string).substring(12, 14));
    }

    /*
     * WARNING - void declaration
     */
    public static int getGenderByIdCard(String idcard) {
        String string;
        char c;
        void var1_2;
        Assert.notBlank(idcard);
        int len = idcard.length();
        if (len != 15 && len != 18) {
            throw new IllegalArgumentException("ID Card length must be 15 or 18");
        }
        if (var1_2 == 15) {
            idcard = IdcardUtil.convert15To18(idcard);
        }
        if ((c = Objects.requireNonNull(string).charAt(16)) % 2 != 0) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public static String getProvinceCodeByIdCard(String idcard) {
        void var1_1;
        int len = idcard.length();
        if (len == 15 || var1_1 == 18) {
            String string;
            return string.substring(0, 2);
        }
        return null;
    }

    public static String getProvinceByIdCard(String idcard) {
        String code = IdcardUtil.getProvinceCodeByIdCard(idcard);
        if (StrUtil.isNotBlank(code)) {
            String string;
            return CITY_CODES.get(string);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String getCityCodeByIdCard(String idcard) {
        void var1_1;
        int len = idcard.length();
        if (len == 15 || var1_1 == 18) {
            String string;
            return string.substring(0, 4);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String getDistrictCodeByIdCard(String idcard) {
        void var1_1;
        int len = idcard.length();
        if (len == 15 || var1_1 == 18) {
            String string;
            return string.substring(0, 6);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String hide(String idcard, int startInclude, int endExclude) {
        void var2_2;
        void var1_1;
        return StrUtil.hide(idcard, (int)var1_1, (int)var2_2);
    }

    public static Idcard getIdcardInfo(String idcard) {
        String string;
        return new Idcard(string);
    }

    private static char getCheckCode18(String code17) {
        int n = IdcardUtil.getPowerSum(code17.toCharArray());
        return IdcardUtil.getCheckCode18(n);
    }

    private static char getCheckCode18(int iSum) {
        switch (iSum % 11) {
            case 10: {
                return '2';
            }
            case 9: {
                return '3';
            }
            case 8: {
                return '4';
            }
            case 7: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 5: {
                return '7';
            }
            case 4: {
                return '8';
            }
            case 3: {
                return '9';
            }
            case 2: {
                return 'X';
            }
            case 1: {
                return '0';
            }
            case 0: {
                return '1';
            }
        }
        return ' ';
    }

    /*
     * WARNING - void declaration
     */
    private static int getPowerSum(char[] iArr) {
        void var1_1;
        int iSum = 0;
        if (POWER.length == iArr.length) {
            for (int i = 0; i < iArr.length; ++i) {
                iSum += Integer.parseInt(String.valueOf(iArr[i])) * POWER[i];
            }
        }
        return (int)var1_1;
    }

    static {
        CITY_CODES.put("11", "\u5317\u4eac");
        CITY_CODES.put("12", "\u5929\u6d25");
        CITY_CODES.put("13", "\u6cb3\u5317");
        CITY_CODES.put("14", "\u5c71\u897f");
        CITY_CODES.put("15", "\u5185\u8499\u53e4");
        CITY_CODES.put("21", "\u8fbd\u5b81");
        CITY_CODES.put("22", "\u5409\u6797");
        CITY_CODES.put("23", "\u9ed1\u9f99\u6c5f");
        CITY_CODES.put("31", "\u4e0a\u6d77");
        CITY_CODES.put("32", "\u6c5f\u82cf");
        CITY_CODES.put("33", "\u6d59\u6c5f");
        CITY_CODES.put("34", "\u5b89\u5fbd");
        CITY_CODES.put("35", "\u798f\u5efa");
        CITY_CODES.put("36", "\u6c5f\u897f");
        CITY_CODES.put("37", "\u5c71\u4e1c");
        CITY_CODES.put("41", "\u6cb3\u5357");
        CITY_CODES.put("42", "\u6e56\u5317");
        CITY_CODES.put("43", "\u6e56\u5357");
        CITY_CODES.put("44", "\u5e7f\u4e1c");
        CITY_CODES.put("45", "\u5e7f\u897f");
        CITY_CODES.put("46", "\u6d77\u5357");
        CITY_CODES.put("50", "\u91cd\u5e86");
        CITY_CODES.put("51", "\u56db\u5ddd");
        CITY_CODES.put("52", "\u8d35\u5dde");
        CITY_CODES.put("53", "\u4e91\u5357");
        CITY_CODES.put("54", "\u897f\u85cf");
        CITY_CODES.put("61", "\u9655\u897f");
        CITY_CODES.put("62", "\u7518\u8083");
        CITY_CODES.put("63", "\u9752\u6d77");
        CITY_CODES.put("64", "\u5b81\u590f");
        CITY_CODES.put("65", "\u65b0\u7586");
        CITY_CODES.put("71", "\u53f0\u6e7e");
        CITY_CODES.put("81", "\u9999\u6e2f");
        CITY_CODES.put("82", "\u6fb3\u95e8");
        CITY_CODES.put("83", "\u53f0\u6e7e");
        CITY_CODES.put("91", "\u56fd\u5916");
        TW_FIRST_CODE.put(Character.valueOf('A'), 10);
        TW_FIRST_CODE.put(Character.valueOf('B'), 11);
        TW_FIRST_CODE.put(Character.valueOf('C'), 12);
        TW_FIRST_CODE.put(Character.valueOf('D'), 13);
        TW_FIRST_CODE.put(Character.valueOf('E'), 14);
        TW_FIRST_CODE.put(Character.valueOf('F'), 15);
        TW_FIRST_CODE.put(Character.valueOf('G'), 16);
        TW_FIRST_CODE.put(Character.valueOf('H'), 17);
        TW_FIRST_CODE.put(Character.valueOf('J'), 18);
        TW_FIRST_CODE.put(Character.valueOf('K'), 19);
        TW_FIRST_CODE.put(Character.valueOf('L'), 20);
        TW_FIRST_CODE.put(Character.valueOf('M'), 21);
        TW_FIRST_CODE.put(Character.valueOf('N'), 22);
        TW_FIRST_CODE.put(Character.valueOf('P'), 23);
        TW_FIRST_CODE.put(Character.valueOf('Q'), 24);
        TW_FIRST_CODE.put(Character.valueOf('R'), 25);
        TW_FIRST_CODE.put(Character.valueOf('S'), 26);
        TW_FIRST_CODE.put(Character.valueOf('T'), 27);
        TW_FIRST_CODE.put(Character.valueOf('U'), 28);
        TW_FIRST_CODE.put(Character.valueOf('V'), 29);
        TW_FIRST_CODE.put(Character.valueOf('X'), 30);
        TW_FIRST_CODE.put(Character.valueOf('Y'), 31);
        TW_FIRST_CODE.put(Character.valueOf('W'), 32);
        TW_FIRST_CODE.put(Character.valueOf('Z'), 33);
        TW_FIRST_CODE.put(Character.valueOf('I'), 34);
        TW_FIRST_CODE.put(Character.valueOf('O'), 35);
    }

    public static class Idcard
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String provinceCode;
        private final String cityCode;
        private final DateTime birthDate;
        private final Integer gender;
        private final int age;

        /*
         * WARNING - void declaration
         */
        public Idcard(String idcard) {
            void var1_1;
            this.provinceCode = IdcardUtil.getProvinceCodeByIdCard(idcard);
            this.cityCode = IdcardUtil.getCityCodeByIdCard(idcard);
            this.birthDate = IdcardUtil.getBirthDate(idcard);
            this.gender = IdcardUtil.getGenderByIdCard(idcard);
            this.age = IdcardUtil.getAgeByIdCard((String)var1_1);
        }

        public String getProvinceCode() {
            return this.provinceCode;
        }

        public String getProvince() {
            return (String)CITY_CODES.get(this.provinceCode);
        }

        public String getCityCode() {
            return this.cityCode;
        }

        public DateTime getBirthDate() {
            return this.birthDate;
        }

        public Integer getGender() {
            return this.gender;
        }

        public int getAge() {
            return this.age;
        }

        public String toString() {
            return "Idcard{provinceCode='" + this.provinceCode + '\'' + ", cityCode='" + this.cityCode + '\'' + ", birthDate=" + this.birthDate + ", gender=" + this.gender + ", age=" + this.age + '}';
        }
    }
}

