/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.ObjectId;
import cn.hutool.core.lang.Singleton;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.lang.id.NanoId;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.RuntimeUtil;

public class IdUtil {
    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    public static String simpleUUID() {
        return UUID.randomUUID().toString(true);
    }

    public static String fastUUID() {
        return UUID.fastUUID().toString();
    }

    public static String fastSimpleUUID() {
        return UUID.fastUUID().toString(true);
    }

    public static String objectId() {
        return ObjectId.next();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static Snowflake createSnowflake(long workerId, long datacenterId) {
        void var2_1;
        long l;
        return new Snowflake(l, (long)var2_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Snowflake getSnowflake(long workerId, long datacenterId) {
        void var2_1;
        long l;
        return Singleton.get(Snowflake.class, l, (long)var2_1);
    }

    public static Snowflake getSnowflake(long workerId) {
        long l;
        return Singleton.get(Snowflake.class, l);
    }

    public static Snowflake getSnowflake() {
        return Singleton.get(Snowflake.class, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static long getDataCenterId(long maxDatacenterId) {
        void var2_1;
        Assert.isTrue(maxDatacenterId > 0L, "maxDatacenterId must be > 0", new Object[0]);
        if (maxDatacenterId == Long.MAX_VALUE) {
            --maxDatacenterId;
        }
        long id = 1L;
        byte[] mac = null;
        try {
            mac = NetUtil.getLocalHardwareAddress();
        }
        catch (UtilException utilException) {}
        if (mac != null) {
            long l;
            id = (0xFFL & (long)mac[mac.length - 2] | 0xFF00L & (long)mac[mac.length - 1] << 8) >> 6;
            id %= l + 1L;
        }
        return (long)var2_1;
    }

    /*
     * WARNING - void declaration
     */
    public static long getWorkerId(long datacenterId, long maxWorkerId) {
        void var2_1;
        long l;
        StringBuilder mpid = new StringBuilder();
        mpid.append(l);
        try {
            mpid.append(RuntimeUtil.getPid());
        }
        catch (UtilException utilException) {}
        return (long)(mpid.toString().hashCode() & 0xFFFF) % (var2_1 + 1L);
    }

    public static String nanoId() {
        return NanoId.randomNanoId();
    }

    public static String nanoId(int size) {
        return NanoId.randomNanoId(size);
    }

    public static long getSnowflakeNextId() {
        return IdUtil.getSnowflake().nextId();
    }

    public static String getSnowflakeNextIdStr() {
        return IdUtil.getSnowflake().nextIdStr();
    }
}

