/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.codec.Base16Codec;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import java.awt.Color;
import java.math.BigInteger;
import java.nio.charset.Charset;

public class HexUtil {
    /*
     * WARNING - void declaration
     */
    public static boolean isHexNumber(String value) {
        if (StrUtil.startWith((CharSequence)value, '-')) {
            return false;
        }
        int index = 0;
        if (value.startsWith("0x", 0) || value.startsWith("0X", 0)) {
            index += 2;
        } else if (value.startsWith("#", 0)) {
            ++index;
        }
        try {
            void var1_1;
            String string;
            new BigInteger(string.substring((int)var1_1), 16);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static char[] encodeHex(byte[] data) {
        return HexUtil.encodeHex(data, true);
    }

    /*
     * WARNING - void declaration
     */
    public static char[] encodeHex(String str, Charset charset) {
        void var1_1;
        return HexUtil.encodeHex(StrUtil.bytes((CharSequence)str, (Charset)var1_1), true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        byte[] byArray;
        return (toLowerCase ? Base16Codec.CODEC_LOWER : Base16Codec.CODEC_UPPER).encode(byArray);
    }

    public static String encodeHexStr(byte[] data) {
        return HexUtil.encodeHexStr(data, true);
    }

    /*
     * WARNING - void declaration
     */
    public static String encodeHexStr(String data, Charset charset) {
        void var1_1;
        return HexUtil.encodeHexStr(StrUtil.bytes((CharSequence)data, (Charset)var1_1), true);
    }

    public static String encodeHexStr(String data) {
        return HexUtil.encodeHexStr(data, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static String encodeHexStr(byte[] data, boolean toLowerCase) {
        void var1_1;
        byte[] byArray;
        return new String(HexUtil.encodeHex(byArray, (boolean)var1_1));
    }

    public static String decodeHexStr(String hexStr) {
        return HexUtil.decodeHexStr(hexStr, CharsetUtil.CHARSET_UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public static String decodeHexStr(String hexStr, Charset charset) {
        void var1_1;
        String string;
        if (StrUtil.isEmpty(hexStr)) {
            return hexStr;
        }
        return StrUtil.str(HexUtil.decodeHex(string), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String decodeHexStr(char[] hexData, Charset charset) {
        void var1_1;
        return StrUtil.str(HexUtil.decodeHex(hexData), (Charset)var1_1);
    }

    public static byte[] decodeHex(String hexStr) {
        return HexUtil.decodeHex((CharSequence)hexStr);
    }

    public static byte[] decodeHex(char[] hexData) {
        return HexUtil.decodeHex(String.valueOf(hexData));
    }

    public static byte[] decodeHex(CharSequence hexData) {
        CharSequence charSequence;
        return Base16Codec.CODEC_LOWER.decode(charSequence);
    }

    public static String encodeColor(Color color) {
        return HexUtil.encodeColor(color, "#");
    }

    /*
     * WARNING - void declaration
     */
    public static String encodeColor(Color color, String prefix) {
        void var1_1;
        void var2_2;
        Color color2;
        StringBuilder builder = new StringBuilder(prefix);
        String colorHex = Integer.toHexString(color.getRed());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        colorHex = Integer.toHexString(color.getGreen());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        colorHex = Integer.toHexString(color2.getBlue());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append((String)var2_2);
        return var1_1.toString();
    }

    public static Color decodeColor(String hexColor) {
        return Color.decode(hexColor);
    }

    /*
     * WARNING - void declaration
     */
    public static String toUnicodeHex(int value) {
        void var1_2;
        void var0_1;
        StringBuilder builder = new StringBuilder(6);
        builder.append("\\u");
        String hex = HexUtil.toHex(value);
        int len = hex.length();
        if (len < 4) {
            void var2_3;
            builder.append("0000", 0, 4 - var2_3);
        }
        builder.append((String)var0_1);
        return var1_2.toString();
    }

    public static String toUnicodeHex(char ch) {
        char c;
        return Base16Codec.CODEC_LOWER.toUnicodeHex(c);
    }

    public static String toHex(int value) {
        return Integer.toHexString(value);
    }

    public static int hexToInt(String value) {
        return Integer.parseInt(value, 16);
    }

    public static String toHex(long value) {
        return Long.toHexString(value);
    }

    public static long hexToLong(String value) {
        return Long.parseLong(value, 16);
    }

    /*
     * WARNING - void declaration
     */
    public static void appendHex(StringBuilder builder, byte b, boolean toLowerCase) {
        void var1_1;
        StringBuilder stringBuilder;
        (toLowerCase ? Base16Codec.CODEC_LOWER : Base16Codec.CODEC_UPPER).appendHex(stringBuilder, (byte)var1_1);
    }

    public static BigInteger toBigInteger(String hexStr) {
        String string;
        if (hexStr == null) {
            return null;
        }
        return new BigInteger(string, 16);
    }

    public static String format(String hexStr) {
        return HexUtil.format(hexStr, "");
    }

    /*
     * WARNING - void declaration
     */
    public static String format(String hexStr, String prefix) {
        void var3_3;
        if (prefix == null) {
            prefix = "";
        }
        int length = hexStr.length();
        StringBuilder builder = StrUtil.builder(length + length / 2 + length / 2 * prefix.length());
        builder.append(prefix).append(hexStr.charAt(0)).append(hexStr.charAt(1));
        for (int i = 2; i < length - 1; i += 2) {
            builder.append(' ').append(prefix).append(hexStr.charAt(i)).append(hexStr.charAt(i + 1));
        }
        return var3_3.toString();
    }
}

