/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.lang.hash.CityHash;
import cn.hutool.core.lang.hash.MetroHash;
import cn.hutool.core.lang.hash.MurmurHash;
import cn.hutool.core.lang.hash.Number128;

public class HashUtil {
    /*
     * WARNING - void declaration
     */
    public static int additiveHash(String key, int prime) {
        void var1_1;
        void var2_2;
        int hash = key.length();
        for (int i = 0; i < key.length(); ++i) {
            hash += key.charAt(i);
        }
        return (int)(var2_2 % var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int rotatingHash(String key, int prime) {
        void var1_1;
        void var2_2;
        int hash = key.length();
        for (int i = 0; i < key.length(); ++i) {
            hash = hash << 4 ^ hash >> 28 ^ key.charAt(i);
        }
        return (int)(var2_2 % var1_1);
    }

    public static int oneByOneHash(String key) {
        int n;
        int hash = 0;
        for (int i = 0; i < key.length(); ++i) {
            hash += key.charAt(i);
            hash += hash << 10;
            hash ^= hash >> 6;
        }
        int n2 = hash;
        hash = n2 + (n2 << 3);
        hash ^= hash >> 11;
        n = hash + (n << 15);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static int bernstein(String key) {
        void var1_1;
        int hash = 0;
        for (int i = 0; i < key.length(); ++i) {
            hash = hash * 33 + key.charAt(i);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int universal(char[] key, int mask, int[] tab) {
        void var1_1;
        void var3_3;
        int hash = key.length;
        int len = key.length;
        for (int i = 0; i < len << 3; i += 8) {
            char k = key[i >> 3];
            if ((k & '\u0001') == 0) {
                hash ^= tab[i];
            }
            if ((k & 2) == 0) {
                hash ^= tab[i + 1];
            }
            if ((k & 4) == 0) {
                hash ^= tab[i + 2];
            }
            if ((k & 8) == 0) {
                hash ^= tab[i + 3];
            }
            if ((k & 0x10) == 0) {
                hash ^= tab[i + 4];
            }
            if ((k & 0x20) == 0) {
                hash ^= tab[i + 5];
            }
            if ((k & 0x40) == 0) {
                hash ^= tab[i + 6];
            }
            if ((k & 0x80) != 0) continue;
            hash ^= tab[i + 7];
        }
        return var3_3 & var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int zobrist(char[] key, int mask, int[][] tab) {
        void var1_1;
        void var3_3;
        int hash = key.length;
        for (int i = 0; i < key.length; ++i) {
            hash ^= tab[i][key[i]];
        }
        return var3_3 & var1_1;
    }

    public static int fnvHash(byte[] data) {
        int n;
        byte[] byArray;
        int hash = -2128831035;
        for (byte b : byArray) {
            hash = (hash ^ b) * 16777619;
        }
        int n2 = hash;
        hash = n2 + (n2 << 13);
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        n = hash + (n << 5);
        return Math.abs(n);
    }

    public static int fnvHash(String data) {
        int n;
        int hash = -2128831035;
        for (int i = 0; i < data.length(); ++i) {
            hash = (hash ^ data.charAt(i)) * 16777619;
        }
        int n2 = hash;
        hash = n2 + (n2 << 13);
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        n = hash + (n << 5);
        return Math.abs(n);
    }

    public static int intHash(int key) {
        int n;
        int n2 = key;
        key = n2 + ~(n2 << 15);
        key ^= key >>> 10;
        key += key << 3;
        key ^= key >>> 6;
        key += ~(key << 11);
        n = key ^ n >>> 16;
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static int rsHash(String str) {
        void var2_2;
        int a = 63689;
        int hash = 0;
        for (int i = 0; i < str.length(); ++i) {
            hash = hash * a + str.charAt(i);
            a *= 378551;
        }
        return var2_2 & Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public static int jsHash(String str) {
        void var1_1;
        int hash = 1315423911;
        for (int i = 0; i < str.length(); ++i) {
            int n = hash;
            hash = n ^ (n << 5) + str.charAt(i) + (hash >> 2);
        }
        return Math.abs((int)var1_1) & Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public static int pjwHash(String str) {
        void var1_1;
        int cfr_ignored_0 = 96 / 4;
        int cfr_ignored_1 = 32 / 8;
        int hash = 0;
        for (int i = 0; i < str.length(); ++i) {
            void var2_3;
            int test = (hash = (hash << 4) + str.charAt(i)) & 0xF0000000;
            if (test == 0) continue;
            hash = (hash ^ var2_3 >> 24) & 0xFFFFFFF;
        }
        return var1_1 & Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public static int elfHash(String str) {
        void var1_1;
        int hash = 0;
        for (int i = 0; i < str.length(); ++i) {
            void var2_3;
            int x = (int)((long)(hash = (hash << 4) + str.charAt(i)) & 0xF0000000L);
            if (x == 0) continue;
            hash ^= x >> 24;
            hash &= ~var2_3;
        }
        return var1_1 & Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public static int bkdrHash(String str) {
        void var1_1;
        int hash = 0;
        for (int i = 0; i < str.length(); ++i) {
            hash = hash * 131 + str.charAt(i);
        }
        return var1_1 & Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public static int sdbmHash(String str) {
        void var1_1;
        int hash = 0;
        for (int i = 0; i < str.length(); ++i) {
            hash = str.charAt(i) + (hash << 6) + (hash << 16) - hash;
        }
        return var1_1 & Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public static int djbHash(String str) {
        void var1_1;
        int hash = 5381;
        for (int i = 0; i < str.length(); ++i) {
            hash = (hash << 5) + hash + str.charAt(i);
        }
        return var1_1 & Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public static int dekHash(String str) {
        void var1_1;
        int hash = str.length();
        for (int i = 0; i < str.length(); ++i) {
            hash = hash << 5 ^ hash >> 27 ^ str.charAt(i);
        }
        return var1_1 & Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public static int apHash(String str) {
        void var1_1;
        int hash = 0;
        for (int i = 0; i < str.length(); ++i) {
            hash ^= (i & 1) == 0 ? hash << 7 ^ str.charAt(i) ^ hash >> 3 : ~(hash << 11 ^ str.charAt(i) ^ hash >> 5);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static long tianlHash(String str) {
        void var1_2;
        int iLength = str.length();
        if (iLength == 0) {
            return 0L;
        }
        long hash = iLength <= 256 ? 0x1000000L * (long)(iLength - 1) : 0xFF000000L;
        if (iLength <= 96) {
            for (int i = 1; i <= iLength; ++i) {
                char ucChar = str.charAt(i - 1);
                if (ucChar <= 'Z' && ucChar >= 'A') {
                    ucChar = (char)(ucChar + 32);
                }
                hash += (3L * (long)i * (long)ucChar * (long)ucChar + 5L * (long)i * (long)ucChar + 7L * (long)i + (long)(ucChar * 11)) % 0x1000000L;
            }
        } else {
            for (int i = 1; i <= 96; ++i) {
                char ucChar = str.charAt(i + iLength - 96 - 1);
                if (ucChar <= 'Z' && ucChar >= 'A') {
                    ucChar = (char)(ucChar + 32);
                }
                hash += (3L * (long)i * (long)ucChar * (long)ucChar + 5L * (long)i * (long)ucChar + 7L * (long)i + (long)(ucChar * 11)) % 0x1000000L;
            }
        }
        if (hash < 0L) {
            hash = -hash;
        }
        return (long)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int javaDefaultHash(String str) {
        void var1_1;
        int h = 0;
        int off = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            h = h * 31 + str.charAt(off++);
        }
        return (int)var1_1;
    }

    public static long mixHash(String str) {
        String string;
        long l = str.hashCode();
        l <<= 32;
        return l |= (long)HashUtil.fnvHash(string);
    }

    public static int identityHashCode(Object obj) {
        return System.identityHashCode(obj);
    }

    public static int murmur32(byte[] data) {
        return MurmurHash.hash32(data);
    }

    public static long murmur64(byte[] data) {
        return MurmurHash.hash64(data);
    }

    public static long[] murmur128(byte[] data) {
        return MurmurHash.hash128(data);
    }

    public static int cityHash32(byte[] data) {
        return CityHash.hash32(data);
    }

    /*
     * WARNING - void declaration
     */
    public static long cityHash64(byte[] data, long seed) {
        void var1_1;
        return CityHash.hash64(data, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long cityHash64(byte[] data, long seed0, long seed1) {
        void var3_2;
        void var1_1;
        return CityHash.hash64(data, (long)var1_1, (long)var3_2);
    }

    public static long cityHash64(byte[] data) {
        return CityHash.hash64(data);
    }

    public static long[] cityHash128(byte[] data) {
        return CityHash.hash128(data).getLongArray();
    }

    /*
     * WARNING - void declaration
     */
    public static long[] cityHash128(byte[] data, Number128 seed) {
        void var1_1;
        return CityHash.hash128(data, (Number128)var1_1).getLongArray();
    }

    /*
     * WARNING - void declaration
     */
    public static long metroHash64(byte[] data, long seed) {
        void var1_1;
        return MetroHash.hash64(data, (long)var1_1);
    }

    public static long metroHash64(byte[] data) {
        return MetroHash.hash64(data);
    }

    /*
     * WARNING - void declaration
     */
    public static long[] metroHash128(byte[] data, long seed) {
        void var1_1;
        return MetroHash.hash128(data, (long)var1_1).getLongArray();
    }

    public static long[] metroHash128(byte[] data) {
        return MetroHash.hash128(data).getLongArray();
    }

    /*
     * WARNING - void declaration
     */
    public static long hfHash(String data) {
        void var2_2;
        int length = data.length();
        long hash = 0L;
        for (int i = 0; i < length; ++i) {
            hash += (long)data.charAt(i) * 3L * (long)i;
        }
        if (hash < 0L) {
            hash = -hash;
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static long hfIpHash(String data) {
        void var2_2;
        int length = data.length();
        long hash = 0L;
        for (int i = 0; i < length; ++i) {
            hash += (long)(data.charAt(i % 4) ^ data.charAt(i));
        }
        return (long)var2_2;
    }
}

