/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.lang.Filter;
import cn.hutool.core.text.escape.Html4Escape;
import cn.hutool.core.text.escape.Html4Unescape;
import cn.hutool.core.text.escape.XmlEscape;
import cn.hutool.core.text.escape.XmlUnescape;
import cn.hutool.core.util.StrUtil;

public class EscapeUtil {
    private static final String NOT_ESCAPE_CHARS = "*@-_+./";
    private static final Filter<Character> JS_ESCAPE_FILTER = c -> {
        Character c2;
        return false == (Character.isDigit(c.charValue()) || Character.isLowerCase(c.charValue()) || Character.isUpperCase(c.charValue()) || StrUtil.contains((CharSequence)NOT_ESCAPE_CHARS, c2.charValue()));
    };

    public static String escapeXml(CharSequence xml) {
        CharSequence charSequence;
        XmlEscape xmlEscape = new XmlEscape();
        return xmlEscape.replace(charSequence).toString();
    }

    public static String unescapeXml(CharSequence xml) {
        CharSequence charSequence;
        XmlUnescape xmlUnescape = new XmlUnescape();
        return xmlUnescape.replace(charSequence).toString();
    }

    public static String escapeHtml4(CharSequence html) {
        CharSequence charSequence;
        Html4Escape html4Escape = new Html4Escape();
        return html4Escape.replace(charSequence).toString();
    }

    public static String unescapeHtml4(CharSequence html) {
        CharSequence charSequence;
        Html4Unescape html4Unescape = new Html4Unescape();
        return html4Unescape.replace(charSequence).toString();
    }

    public static String escape(CharSequence content) {
        return EscapeUtil.escape(content, JS_ESCAPE_FILTER);
    }

    public static String escapeAll(CharSequence content) {
        return EscapeUtil.escape(content, c -> true);
    }

    /*
     * WARNING - void declaration
     */
    public static String escape(CharSequence content, Filter<Character> filter) {
        void var2_2;
        if (StrUtil.isEmpty(content)) {
            return StrUtil.str(content);
        }
        StringBuilder tmp = new StringBuilder(content.length() * 6);
        for (int i = 0; i < content.length(); ++i) {
            void var3_4;
            char c = content.charAt(i);
            if (!filter.accept(Character.valueOf(c))) {
                tmp.append(c);
                continue;
            }
            if (c < '\u0100') {
                tmp.append("%");
                if (c < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(c, 16));
                continue;
            }
            tmp.append("%u");
            if (c <= '\u0fff') {
                tmp.append("0");
            }
            tmp.append(Integer.toString((int)var3_4, 16));
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String unescape(String content) {
        void var1_1;
        if (StrUtil.isBlank(content)) {
            return content;
        }
        StringBuilder tmp = new StringBuilder(content.length());
        int lastPos = 0;
        while (lastPos < content.length()) {
            void var3_3;
            int n;
            int pos = content.indexOf("%", lastPos);
            if (pos == lastPos) {
                int ch;
                if (content.charAt(pos + 1) == 'u') {
                    ch = Integer.parseInt(content.substring(pos + 2, pos + 6), 16);
                    tmp.append((char)ch);
                    ch = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(content.substring(pos + 1, pos + 3), 16);
                tmp.append((char)n);
                n = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(content.substring(n));
                n = content.length();
                continue;
            }
            tmp.append(content, n, pos);
            n = var3_3;
        }
        return var1_1.toString();
    }

    public static String safeUnescape(String content) {
        try {
            return EscapeUtil.unescape(content);
        }
        catch (Exception exception) {
            String string;
            return string;
        }
    }
}

