/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.func.Func1;
import cn.hutool.core.lang.func.LambdaUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class EnumUtil {
    public static boolean isEnum(Class<?> clazz) {
        Class<?> clazz2;
        Assert.notNull(clazz);
        return clazz2.isEnum();
    }

    public static boolean isEnum(Object obj) {
        Object object;
        Assert.notNull(obj);
        return object.getClass().isEnum();
    }

    public static String toString(Enum<?> e) {
        if (e != null) {
            Enum<?> enum_;
            return enum_.name();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E getEnumAt(Class<E> enumClass, int index) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        if (index >= 0 && index < enumConstants.length) {
            void var1_1;
            Enum[] enumArray;
            return (E)enumArray[var1_1];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E fromString(Class<E> enumClass, String value) {
        void var1_1;
        return Enum.valueOf(enumClass, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E fromString(Class<E> enumClass, String value, E defaultValue) {
        void var2_2;
        void var1_1;
        return (E)((Enum)ObjectUtil.defaultIfNull(EnumUtil.fromStringQuietly(enumClass, (String)var1_1), var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E fromStringQuietly(Class<E> enumClass, String value) {
        if (enumClass == null || StrUtil.isBlank(value)) {
            return null;
        }
        try {
            void var1_1;
            Class<E> clazz;
            return EnumUtil.fromString(clazz, (String)var1_1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static <E extends Enum<E>> E likeValueOf(Class<E> enumClass, Object value) {
        if (value instanceof CharSequence) {
            value = value.toString().trim();
        }
        Field[] fields = ReflectUtil.getFields(enumClass);
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        Field[] fieldArray = fields;
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            Enum[] enumArray;
            Field field = fieldArray[i];
            String fieldName = field.getName();
            if (field.getType().isEnum() || "ENUM$VALUES".equals(fieldName) || "ordinal".equals(enumArray)) continue;
            enumArray = enums;
            int n2 = enums.length;
            for (int j = 0; j < n2; ++j) {
                Enum enumObj = enumArray[j];
                if (!ObjectUtil.equal(value, ReflectUtil.getFieldValue((Object)enumObj, field))) continue;
                return (E)enumObj;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getNames(Class<? extends Enum<?>> clazz) {
        void var1_1;
        Enum<?>[] enumArray;
        Enum<?>[] enums = clazz.getEnumConstants();
        if (enums == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(enums.length);
        for (Enum<?> e : enumArray) {
            list.add(e.name());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Object> getFieldValues(Class<? extends Enum<?>> clazz, String fieldName) {
        void var2_2;
        Enum<?>[] enumArray;
        Enum<?>[] enums = clazz.getEnumConstants();
        if (enums == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(enums.length);
        for (Enum<?> e : enumArray) {
            list.add(ReflectUtil.getFieldValue(e, fieldName));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> getFieldNames(Class<? extends Enum<?>> clazz) {
        void var1_1;
        ArrayList<Object> names = new ArrayList<Object>();
        Field[] fieldArray = clazz = ReflectUtil.getFields(clazz);
        int n = clazz.length;
        for (int i = 0; i < n; ++i) {
            String string;
            Field field = fieldArray[i];
            String name = field.getName();
            if (field.getType().isEnum() || name.contains("$VALUES") || "ordinal".equals(name) || names.contains(name)) continue;
            names.add(string);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> E getBy(Class<E> enumClass, Predicate<? super E> predicate) {
        void var1_1;
        return (E)((Enum)Arrays.stream(enumClass.getEnumConstants()).filter((Predicate<E>)var1_1).findFirst().orElse(null));
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>, C> E getBy(Func1<E, C> condition, C value) {
        void var1_1;
        Func1 func1;
        void var2_2;
        Class<E> implClass = LambdaUtil.getRealClass(condition);
        if (Enum.class.equals(implClass)) {
            implClass = LambdaUtil.getRealClass(condition);
        }
        return (E)((Enum)Arrays.stream(var2_2.getEnumConstants()).filter(e -> {
            void var1_1;
            void var2_2;
            return func1.callWithRuntimeException(var2_2).equals(var1_1);
        }).findAny().orElse(null));
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>, C> E getBy(Func1<E, C> condition, C value, E defaultEnum) {
        void var2_2;
        void var1_1;
        return (E)((Enum)ObjectUtil.defaultIfNull(EnumUtil.getBy(condition, var1_1), var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>, F, C> F getFieldBy(Func1<E, F> field, Function<E, C> condition, C value) {
        Func1<E, F> func1;
        void var2_2;
        void var1_1;
        void var3_3;
        Class<E> implClass = LambdaUtil.getRealClass(field);
        if (Enum.class.equals(implClass)) {
            implClass = LambdaUtil.getRealClass(field);
        }
        return Arrays.stream(var3_3.getEnumConstants()).filter(arg_0 -> EnumUtil.lambda$getFieldBy$1((Function)var1_1, var2_2, arg_0)).findFirst().map(func1::callWithRuntimeException).orElse(null);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> LinkedHashMap<String, E> getEnumMap(Class<E> enumClass) {
        void var1_1;
        Enum[] enumArray;
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        for (Enum e : (Enum[])enumArray.getEnumConstants()) {
            map.put(e.name(), e);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> getNameFieldMap(Class<? extends Enum<?>> clazz, String fieldName) {
        void var2_2;
        Enum<?>[] enumArray;
        Enum<?>[] enums = clazz.getEnumConstants();
        if (enums == null) {
            return null;
        }
        HashMap<String, Object> map = MapUtil.newHashMap(enums.length, true);
        for (Enum<?> e : enumArray) {
            map.put(e.name(), ReflectUtil.getFieldValue(e, fieldName));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> boolean contains(Class<E> enumClass, String val) {
        void var1_1;
        return EnumUtil.getEnumMap(enumClass).containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> boolean notContains(Class<E> enumClass, String val) {
        void var1_1;
        Class<E> clazz;
        return false == EnumUtil.contains(clazz, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equalsIgnoreCase(Enum<?> e, String val) {
        void var1_1;
        return StrUtil.equalsIgnoreCase(EnumUtil.toString(e), (CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(Enum<?> e, String val) {
        void var1_1;
        return StrUtil.equals(EnumUtil.toString(e), (CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$getFieldBy$1(Function condition, Object value, Enum e) {
        void var1_1;
        void var2_2;
        return condition.apply(var2_2).equals(var1_1);
    }
}

