/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.map.SafeConcurrentHashMap;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Map;
import java.util.regex.Pattern;

public class CreditCodeUtil {
    public static final Pattern CREDIT_CODE_PATTERN = PatternPool.CREDIT_CODE;
    private static final int[] WEIGHT = new int[]{1, 3, 9, 27, 19, 26, 16, 17, 20, 29, 25, 13, 8, 24, 10, 30, 28};
    private static final char[] BASE_CODE_ARRAY = "0123456789ABCDEFGHJKLMNPQRTUWXY".toCharArray();
    private static final Map<Character, Integer> CODE_INDEX_MAP = new SafeConcurrentHashMap<Character, Integer>(BASE_CODE_ARRAY.length);

    public static boolean isCreditCodeSimple(CharSequence creditCode) {
        CharSequence charSequence;
        if (StrUtil.isBlank(creditCode)) {
            return false;
        }
        return ReUtil.isMatch(CREDIT_CODE_PATTERN, charSequence);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isCreditCode(CharSequence creditCode) {
        void var1_1;
        CharSequence charSequence;
        if (!CreditCodeUtil.isCreditCodeSimple(creditCode)) {
            return false;
        }
        int parityBit = CreditCodeUtil.getParityBit(creditCode);
        if (parityBit < 0) {
            return false;
        }
        return charSequence.charAt(17) == BASE_CODE_ARRAY[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public static String randomCreditCode() {
        void var1_2;
        void var0;
        int num;
        int i;
        StringBuilder buf = new StringBuilder(18);
        for (i = 0; i < 2; ++i) {
            num = RandomUtil.randomInt(BASE_CODE_ARRAY.length - 1);
            buf.append(Character.toUpperCase(BASE_CODE_ARRAY[num]));
        }
        for (i = 2; i < 8; ++i) {
            num = RandomUtil.randomInt(10);
            buf.append(BASE_CODE_ARRAY[num]);
        }
        for (i = 8; i < 17; ++i) {
            void var2_3;
            num = RandomUtil.randomInt(BASE_CODE_ARRAY.length - 1);
            buf.append(BASE_CODE_ARRAY[var2_3]);
        }
        String code = var0.toString();
        return code + BASE_CODE_ARRAY[CreditCodeUtil.getParityBit((CharSequence)var1_2)];
    }

    /*
     * WARNING - void declaration
     */
    private static int getParityBit(CharSequence creditCode) {
        void var3_2;
        void var1_1;
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            void var2_3;
            Integer codeIndex = CODE_INDEX_MAP.get(Character.valueOf(creditCode.charAt(i)));
            if (codeIndex == null) {
                return -1;
            }
            sum += var2_3.intValue() * WEIGHT[i];
        }
        int result = 31 - var1_1 % 31;
        if (result == 31) {
            return 0;
        }
        return (int)var3_2;
    }

    static {
        for (int i = 0; i < BASE_CODE_ARRAY.length; ++i) {
            CODE_INDEX_MAP.put(Character.valueOf(BASE_CODE_ARRAY[i]), i);
        }
    }
}

