/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import java.io.Serializable;
import java.util.Objects;

public class CoordinateUtil {
    public static final double X_PI = 52.35987755982988;
    public static final double PI = Math.PI;
    public static final double RADIUS = 6378245.0;
    public static final double CORRECTION_PARAM = 0.006693421622965943;

    /*
     * WARNING - void declaration
     */
    public static boolean outOfChina(double lng, double lat) {
        void var2_1;
        double d;
        return lng < 72.004 || d > 137.8347 || lat < 0.8293 || var2_1 > 55.8271;
    }

    /*
     * WARNING - void declaration
     */
    public static Coordinate wgs84ToGcj02(double lng, double lat) {
        void var2_1;
        double d;
        return new Coordinate(lng, lat).offset(CoordinateUtil.offset(d, (double)var2_1, true));
    }

    /*
     * WARNING - void declaration
     */
    public static Coordinate wgs84ToBd09(double lng, double lat) {
        void var0_1;
        void var2_2;
        Coordinate gcj02 = CoordinateUtil.wgs84ToGcj02(lng, (double)var2_2);
        return CoordinateUtil.gcj02ToBd09(gcj02.lng, ((Coordinate)var0_1).lat);
    }

    /*
     * WARNING - void declaration
     */
    public static Coordinate gcj02ToWgs84(double lng, double lat) {
        void var2_1;
        double d;
        return new Coordinate(lng, lat).offset(CoordinateUtil.offset(d, (double)var2_1, false));
    }

    /*
     * WARNING - void declaration
     */
    public static Coordinate gcj02ToBd09(double lng, double lat) {
        double d;
        void var2_1;
        double d2 = lng;
        double d3 = lat;
        double z = Math.sqrt(d2 * d2 + d3 * d3) + 2.0E-5 * Math.sin(lat * 52.35987755982988);
        double theta = Math.atan2((double)var2_1, lng) + 3.0E-6 * Math.cos(d * 52.35987755982988);
        double bd_lng = z * Math.cos(theta) + 0.0065;
        double bd_lat = z * Math.sin(theta) + 0.006;
        return new Coordinate(bd_lng, bd_lat);
    }

    /*
     * WARNING - void declaration
     */
    public static Coordinate bd09ToGcj02(double lng, double lat) {
        void var2_1;
        double x = lng - 0.0065;
        void y = var2_1 - 0.006;
        double d = x;
        void v1 = y;
        double z = Math.sqrt(d * d + v1 * v1) - 2.0E-5 * Math.sin((double)(y * 52.35987755982988));
        double theta = Math.atan2((double)y, x) - 3.0E-6 * Math.cos(x * 52.35987755982988);
        double gg_lng = z * Math.cos(theta);
        double gg_lat = z * Math.sin(theta);
        return new Coordinate(gg_lng, gg_lat);
    }

    /*
     * WARNING - void declaration
     */
    public static Coordinate bd09toWgs84(double lng, double lat) {
        void var0_1;
        void var2_2;
        Coordinate gcj02 = CoordinateUtil.bd09ToGcj02(lng, (double)var2_2);
        return CoordinateUtil.gcj02ToWgs84(gcj02.lng, ((Coordinate)var0_1).lat);
    }

    /*
     * WARNING - void declaration
     */
    public static Coordinate wgs84ToMercator(double lng, double lat) {
        void var2_1;
        double x = lng * 2.0037508342789244E7 / 180.0;
        double d = Math.log(Math.tan((double)((var2_1 + 90.0) * Math.PI / 360.0))) / (Math.PI / 180);
        double y = d * 2.0037508342789244E7 / 180.0;
        return new Coordinate(x, y);
    }

    /*
     * WARNING - void declaration
     */
    public static Coordinate mercatorToWgs84(double mercatorX, double mercatorY) {
        void var2_1;
        double x = mercatorX / 2.0037508342789244E7 * 180.0;
        double y = var2_1 / 2.0037508342789244E7 * 180.0;
        y = 57.29577951308232 * (2.0 * Math.atan(Math.exp((double)(y * Math.PI / 180.0))) - 1.5707963267948966);
        return new Coordinate(x, y);
    }

    /*
     * WARNING - void declaration
     */
    private static Coordinate offset(double lng, double lat, boolean isPlus) {
        void var2_2;
        double d;
        double dlng = CoordinateUtil.transLng(lng - 105.0, lat - 35.0);
        double dlat = CoordinateUtil.transLat(d - 105.0, lat - 35.0);
        double magic = Math.sin(lat / 180.0 * Math.PI);
        magic = 1.0 - magic * 0.006693421622965943 * magic;
        double sqrtMagic = Math.sqrt(magic);
        dlng = dlng * 180.0 / (6378245.0 / sqrtMagic * Math.cos((double)(var2_2 / 180.0 * Math.PI)) * Math.PI);
        dlat = dlat * 180.0 / (6335552.717000426 / (magic * sqrtMagic) * Math.PI);
        if (!isPlus) {
            dlng = -dlng;
            dlat = -dlat;
        }
        return new Coordinate(dlng, dlat);
    }

    /*
     * WARNING - void declaration
     */
    private static double transLng(double lng, double lat) {
        double d;
        void var2_1;
        double d2 = lng + 300.0 + lat * 2.0 + lng * 0.1 * lng + lng * 0.1 * var2_1 + 0.1 * Math.sqrt(Math.abs(lng));
        d2 += (20.0 * Math.sin(lng * 6.0 * Math.PI) + 20.0 * Math.sin(lng * 2.0 * Math.PI)) * 2.0 / 3.0;
        d2 += (20.0 * Math.sin(lng * Math.PI) + 40.0 * Math.sin(lng / 3.0 * Math.PI)) * 2.0 / 3.0;
        return d2 += (150.0 * Math.sin(lng / 12.0 * Math.PI) + 300.0 * Math.sin(d / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    /*
     * WARNING - void declaration
     */
    private static double transLat(double lng, double lat) {
        void var2_1;
        double d;
        double d2 = -100.0 + lng * 2.0 + lat * 3.0 + lat * 0.2 * lat + lng * 0.1 * lat + 0.2 * Math.sqrt(Math.abs(lng));
        d2 += (20.0 * Math.sin(lng * 6.0 * Math.PI) + 20.0 * Math.sin(d * 2.0 * Math.PI)) * 2.0 / 3.0;
        d2 += (20.0 * Math.sin(lat * Math.PI) + 40.0 * Math.sin(lat / 3.0 * Math.PI)) * 2.0 / 3.0;
        return d2 += (160.0 * Math.sin(lat / 12.0 * Math.PI) + 320.0 * Math.sin((double)(var2_1 * Math.PI / 30.0))) * 2.0 / 3.0;
    }

    public static class Coordinate
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private double lng;
        private double lat;

        /*
         * WARNING - void declaration
         */
        public Coordinate(double lng, double lat) {
            void var3_2;
            void var1_1;
            this.lng = var1_1;
            this.lat = var3_2;
        }

        public double getLng() {
            return this.lng;
        }

        /*
         * WARNING - void declaration
         */
        public Coordinate setLng(double lng) {
            void var1_1;
            this.lng = var1_1;
            return this;
        }

        public double getLat() {
            return this.lat;
        }

        /*
         * WARNING - void declaration
         */
        public Coordinate setLat(double lat) {
            void var1_1;
            this.lat = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Coordinate offset(Coordinate offset) {
            void var1_1;
            this.lng += offset.lng;
            this.lat += var1_1.lat;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            void var1_1;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Coordinate that = (Coordinate)o;
            return Double.compare(that.lng, this.lng) == 0 && Double.compare(var1_1.lat, this.lat) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.lng, this.lat);
        }

        public String toString() {
            return "Coordinate{lng=" + this.lng + ", lat=" + this.lat + '}';
        }
    }
}

