/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.bean.NullWrapperBean;
import cn.hutool.core.convert.BasicType;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.ClassScanner;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.Singleton;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import cn.hutool.core.util.URLUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ClassUtil {
    public static <T> Class<T> getClass(T obj) {
        T t;
        if (obj == null) {
            return null;
        }
        return t.getClass();
    }

    public static Class<?> getEnclosingClass(Class<?> clazz) {
        Class<?> clazz2;
        if (clazz == null) {
            return null;
        }
        return clazz2.getEnclosingClass();
    }

    public static boolean isTopLevelClass(Class<?> clazz) {
        Class<?> clazz2;
        if (clazz == null) {
            return false;
        }
        return null == ClassUtil.getEnclosingClass(clazz2);
    }

    /*
     * WARNING - void declaration
     */
    public static String getClassName(Object obj, boolean isSimple) {
        void var1_1;
        Class<?> clazz;
        if (obj == null) {
            return null;
        }
        clazz = clazz.getClass();
        return ClassUtil.getClassName(clazz, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String getClassName(Class<?> clazz, boolean isSimple) {
        Class<?> clazz2;
        void var1_1;
        if (clazz == null) {
            return null;
        }
        if (var1_1 != false) {
            return clazz.getSimpleName();
        }
        return clazz2.getName();
    }

    /*
     * WARNING - void declaration
     */
    public static String getShortClassName(String className) {
        void var2_3;
        void var0_1;
        void var1_2;
        List<String> packages = StrUtil.split((CharSequence)className, '.');
        if (packages == null || packages.size() < 2) {
            return className;
        }
        int size = packages.size();
        StringBuilder result = StrUtil.builder();
        result.append(packages.get(0).charAt(0));
        for (int i = 1; i < size - 1; ++i) {
            result.append('.').append(packages.get(i).charAt(0));
        }
        result.append('.').append((String)var1_2.get((int)(var0_1 - true)));
        return var2_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?>[] getClasses(Object ... objects) {
        void var1_1;
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            void var2_3;
            Object obj = objects[i];
            classes[i] = obj instanceof NullWrapperBean ? ((NullWrapperBean)obj).getWrappedClass() : (obj == null ? Object.class : var2_3.getClass());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(Class<?> clazz, String className, boolean ignoreCase) {
        Class<?> clazz2;
        void var1_1;
        void var2_2;
        if (clazz == null || StrUtil.isBlank(className)) {
            return false;
        }
        if (var2_2 != false) {
            return className.equalsIgnoreCase(clazz.getName()) || className.equalsIgnoreCase(clazz.getSimpleName());
        }
        return className.equals(clazz.getName()) || var1_1.equals(clazz2.getSimpleName());
    }

    /*
     * WARNING - void declaration
     */
    public static Set<Class<?>> scanPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        void var1_1;
        return ClassScanner.scanPackageByAnnotation(packageName, (Class<? extends Annotation>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Set<Class<?>> scanPackageBySuper(String packageName, Class<?> superClass) {
        void var1_1;
        return ClassScanner.scanPackageBySuper(packageName, var1_1);
    }

    public static Set<Class<?>> scanPackage() {
        return ClassScanner.scanPackage();
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassScanner.scanPackage(packageName);
    }

    /*
     * WARNING - void declaration
     */
    public static Set<Class<?>> scanPackage(String packageName, Filter<Class<?>> classFilter) {
        void var1_1;
        return ClassScanner.scanPackage(packageName, var1_1);
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        return ReflectUtil.getPublicMethodNames(clazz);
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return ReflectUtil.getPublicMethods(clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Method> getPublicMethods(Class<?> clazz, Filter<Method> filter) {
        void var1_1;
        return ReflectUtil.getPublicMethods(clazz, (Filter<Method>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Method> getPublicMethods(Class<?> clazz, Method ... excludeMethods) {
        void var1_1;
        return ReflectUtil.getPublicMethods(clazz, (Method[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Method> getPublicMethods(Class<?> clazz, String ... excludeMethodNames) {
        void var1_1;
        return ReflectUtil.getPublicMethods(clazz, (String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        void var2_2;
        void var1_1;
        return ReflectUtil.getPublicMethod(clazz, (String)var1_1, var2_2);
    }

    public static Set<String> getDeclaredMethodNames(Class<?> clazz) {
        return ReflectUtil.getMethodNames(clazz);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return ReflectUtil.getMethods(clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static Method getDeclaredMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        void var2_2;
        void var1_1;
        return ClassUtil.getDeclaredMethod(obj.getClass(), (String)var1_1, ClassUtil.getClasses((Object[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws SecurityException {
        void var2_2;
        void var1_1;
        return ReflectUtil.getMethod(clazz, (String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static Field getDeclaredField(Class<?> clazz, String fieldName) throws SecurityException {
        if (clazz == null || StrUtil.isBlank(fieldName)) {
            return null;
        }
        try {
            void var1_1;
            Class<?> clazz2;
            return clazz2.getDeclaredField((String)var1_1);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field[] getDeclaredFields(Class<?> clazz) throws SecurityException {
        Class<?> clazz2;
        if (clazz == null) {
            return null;
        }
        return clazz2.getDeclaredFields();
    }

    public static Set<String> getClassPathResources() {
        return ClassUtil.getClassPathResources(false);
    }

    public static Set<String> getClassPathResources(boolean isDecode) {
        boolean bl;
        return ClassUtil.getClassPaths("", bl);
    }

    public static Set<String> getClassPaths(String packageName) {
        return ClassUtil.getClassPaths(packageName, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Set<String> getClassPaths(String packageName, boolean isDecode) {
        void var3_4;
        Enumeration<URL> resources;
        String packagePath = packageName.replace(".", "/");
        try {
            resources = ClassUtil.getClassLoader().getResources(packagePath);
        }
        catch (IOException e) {
            throw new UtilException(e, "Loading classPath [{}] error!", packagePath);
        }
        HashSet<String> paths = new HashSet<String>();
        while (resources.hasMoreElements()) {
            String string;
            String path = resources.nextElement().getPath();
            paths.add(isDecode ? URLUtil.decode(path, CharsetUtil.systemCharsetName()) : string);
        }
        return var3_4;
    }

    public static String getClassPath() {
        return ClassUtil.getClassPath(false);
    }

    /*
     * WARNING - void declaration
     */
    public static String getClassPath(boolean isEncoded) {
        void var1_2;
        boolean bl;
        URL classPathURL = ClassUtil.getClassPathURL();
        String string = bl ? classPathURL.getPath() : URLUtil.getDecodedPath((URL)var1_2);
        return FileUtil.normalize(string);
    }

    public static URL getClassPathURL() {
        return ClassUtil.getResourceURL("");
    }

    public static URL getResourceURL(String resource) throws IORuntimeException {
        return ResourceUtil.getResource(resource);
    }

    public static List<URL> getResources(String resource) {
        return ResourceUtil.getResources(resource);
    }

    /*
     * WARNING - void declaration
     */
    public static URL getResourceUrl(String resource, Class<?> baseClass) {
        void var1_1;
        return ResourceUtil.getResource(resource, var1_1);
    }

    public static String[] getJavaClassPaths() {
        return System.getProperty("java.class.path").split(System.getProperty("path.separator"));
    }

    public static ClassLoader getContextClassLoader() {
        return ClassLoaderUtil.getContextClassLoader();
    }

    public static ClassLoader getClassLoader() {
        return ClassLoaderUtil.getClassLoader();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAllAssignableFrom(Class<?>[] types1, Class<?>[] types2) {
        if (ArrayUtil.isEmpty(types1) && ArrayUtil.isEmpty(types2)) {
            return true;
        }
        if (types1 == null || types2 == null) {
            return false;
        }
        if (types1.length != types2.length) {
            return false;
        }
        for (int i = 0; i < types1.length; ++i) {
            void var3_4;
            void var2_3;
            Class<?> type1 = types1[i];
            Class<?> type2 = types2[i];
            if (!(ClassUtil.isBasicType(type1) && ClassUtil.isBasicType(type2) ? BasicType.unWrap(type1) != BasicType.unWrap(type2) : false == var2_3.isAssignableFrom((Class<?>)var3_4))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Class<T> loadClass(String className, boolean isInitialized) {
        void var1_1;
        return ClassLoaderUtil.loadClass(className, (boolean)var1_1);
    }

    public static <T> Class<T> loadClass(String className) {
        return ClassUtil.loadClass(className, true);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invoke(String classNameWithMethodName, Object[] args) {
        void var1_1;
        return ClassUtil.invoke(classNameWithMethodName, false, (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invoke(String classNameWithMethodName, boolean isSingleton, Object ... args) {
        void var2_2;
        void var1_1;
        String string;
        void var3_3;
        if (StrUtil.isBlank(classNameWithMethodName)) {
            throw new UtilException("Blank classNameDotMethodName!");
        }
        int splitIndex = classNameWithMethodName.lastIndexOf(35);
        if (splitIndex <= 0) {
            splitIndex = classNameWithMethodName.lastIndexOf(46);
        }
        if (splitIndex <= 0) {
            throw new UtilException("Invalid classNameWithMethodName [{}]!", classNameWithMethodName);
        }
        String className = classNameWithMethodName.substring(0, splitIndex);
        String methodName = classNameWithMethodName.substring((int)(var3_3 + true));
        return ClassUtil.invoke(className, string, (boolean)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invoke(String className, String methodName, Object[] args) {
        void var2_2;
        void var1_1;
        return ClassUtil.invoke(className, (String)var1_1, false, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T invoke(String className, String methodName, boolean isSingleton, Object ... args) {
        Class<T> clazz = ClassUtil.loadClass(className);
        try {
            void var3_3;
            Class<T> clazz2;
            void var2_2;
            Method method = ClassUtil.getDeclaredMethod(clazz, methodName, ClassUtil.getClasses(args));
            if (method == null) {
                void var1_1;
                throw new NoSuchMethodException(StrUtil.format("No such method: [{}]", var1_1));
            }
            if (ClassUtil.isStatic(method)) {
                return ReflectUtil.invoke(null, method, args);
            }
            return ReflectUtil.invoke(var2_2 != false ? Singleton.get(clazz, new Object[0]) : clazz2.newInstance(), method, (Object[])var3_3);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        Class<?> clazz2;
        if (clazz == null) {
            return false;
        }
        return BasicType.WRAPPER_PRIMITIVE_MAP.containsKey(clazz2);
    }

    public static boolean isBasicType(Class<?> clazz) {
        Class<?> clazz2;
        if (clazz == null) {
            return false;
        }
        return clazz.isPrimitive() || ClassUtil.isPrimitiveWrapper(clazz2);
    }

    public static boolean isSimpleTypeOrArray(Class<?> clazz) {
        Class<?> clazz2;
        if (clazz == null) {
            return false;
        }
        return ClassUtil.isSimpleValueType(clazz) || clazz.isArray() && ClassUtil.isSimpleValueType(clazz2.getComponentType());
    }

    public static boolean isSimpleValueType(Class<?> clazz) {
        Class<?> clazz2;
        return ClassUtil.isBasicType(clazz) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.equals(URI.class) || clazz.equals(URL.class) || clazz.equals(Locale.class) || clazz.equals(Class.class) || TemporalAccessor.class.isAssignableFrom(clazz2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAssignable(Class<?> targetType, Class<?> sourceType) {
        void var1_1;
        Class<?> clazz;
        Class<?> resolvedPrimitive;
        if (targetType == null || sourceType == null) {
            return false;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (targetType.isPrimitive()) {
            resolvedPrimitive = BasicType.WRAPPER_PRIMITIVE_MAP.get(sourceType);
            return targetType.equals(resolvedPrimitive);
        }
        Class<?> resolvedWrapper = BasicType.PRIMITIVE_WRAPPER_MAP.get(resolvedPrimitive);
        return resolvedWrapper != null && clazz.isAssignableFrom((Class<?>)var1_1);
    }

    public static boolean isPublic(Class<?> clazz) {
        Class<?> clazz2;
        if (clazz == null) {
            throw new NullPointerException("Class to provided is null.");
        }
        return Modifier.isPublic(clazz2.getModifiers());
    }

    public static boolean isPublic(Method method) {
        Method method2;
        Assert.notNull(method, "Method to provided is null.", new Object[0]);
        return Modifier.isPublic(method2.getModifiers());
    }

    public static boolean isNotPublic(Class<?> clazz) {
        Class<?> clazz2;
        return false == ClassUtil.isPublic(clazz2);
    }

    public static boolean isNotPublic(Method method) {
        Method method2;
        return false == ClassUtil.isPublic(method2);
    }

    public static boolean isStatic(Method method) {
        Method method2;
        Assert.notNull(method, "Method to provided is null.", new Object[0]);
        return Modifier.isStatic(method2.getModifiers());
    }

    public static Method setAccessible(Method method) {
        Method method2;
        if (method != null && !method.isAccessible()) {
            method.setAccessible(true);
        }
        return method2;
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isNormalClass(Class<?> clazz) {
        Class<?> clazz2;
        return clazz != null && false == clazz.isInterface() && false == ClassUtil.isAbstract(clazz) && false == clazz.isEnum() && false == clazz.isArray() && false == clazz.isAnnotation() && false == clazz.isSynthetic() && false == clazz2.isPrimitive();
    }

    public static boolean isEnum(Class<?> clazz) {
        Class<?> clazz2;
        return clazz != null && clazz2.isEnum();
    }

    public static Class<?> getTypeArgument(Class<?> clazz) {
        return ClassUtil.getTypeArgument(clazz, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> getTypeArgument(Class<?> clazz, int index) {
        void var1_1;
        Type type = TypeUtil.getTypeArgument(clazz, (int)var1_1);
        return TypeUtil.getClass(type);
    }

    /*
     * WARNING - void declaration
     */
    public static String getPackage(Class<?> clazz) {
        void var1_1;
        String string;
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(".");
        if (packageEndIndex == -1) {
            return "";
        }
        return string.substring(0, (int)var1_1);
    }

    public static String getPackagePath(Class<?> clazz) {
        return ClassUtil.getPackage(clazz).replace('.', '/');
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            Class<?> clazz2;
            return ClassUtil.getPrimitiveDefaultValue(clazz2);
        }
        return null;
    }

    public static Object getPrimitiveDefaultValue(Class<?> clazz) {
        Class<?> clazz2;
        if (Long.TYPE == clazz) {
            return 0L;
        }
        if (Integer.TYPE == clazz) {
            return 0;
        }
        if (Short.TYPE == clazz) {
            return (short)0;
        }
        if (Character.TYPE == clazz) {
            return Character.valueOf('\u0000');
        }
        if (Byte.TYPE == clazz) {
            return (byte)0;
        }
        if (Double.TYPE == clazz) {
            return 0.0;
        }
        if (Float.TYPE == clazz) {
            return Float.valueOf(0.0f);
        }
        if (Boolean.TYPE == clazz2) {
            return Boolean.FALSE;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Object[] getDefaultValues(Class<?> ... classes) {
        void var1_1;
        Object[] values = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            values[i] = ClassUtil.getDefaultValue(classes[i]);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isJdkClass(Class<?> clazz) {
        Class<?> clazz2;
        void var1_1;
        Package objectPackage = clazz.getPackage();
        if (objectPackage == null) {
            return false;
        }
        String objectPackageName = objectPackage.getName();
        return objectPackageName.startsWith("java.") || var1_1.startsWith("javax.") || clazz2.getClassLoader() == null;
    }

    public static URL getLocation(Class<?> clazz) {
        Class<?> clazz2;
        if (clazz == null) {
            return null;
        }
        return clazz2.getProtectionDomain().getCodeSource().getLocation();
    }

    public static String getLocationPath(Class<?> clazz) {
        Serializable serializable;
        Serializable location = ClassUtil.getLocation(clazz);
        if (location == null) {
            return null;
        }
        return ((URL)serializable).getPath();
    }

    public static boolean isAbstractOrInterface(Class<?> clazz) {
        Class<?> clazz2;
        return ClassUtil.isAbstract(clazz) || ClassUtil.isInterface(clazz2);
    }

    public static boolean isInterface(Class<?> clazz) {
        return clazz.isInterface();
    }
}

