/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.convert.BasicType;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.JarClassLoader;
import cn.hutool.core.map.SafeConcurrentHashMap;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ClassLoaderUtil {
    private static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char INNER_CLASS_SEPARATOR = '$';
    private static final Map<String, Class<?>> PRIMITIVE_TYPE_NAME_MAP;

    public static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }

    public static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    }

    /*
     * WARNING - void declaration
     */
    public static ClassLoader getClassLoader() {
        void var0;
        ClassLoader classLoader = ClassLoaderUtil.getContextClassLoader();
        if (classLoader == null && (classLoader = ClassLoaderUtil.class.getClassLoader()) == null) {
            classLoader = ClassLoaderUtil.getSystemClassLoader();
        }
        return var0;
    }

    public static Class<?> loadClass(String name) throws UtilException {
        return ClassLoaderUtil.loadClass(name, true);
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> loadClass(String name, boolean isInitialized) throws UtilException {
        void var1_1;
        return ClassLoaderUtil.loadClass(name, null, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> loadClass(String name, ClassLoader classLoader, boolean isInitialized) throws UtilException {
        void var3_3;
        Class<?> clazz;
        Assert.notNull(name, "Name must not be null", new Object[0]);
        name = name.replace('/', '.');
        if (classLoader == null) {
            classLoader = ClassLoaderUtil.getClassLoader();
        }
        if ((clazz = ClassLoaderUtil.loadPrimitiveClass(name)) == null) {
            void var2_2;
            void var1_1;
            String string;
            clazz = ClassLoaderUtil.doLoadClass(string, (ClassLoader)var1_1, (boolean)var2_2);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> loadPrimitiveClass(String name) {
        void var1_1;
        Class<?> result = null;
        if (StrUtil.isNotBlank(name) && (name = name.trim()).length() <= 8) {
            String string;
            result = PRIMITIVE_TYPE_NAME_MAP.get(string);
        }
        return var1_1;
    }

    public static JarClassLoader getJarClassLoader(File jarOrDir) {
        return JarClassLoader.load(jarOrDir);
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> loadClass(File jarOrDir, String name) {
        try {
            void var1_2;
            return ClassLoaderUtil.getJarClassLoader(jarOrDir).loadClass((String)var1_2);
        }
        catch (ClassNotFoundException e) {
            void var0_1;
            throw new UtilException((Throwable)var0_1);
        }
    }

    public static boolean isPresent(String className) {
        return ClassLoaderUtil.isPresent(className, null);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            void var1_1;
            ClassLoaderUtil.loadClass(className, (ClassLoader)var1_1, false);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Class<?> doLoadClass(String name, ClassLoader classLoader, boolean isInitialized) {
        void var3_7;
        block9: {
            Class<?> clazz;
            if (((String)((Object)name)).endsWith(ARRAY_SUFFIX)) {
                String string = ((String)((Object)name)).substring(0, ((String)((Object)name)).length() - 2);
                name = ClassLoaderUtil.loadClass(string, classLoader, isInitialized);
                clazz = Array.newInstance(name, 0).getClass();
            } else if (((String)((Object)name)).startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && ((String)((Object)name)).endsWith(";")) {
                String string = ((String)((Object)name)).substring(2, ((String)((Object)name)).length() - 1);
                name = ClassLoaderUtil.loadClass(string, classLoader, isInitialized);
                clazz = Array.newInstance(name, 0).getClass();
            } else if (((String)((Object)name)).startsWith(INTERNAL_ARRAY_PREFIX)) {
                String string = ((String)((Object)name)).substring(1);
                name = ClassLoaderUtil.loadClass(string, classLoader, isInitialized);
                clazz = Array.newInstance(name, 0).getClass();
            } else {
                if (classLoader == null) {
                    classLoader = ClassLoaderUtil.getClassLoader();
                }
                try {
                    clazz = Class.forName((String)((Object)name), isInitialized, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    void var2_2;
                    void var1_1;
                    String string;
                    clazz = ClassLoaderUtil.tryLoadInnerClass(string, (ClassLoader)var1_1, (boolean)var2_2);
                    if (clazz != null) break block9;
                    throw new UtilException(ex);
                }
            }
        }
        return var3_7;
    }

    /*
     * WARNING - void declaration
     */
    private static Class<?> tryLoadInnerClass(String name, ClassLoader classLoader, boolean isInitialized) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex > 0) {
            void var3_3;
            String innerClassName = name.substring(0, lastDotIndex) + '$' + name.substring((int)(var3_3 + true));
            try {
                void var1_1;
                void var2_2;
                String string;
                return Class.forName(string, (boolean)var2_2, (ClassLoader)var1_1);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static {
        Iterator iterator;
        PRIMITIVE_TYPE_NAME_MAP = new SafeConcurrentHashMap(32);
        ArrayList primitiveTypes = new ArrayList(32);
        primitiveTypes.addAll(BasicType.PRIMITIVE_WRAPPER_MAP.keySet());
        primitiveTypes.add(boolean[].class);
        primitiveTypes.add(byte[].class);
        primitiveTypes.add(char[].class);
        primitiveTypes.add(double[].class);
        primitiveTypes.add(float[].class);
        primitiveTypes.add(int[].class);
        primitiveTypes.add(long[].class);
        primitiveTypes.add(short[].class);
        primitiveTypes.add(Void.TYPE);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var1_1;
            Class primitiveType = (Class)iterator.next();
            PRIMITIVE_TYPE_NAME_MAP.put(primitiveType.getName(), (Class<?>)var1_1);
        }
    }
}

