/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.io.CharsetDetector;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;

public class CharsetUtil {
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    public static final String GBK = "GBK";
    public static final Charset CHARSET_ISO_8859_1;
    public static final Charset CHARSET_UTF_8;
    public static final Charset CHARSET_GBK;

    public static Charset charset(String charsetName) throws UnsupportedCharsetException {
        String string;
        if (StrUtil.isBlank(charsetName)) {
            return Charset.defaultCharset();
        }
        return Charset.forName(string);
    }

    public static Charset parse(String charsetName) {
        return CharsetUtil.parse(charsetName, Charset.defaultCharset());
    }

    /*
     * WARNING - void declaration
     */
    public static Charset parse(String charsetName, Charset defaultCharset) {
        Object object;
        Object result;
        if (StrUtil.isBlank(charsetName)) {
            return defaultCharset;
        }
        try {
            result = Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            void var1_1;
            result = var1_1;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static String convert(String source, String srcCharset, String destCharset) {
        void var2_2;
        void var1_1;
        return CharsetUtil.convert(source, Charset.forName((String)var1_1), Charset.forName((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static String convert(String source, Charset srcCharset, Charset destCharset) {
        void var2_2;
        void var1_1;
        String string;
        if (srcCharset == null) {
            srcCharset = StandardCharsets.ISO_8859_1;
        }
        if (destCharset == null) {
            destCharset = StandardCharsets.UTF_8;
        }
        if (StrUtil.isBlank(source) || srcCharset.equals(destCharset)) {
            return source;
        }
        return new String(string.getBytes((Charset)var1_1), (Charset)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static File convert(File file, Charset srcCharset, Charset destCharset) {
        void var2_2;
        File file2;
        String string;
        string = FileUtil.readString(file, (Charset)((Object)string));
        return FileUtil.writeString(string, file2, (Charset)var2_2);
    }

    public static String systemCharsetName() {
        return CharsetUtil.systemCharset().name();
    }

    public static Charset systemCharset() {
        if (FileUtil.isWindows()) {
            return CHARSET_GBK;
        }
        return CharsetUtil.defaultCharset();
    }

    public static String defaultCharsetName() {
        return CharsetUtil.defaultCharset().name();
    }

    public static Charset defaultCharset() {
        return Charset.defaultCharset();
    }

    /*
     * WARNING - void declaration
     */
    public static Charset defaultCharset(InputStream in, Charset ... charsets) {
        void var1_1;
        return CharsetDetector.detect(in, (Charset[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Charset defaultCharset(int bufferSize, InputStream in, Charset ... charsets) {
        void var2_2;
        void var1_1;
        return CharsetDetector.detect(bufferSize, (InputStream)var1_1, (Charset[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        CHARSET_ISO_8859_1 = StandardCharsets.ISO_8859_1;
        CHARSET_UTF_8 = StandardCharsets.UTF_8;
        Charset _CHARSET_GBK = null;
        try {
            _CHARSET_GBK = Charset.forName(GBK);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {}
        CHARSET_GBK = var0;
    }
}

