/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.text.ASCIIStrCache;
import cn.hutool.core.text.CharPool;

public class CharUtil
implements CharPool {
    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiPrintable(char ch) {
        char c;
        return ch >= ' ' && c < '\u007f';
    }

    public static boolean isAsciiControl(char ch) {
        char c;
        return ch < ' ' || c == '\u007f';
    }

    public static boolean isLetter(char ch) {
        char c;
        return CharUtil.isLetterUpper(ch) || CharUtil.isLetterLower(c);
    }

    public static boolean isLetterUpper(char ch) {
        char c;
        return ch >= 'A' && c <= 'Z';
    }

    public static boolean isLetterLower(char ch) {
        char c;
        return ch >= 'a' && c <= 'z';
    }

    public static boolean isNumber(char ch) {
        char c;
        return ch >= '0' && c <= '9';
    }

    public static boolean isHexChar(char c) {
        char c2;
        return CharUtil.isNumber(c) || c >= 'a' && c <= 'f' || c >= 'A' && c2 <= 'F';
    }

    public static boolean isLetterOrNumber(char ch) {
        char c;
        return CharUtil.isLetter(ch) || CharUtil.isNumber(c);
    }

    public static String toString(char c) {
        return ASCIIStrCache.toString(c);
    }

    public static boolean isCharClass(Class<?> clazz) {
        Class<?> clazz2;
        return clazz == Character.class || clazz2 == Character.TYPE;
    }

    public static boolean isChar(Object value) {
        Object object;
        return value instanceof Character || object.getClass() == Character.TYPE;
    }

    public static boolean isBlankChar(char c) {
        return CharUtil.isBlankChar((int)c);
    }

    public static boolean isBlankChar(int c) {
        int n;
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234 || c == 0 || c == 12644 || c == 10240 || n == 6158;
    }

    public static boolean isEmoji(char c) {
        char c2;
        return false == (c == '\u0000' || c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u100000' && c2 <= '\u10ffff');
    }

    public static boolean isFileSeparator(char c) {
        char c2;
        return '/' == c || '\\' == c2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean equals(char c1, char c2, boolean caseInsensitive) {
        void var1_1;
        char c;
        if (caseInsensitive) {
            return Character.toLowerCase(c1) == Character.toLowerCase(c2);
        }
        return c == var1_1;
    }

    public static int getType(int c) {
        return Character.getType(c);
    }

    public static int digit16(int b) {
        return Character.digit(b, 16);
    }

    /*
     * WARNING - void declaration
     */
    public static char toCloseChar(char c) {
        void var1_1;
        int result = c;
        if (c >= 49 && c <= 57) {
            result = c + 9312 - 49;
        } else if (c >= 65 && c <= 90) {
            result = c + 9398 - 65;
        } else if (c >= 97 && c <= 122) {
            char c2;
            result = c2 + 9424 - 97;
        }
        return (char)var1_1;
    }

    public static char toCloseByNumber(int number) {
        int n;
        if (number > 20) {
            throw new IllegalArgumentException("Number must be [1-20]");
        }
        return (char)(n + 9312 - 1);
    }
}

